/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.Illuminant;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.WhitePointColorSpace;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.LUVColorSpace;
import com.github.ajalt.colormath.model.XYZKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0017H\u0016J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J)\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020 H\u0096\u0002J\b\u0010$\u001a\u00020\u000bH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Lcom/github/ajalt/colormath/model/LUVColorSpaceImpl;", "Lcom/github/ajalt/colormath/model/LUVColorSpace;", "whitePoint", "Lcom/github/ajalt/colormath/WhitePoint;", "(Lcom/github/ajalt/colormath/WhitePoint;)V", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "name", "", "getName", "()Ljava/lang/String;", "getWhitePoint", "()Lcom/github/ajalt/colormath/WhitePoint;", "component1", "convert", "Lcom/github/ajalt/colormath/model/LUV;", "color", "Lcom/github/ajalt/colormath/Color;", "copy", "create", "", "equals", "", "other", "", "hashCode", "", "invoke", "l", "", "u", "v", "alpha", "toString", "colormath"})
@SourceDebugExtension(value={"SMAP\nLUV.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LUV.kt\ncom/github/ajalt/colormath/model/LUVColorSpaceImpl\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n35#2,4:111\n26#2:115\n15#2,13:116\n1#3:129\n*S KotlinDebug\n*F\n+ 1 LUV.kt\ncom/github/ajalt/colormath/model/LUVColorSpaceImpl\n*L\n31#1:111,4\n32#1:115\n32#1:116,13\n32#1:129\n*E\n"})
final class LUVColorSpaceImpl
implements LUVColorSpace {
    @NotNull
    private final WhitePoint whitePoint;
    @NotNull
    private final List<ColorComponentInfo> components;

    public LUVColorSpaceImpl(@NotNull WhitePoint whitePoint) {
        Intrinsics.checkNotNullParameter(whitePoint, "whitePoint");
        this.whitePoint = whitePoint;
        this.components = ColorSpaceUtilsKt.threeComponentInfo("L", 0.0f, 100.0f, "U", -100.0f, 100.0f, "V", -100.0f, 100.0f);
    }

    @Override
    @NotNull
    public WhitePoint getWhitePoint() {
        return this.whitePoint;
    }

    @Override
    @NotNull
    public String getName() {
        return "LUV";
    }

    @Override
    @NotNull
    public List<ColorComponentInfo> getComponents() {
        return this.components;
    }

    @Override
    @NotNull
    public LUV convert(@NotNull Color color) {
        Color color2;
        Intrinsics.checkNotNullParameter(color, "color");
        WhitePointColorSpace $this$adaptToThis$iv = this;
        boolean $i$f$adaptToThis = false;
        ColorSpace<?> colorSpace = color.getSpace();
        Object object = colorSpace instanceof WhitePointColorSpace ? (WhitePointColorSpace)colorSpace : null;
        if (object == null || (object = object.getWhitePoint()) == null) {
            object = Illuminant.INSTANCE.getD65();
        }
        if (Intrinsics.areEqual(object, $this$adaptToThis$iv.getWhitePoint())) {
            Color it = color;
            boolean bl = false;
            color2 = it.toLUV();
        } else {
            Color it = color.toXYZ().adaptTo(XYZKt.XYZColorSpace($this$adaptToThis$iv.getWhitePoint()));
            boolean bl = false;
            color2 = it.toLUV();
        }
        return (LUV)color2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LUV create(@NotNull float[] components) {
        void p3;
        void p2;
        void p1;
        float f;
        Intrinsics.checkNotNullParameter(components, "components");
        ColorSpace $this$doCreate$iv = this;
        boolean $i$f$doCreate = false;
        ColorSpace $this$withValidComps$iv$iv = $this$doCreate$iv;
        boolean $i$f$withValidComps = false;
        int size$iv$iv = $this$withValidComps$iv$iv.getComponents().size();
        int n = size$iv$iv - 1;
        int n2 = components.length;
        if (!(n <= n2 ? n2 <= size$iv$iv : false)) {
            boolean bl = false;
            String string = "Invalid component array length: " + components.length + ", expected " + (size$iv$iv - 1) + " or " + size$iv$iv;
            throw new IllegalArgumentException(string.toString());
        }
        float[] it$iv = components;
        boolean bl = false;
        float f2 = components[0];
        float f3 = components[1];
        float f4 = components[2];
        int n3 = 3;
        float[] fArray = components;
        if (n3 <= ArraysKt.getLastIndex(fArray)) {
            f = fArray[n3];
        } else {
            int n4 = n3;
            float f5 = f4;
            float f6 = f3;
            float f7 = f2;
            boolean bl2 = false;
            float f8 = 1.0f;
            f2 = f7;
            f3 = f6;
            f4 = f5;
            f = f8;
        }
        float f9 = f;
        float f10 = f4;
        float f11 = f3;
        float p0 = f2;
        boolean bl3 = false;
        return (LUV)((Color)this.invoke(p0, (float)p1, (float)p2, (float)p3));
    }

    @NotNull
    public String toString() {
        return "LUVColorSpace(" + this.getWhitePoint() + ')';
    }

    @Override
    @NotNull
    public LUV invoke(float l, float u, float v, float alpha) {
        return new LUV(l, u, v, alpha, this);
    }

    public int hashCode() {
        return this.getWhitePoint().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof LUVColorSpace && Intrinsics.areEqual(this.getWhitePoint(), ((LUVColorSpace)other).getWhitePoint());
    }

    @Override
    @NotNull
    public LUV invoke(@NotNull Number l, @NotNull Number u, @NotNull Number v, @NotNull Number alpha) {
        return LUVColorSpace.DefaultImpls.invoke(this, l, u, v, alpha);
    }

    @NotNull
    public final WhitePoint component1() {
        return this.whitePoint;
    }

    @NotNull
    public final LUVColorSpaceImpl copy(@NotNull WhitePoint whitePoint) {
        Intrinsics.checkNotNullParameter(whitePoint, "whitePoint");
        return new LUVColorSpaceImpl(whitePoint);
    }

    public static /* synthetic */ LUVColorSpaceImpl copy$default(LUVColorSpaceImpl lUVColorSpaceImpl, WhitePoint whitePoint, int n, Object object) {
        if ((n & 1) != 0) {
            whitePoint = lUVColorSpaceImpl.whitePoint;
        }
        return lUVColorSpaceImpl.copy(whitePoint);
    }
}

