/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessInfo {
    public static final ProcessInfo[] EMPTY_ARRAY = new ProcessInfo[0];
    private final int myPid;
    private final int myParentPid;
    @NotNull
    private final String myCommandLine;
    @NotNull
    private final Optional<String> myExecutablePath;
    @NotNull
    private final String myExecutableName;
    @NotNull
    private final String myArgs;
    @Nullable
    private final String myUser;
    @NotNull
    private final ThreeState myOwnedByCurrentUser;

    public ProcessInfo(int pid, @NotNull String commandLine, @NotNull String executableName, @NotNull String args) {
        if (commandLine == null) {
            ProcessInfo.$$$reportNull$$$0(0);
        }
        if (executableName == null) {
            ProcessInfo.$$$reportNull$$$0(1);
        }
        if (args == null) {
            ProcessInfo.$$$reportNull$$$0(2);
        }
        this(pid, commandLine, executableName, args, null, -1);
    }

    public ProcessInfo(int pid, @NotNull String commandLine, @NotNull String executableName, @NotNull String args, @Nullable String executablePath) {
        if (commandLine == null) {
            ProcessInfo.$$$reportNull$$$0(3);
        }
        if (executableName == null) {
            ProcessInfo.$$$reportNull$$$0(4);
        }
        if (args == null) {
            ProcessInfo.$$$reportNull$$$0(5);
        }
        this(pid, commandLine, executableName, args, executablePath, -1);
    }

    public ProcessInfo(int pid, @NotNull String commandLine, @NotNull String executableName, @NotNull String args, @Nullable String executablePath, int parentPid) {
        if (commandLine == null) {
            ProcessInfo.$$$reportNull$$$0(6);
        }
        if (executableName == null) {
            ProcessInfo.$$$reportNull$$$0(7);
        }
        if (args == null) {
            ProcessInfo.$$$reportNull$$$0(8);
        }
        this(pid, commandLine, executableName, args, executablePath, parentPid, null, ThreeState.UNSURE);
    }

    public ProcessInfo(int pid, @NotNull String commandLine, @NotNull String executableName, @NotNull String args, @Nullable String executablePath, int parentPid, @Nullable String user, @NotNull ThreeState isOwnedByCurrentUser) {
        if (commandLine == null) {
            ProcessInfo.$$$reportNull$$$0(9);
        }
        if (executableName == null) {
            ProcessInfo.$$$reportNull$$$0(10);
        }
        if (args == null) {
            ProcessInfo.$$$reportNull$$$0(11);
        }
        if (isOwnedByCurrentUser == null) {
            ProcessInfo.$$$reportNull$$$0(12);
        }
        this.myPid = pid;
        this.myCommandLine = commandLine;
        this.myExecutableName = executableName;
        this.myExecutablePath = StringUtil.isNotEmpty((String)executablePath) ? Optional.of(executablePath) : Optional.empty();
        this.myArgs = args;
        this.myParentPid = parentPid;
        this.myUser = user;
        this.myOwnedByCurrentUser = isOwnedByCurrentUser;
    }

    public int getPid() {
        return this.myPid;
    }

    public int getParentPid() {
        return this.myParentPid;
    }

    @NotNull
    @NlsSafe
    public String getCommandLine() {
        String string = this.myCommandLine;
        if (string == null) {
            ProcessInfo.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getExecutableName() {
        String string = this.myExecutableName;
        if (string == null) {
            ProcessInfo.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public Optional<String> getExecutableCannonicalPath() {
        Optional<String> optional = this.myExecutablePath.map(s -> {
            try {
                return new File((String)s).getCanonicalPath();
            }
            catch (IOException e) {
                return s;
            }
        });
        if (optional == null) {
            ProcessInfo.$$$reportNull$$$0(15);
        }
        return optional;
    }

    @NotNull
    @NlsSafe
    public String getExecutableDisplayName() {
        String string = StringUtil.trimEnd((String)this.myExecutableName, (String)".exe", (boolean)true);
        if (string == null) {
            ProcessInfo.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getArgs() {
        String string = this.myArgs;
        if (string == null) {
            ProcessInfo.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getUser() {
        return this.myUser;
    }

    @NotNull
    public ThreeState isOwnedByCurrentUser() {
        ThreeState threeState = this.myOwnedByCurrentUser;
        if (threeState == null) {
            ProcessInfo.$$$reportNull$$$0(18);
        }
        return threeState;
    }

    public String toString() {
        return this.myPid + (String)(this.myUser != null ? " " + this.myUser : "") + " '" + this.myCommandLine + "' '" + this.myExecutableName + "' '" + this.myArgs + "'" + this.myExecutablePath.map(s -> " " + s).orElse("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInfo info = (ProcessInfo)o;
        if (this.myPid != info.myPid) {
            return false;
        }
        if (!this.myExecutableName.equals(info.myExecutableName)) {
            return false;
        }
        if (!this.myArgs.equals(info.myArgs)) {
            return false;
        }
        if (!this.myCommandLine.equals(info.myCommandLine)) {
            return false;
        }
        if (!this.myExecutablePath.equals(info.myExecutablePath)) {
            return false;
        }
        if (this.myParentPid != info.myParentPid) {
            return false;
        }
        if (!Objects.equals(this.myUser, ((ProcessInfo)o).myUser)) {
            return false;
        }
        return this.myOwnedByCurrentUser.equals((Object)((ProcessInfo)o).myOwnedByCurrentUser);
    }

    public int hashCode() {
        int result = this.myPid;
        result = 31 * result + this.myExecutableName.hashCode();
        result = 31 * result + this.myArgs.hashCode();
        result = 31 * result + this.myCommandLine.hashCode();
        result = 31 * result + this.myParentPid;
        result = 31 * result + (this.myUser != null ? this.myUser.hashCode() : 0);
        result = 31 * result + this.myOwnedByCurrentUser.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 15, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableName";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isOwnedByCurrentUser";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/ProcessInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/ProcessInfo";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLine";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutableName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutableCannonicalPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutableDisplayName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgs";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "isOwnedByCurrentUser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 15, 16, 17, 18 -> new IllegalStateException(string);
        };
    }
}

