/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PySyntheticCallHelper;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PyDescriptorTypeUtil {
    private PyDescriptorTypeUtil() {
    }

    @Nullable
    public static Ref<PyType> getDunderGetReturnType(@NotNull PyQualifiedExpression expression, @Nullable PyType attributeType, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyDescriptorTypeUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyDescriptorTypeUtil.$$$reportNull$$$0(1);
        }
        if (!expression.isQualified()) {
            return null;
        }
        PyClassLikeType targetType = PyUtil.as(attributeType, PyClassLikeType.class);
        if (targetType == null || targetType.isDefinition()) {
            return null;
        }
        PyResolveContext resolveContext = PyResolveContext.noProperties(context);
        List<? extends RatedResolveResult> members = targetType.resolveMember("__get__", expression, AccessDirection.READ, resolveContext);
        if (members == null || members.isEmpty()) {
            return null;
        }
        return PyDescriptorTypeUtil.getTypeFromSyntheticDunderGetCall(expression, attributeType, context);
    }

    @Nullable
    public static Ref<PyType> getExpectedValueTypeForDunderSet(@NotNull PyTargetExpression targetExpression, @Nullable PyType attributeType, @NotNull TypeEvalContext context) {
        PyClassLikeType targetType;
        if (targetExpression == null) {
            PyDescriptorTypeUtil.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyDescriptorTypeUtil.$$$reportNull$$$0(3);
        }
        if ((targetType = PyUtil.as(attributeType, PyClassLikeType.class)) == null || targetType.isDefinition()) {
            return null;
        }
        PyResolveContext resolveContext = PyResolveContext.noProperties(context);
        List<? extends RatedResolveResult> members = targetType.resolveMember("__set__", targetExpression, AccessDirection.READ, resolveContext);
        if (members == null || members.isEmpty()) {
            return null;
        }
        return PyDescriptorTypeUtil.getExpectedTypeFromDunderSet(targetExpression, attributeType, context);
    }

    @Nullable
    private static Ref<PyType> getTypeFromSyntheticDunderGetCall(@NotNull PyQualifiedExpression expression, @NotNull PyType attributeType, @NotNull TypeEvalContext context) {
        PyExpression qualifier;
        if (expression == null) {
            PyDescriptorTypeUtil.$$$reportNull$$$0(4);
        }
        if (attributeType == null) {
            PyDescriptorTypeUtil.$$$reportNull$$$0(5);
        }
        if (context == null) {
            PyDescriptorTypeUtil.$$$reportNull$$$0(6);
        }
        if ((qualifier = expression.getQualifier()) != null && attributeType instanceof PyCallableType) {
            PyCallableType receiverType = (PyCallableType)attributeType;
            PyType qualifierType = context.getType(qualifier);
            if (qualifierType instanceof PyClassType) {
                PyClassType instanceTypeArgument;
                PyClassType instanceArgumentType;
                PyClassType classType = (PyClassType)qualifierType;
                PyClassType noneType2 = PyBuiltinCache.getInstance((PsiElement)expression).getNoneType();
                if (noneType2 == null) {
                    return null;
                }
                if (classType.isDefinition()) {
                    instanceArgumentType = noneType2;
                    instanceTypeArgument = classType;
                } else {
                    instanceArgumentType = classType;
                    instanceTypeArgument = noneType2;
                }
                List<PyType> argumentTypes = List.of(instanceArgumentType, instanceTypeArgument);
                PyType type2 = PySyntheticCallHelper.getCallTypeByFunctionName("__get__", receiverType, argumentTypes, context);
                return Ref.create((Object)type2);
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getExpectedTypeFromDunderSet(@NotNull PyQualifiedExpression expression, @NotNull PyType attributeType, @NotNull TypeEvalContext context) {
        PyClassType classType;
        PyType qualifierType;
        if (expression == null) {
            PyDescriptorTypeUtil.$$$reportNull$$$0(7);
        }
        if (attributeType == null) {
            PyDescriptorTypeUtil.$$$reportNull$$$0(8);
        }
        if (context == null) {
            PyDescriptorTypeUtil.$$$reportNull$$$0(9);
        }
        PyExpression qualifier = expression.getQualifier();
        PyType objectArgumentType = PyBuiltinCache.getInstance((PsiElement)expression).getNoneType();
        Object valueArgumentType = null;
        if (qualifier != null && attributeType instanceof PyCallableType && (qualifierType = context.getType(qualifier)) instanceof PyClassType && !(classType = (PyClassType)qualifierType).isDefinition()) {
            objectArgumentType = qualifierType;
        }
        ArrayList<PyType> argumentTypes = new ArrayList<PyType>();
        argumentTypes.add(objectArgumentType);
        argumentTypes.add((PyType)valueArgumentType);
        List<PyFunction> functions = PySyntheticCallHelper.resolveFunctionsByArgumentTypes("__set__", argumentTypes, attributeType, context);
        if (functions.isEmpty()) {
            return null;
        }
        return Ref.create((Object)PyDescriptorTypeUtil.getExpectedDunderSetValueType(functions.get(0), attributeType, context));
    }

    @Nullable
    private static PyType getExpectedDunderSetValueType(@NotNull PyFunction function, @NotNull PyType receiverType, @NotNull TypeEvalContext context) {
        PyType type2;
        List parameters;
        if (function == null) {
            PyDescriptorTypeUtil.$$$reportNull$$$0(10);
        }
        if (receiverType == null) {
            PyDescriptorTypeUtil.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PyDescriptorTypeUtil.$$$reportNull$$$0(12);
        }
        if ((parameters = function.getParameters(context)).size() != 3) {
            return null;
        }
        PyCallableParameter valueParameter = (PyCallableParameter)parameters.get(2);
        if (valueParameter != null && (type2 = valueParameter.getArgumentType(context)) != null && receiverType instanceof PyClassType) {
            PyTypeChecker.GenericSubstitutions subs = PyTypeChecker.unifyReceiver(receiverType, context);
            return PyTypeChecker.substitute(type2, subs, context);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetExpression";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverType";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/types/PyDescriptorTypeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDunderGetReturnType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpectedValueTypeForDunderSet";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeFromSyntheticDunderGetCall";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpectedTypeFromDunderSet";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpectedDunderSetValueType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

