"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Random = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _predicate = require("./predicate");
var _utils = require("./utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var defaultRand = Math.random;
var Random = function Random() {
  var _this = this;
  var rand = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : defaultRand;
  _classCallCheck(this, Random);
  _defineProperty(this, "rand", void 0);
  _defineProperty(this, "boolean", function () {
    return _this.rand() > 0.5;
  });
  _defineProperty(this, "number", function () {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var min = (0, _predicate.isNil)(options.min) ? Number.MIN_VALUE : options.min;
    var max = (0, _predicate.isNil)(options.max) ? Number.MAX_VALUE : options.max;
    var delta = _this.rand() * (max - min);
    return min + delta;
  });
  _defineProperty(this, "integer", function () {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var min = Math.ceil((0, _predicate.isNil)(options.min) ? Number.MIN_VALUE : options.min);
    var max = Math.floor((0, _predicate.isNil)(options.max) ? Number.MAX_VALUE : options.max);
    var delta = Math.floor(_this.rand() * (max - min + 1));
    return min + delta;
  });
  _defineProperty(this, "oneOf", function (values) {
    return values[Math.floor(_this.rand() * values.length)];
  });
  _defineProperty(this, "oneToOne", function (values, index) {
    return values[index];
  });
  _defineProperty(this, "setOf", function (values) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var count = _this.integer(_objectSpread({
      min: 0,
      max: values.length
    }, options));
    var copy = _toConsumableArray(values);
    return (0, _utils.times)(count, function () {
      var value = _this.oneOf(copy);
      copy.splice(copy.indexOf(value), 1);
      return value;
    });
  });
  _defineProperty(this, "date", function () {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var min = (0, _predicate.isNil)(options.min) ? new Date(0) : options.min;
    var max = (0, _predicate.isNil)(options.max) ? new Date(Date.now()) : options.max;
    var minMls = min.getTime();
    var maxMls = max.getTime();
    var time = _this.integer({
      min: minMls,
      max: maxMls
    });
    return new Date(time);
  });
  _defineProperty(this, "moment", function () {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var min = (0, _predicate.isNil)(options.min) ? (0, _moment.default)(0) : options.min;
    var max = (0, _predicate.isNil)(options.max) ? (0, _moment.default)() : options.max;
    var minMls = +min;
    var maxMls = +max;
    var time = _this.integer({
      min: minMls,
      max: maxMls
    });
    return (0, _moment.default)(time);
  });
  this.rand = rand;
};
exports.Random = Random;