/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.action;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.commons.alerting.util.IndexUtils;
import org.opensearch.commons.utils.ValidationHelpersKt;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001d\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0013\u001a\u00020\u0006J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/alerting/action/GetRemoteIndexesRequest;", "Lorg/opensearch/action/ActionRequest;", "indexes", "", "", "includeMappings", "", "(Ljava/util/List;Z)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getIncludeMappings", "()Z", "setIncludeMappings", "(Z)V", "getIndexes", "()Ljava/util/List;", "setIndexes", "(Ljava/util/List;)V", "isValid", "validPattern", "pattern", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nGetRemoteIndexesRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetRemoteIndexesRequest.kt\norg/opensearch/alerting/action/GetRemoteIndexesRequest\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n37#2,2:78\n1726#3,3:80\n*S KotlinDebug\n*F\n+ 1 GetRemoteIndexesRequest.kt\norg/opensearch/alerting/action/GetRemoteIndexesRequest\n*L\n37#1:78,2\n46#1:80,3\n*E\n"})
public final class GetRemoteIndexesRequest
extends ActionRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<String> indexes;
    private boolean includeMappings;
    @NotNull
    public static final String INVALID_PATTERN_MESSAGE = "Indexes includes an invalid pattern.";
    @NotNull
    public static final String INDEXES_FIELD = "indexes";
    @NotNull
    public static final String INCLUDE_MAPPINGS_FIELD = "include_mappings";

    @NotNull
    public final List<String> getIndexes() {
        return this.indexes;
    }

    public final void setIndexes(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.indexes = list;
    }

    public final boolean getIncludeMappings() {
        return this.includeMappings;
    }

    public final void setIncludeMappings(boolean bl) {
        this.includeMappings = bl;
    }

    public GetRemoteIndexesRequest(@NotNull List<String> indexes, boolean includeMappings) {
        Intrinsics.checkNotNullParameter(indexes, (String)INDEXES_FIELD);
        this.indexes = CollectionsKt.emptyList();
        this.indexes = indexes;
        this.includeMappings = includeMappings;
    }

    public GetRemoteIndexesRequest(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        List list = sin.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readStringList(...)");
        this(list, sin.readBoolean());
    }

    @Nullable
    public ActionRequestValidationException validate() {
        return null;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Collection $this$toTypedArray$iv = this.indexes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        out.writeStringArray(thisCollection$iv.toArray(new String[0]));
        out.writeBoolean(this.includeMappings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValid() {
        String it;
        if (((Collection)this.indexes).isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        Iterable $this$all$iv = this.indexes;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl2 = false;
        } while (this.validPattern(it));
        return false;
    }

    private final boolean validPattern(String pattern) {
        boolean bl;
        int separatorIndex = StringsKt.lastIndexOf$default((CharSequence)pattern, (String)":", (int)0, (boolean)false, (int)6, null);
        if (separatorIndex == -1) {
            bl = IndexUtils.Companion.getINDEX_PATTERN_REGEX().matches((CharSequence)pattern);
        } else {
            String string = pattern.substring(0, separatorIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String clusterPattern = string;
            String string2 = pattern.substring(separatorIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String indexPattern = string2;
            bl = ValidationHelpersKt.getCLUSTER_PATTERN_REGEX().matches((CharSequence)clusterPattern) && IndexUtils.Companion.getINDEX_PATTERN_REGEX().matches((CharSequence)indexPattern);
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/alerting/action/GetRemoteIndexesRequest$Companion;", "", "()V", "INCLUDE_MAPPINGS_FIELD", "", "INDEXES_FIELD", "INVALID_PATTERN_MESSAGE", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

