/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.JaffreeException;
import com.github.kokorin.jaffree.OS;
import com.github.kokorin.jaffree.ffmpeg.BaseInput;
import com.github.kokorin.jaffree.ffmpeg.Input;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CaptureInput<T extends CaptureInput<T>>
extends BaseInput<T>
implements Input {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaptureInput.class);

    protected CaptureInput(String input) {
        super(input);
    }

    public CaptureInput<T> setCaptureFrameRate(Number value) {
        return (CaptureInput)this.addArguments("-framerate", String.valueOf(value));
    }

    @Override
    public T setFrameRate(String streamSpecifier, Number value) {
        LOGGER.warn("Be careful not to specify framerate with the \"-r\" parameter, rather use setCaptureFrameRate method or \"-framerate\" parameter");
        return (T)((CaptureInput)super.setFrameRate(streamSpecifier, value));
    }

    public CaptureInput<T> setCaptureVideoSize(int width, int height) {
        return this.setCaptureVideoSize(width + "x" + height);
    }

    public CaptureInput<T> setCaptureVideoSize(String size) {
        return (CaptureInput)this.addArguments("-video_size", size);
    }

    public abstract CaptureInput<T> setCaptureVideoOffset(int var1, int var2);

    public abstract CaptureInput<T> setCaptureCursor(boolean var1);

    public static CaptureInput<?> captureDesktop() {
        CaptureInput result = null;
        if (OS.IS_LINUX) {
            result = LinuxX11Grab.captureDesktop();
        } else if (OS.IS_MAC) {
            result = MacOsAvFoundation.captureDesktop();
        } else if (OS.IS_WINDOWS) {
            result = WindowsGdiGrab.captureDesktop();
        }
        if (result == null) {
            throw new JaffreeException("Could not detect OS");
        }
        return result;
    }

    public static class LinuxX11Grab
    extends CaptureInput<LinuxX11Grab> {
        public LinuxX11Grab(String input) {
            super(input);
        }

        public static LinuxX11Grab captureDesktop() {
            return LinuxX11Grab.captureDisplayAndScreen(0, 0);
        }

        public static LinuxX11Grab captureDisplayAndScreen(int display, int screen) {
            return LinuxX11Grab.captureHostDisplayAndScreen("", display, screen);
        }

        public static LinuxX11Grab captureHostDisplayAndScreen(String host, int display, int screen) {
            return (LinuxX11Grab)new LinuxX11Grab(host + ":" + display + "." + screen).setFormat("x11grab");
        }

        public LinuxX11Grab setCaptureCursor(boolean captureCursor) {
            String argValue = captureCursor ? "1" : "0";
            return (LinuxX11Grab)this.addArguments("-draw_mouse", argValue);
        }

        public LinuxX11Grab setCaptureVideoOffset(int xOffset, int yOffset) {
            return (LinuxX11Grab)((LinuxX11Grab)this.addArguments("-grab_x", String.valueOf(xOffset))).addArguments("-grab_y", String.valueOf(yOffset));
        }
    }

    public static class MacOsAvFoundation
    extends CaptureInput<MacOsAvFoundation> {
        private static final Logger LOGGER = LoggerFactory.getLogger(MacOsAvFoundation.class);

        public MacOsAvFoundation(String input) {
            super(input);
        }

        public static MacOsAvFoundation captureDesktop() {
            return MacOsAvFoundation.captureVideoAndAudio("default", null);
        }

        public static MacOsAvFoundation captureVideoAndAudio(String videoDevice, String audioDevice) {
            String videoDeviceOrNone = videoDevice == null ? "none" : videoDevice;
            String audioDeviceOrNone = audioDevice == null ? "none" : audioDevice;
            return (MacOsAvFoundation)new MacOsAvFoundation(videoDeviceOrNone + ":" + audioDeviceOrNone).setFormat("avfoundation");
        }

        public MacOsAvFoundation setCaptureCursor(boolean captureCursor) {
            String argValue = captureCursor ? "1" : "0";
            return (MacOsAvFoundation)this.addArguments("-capture_cursor", argValue);
        }

        public MacOsAvFoundation setCaptureVideoOffset(int xOffset, int yOffset) {
            LOGGER.warn("Capture offset option is not supported");
            return this;
        }
    }

    public static class WindowsGdiGrab
    extends CaptureInput<WindowsGdiGrab> {
        public WindowsGdiGrab(String input) {
            super(input);
        }

        public static WindowsGdiGrab captureDesktop() {
            return (WindowsGdiGrab)new WindowsGdiGrab("desktop").setFormat("gdigrab");
        }

        public static WindowsGdiGrab captureWindow(String windowTitle) {
            return (WindowsGdiGrab)new WindowsGdiGrab("title=" + windowTitle).setFormat("gdigrab");
        }

        public WindowsGdiGrab setCaptureCursor(boolean captureCursor) {
            String argValue = captureCursor ? "1" : "0";
            return (WindowsGdiGrab)this.addArguments("-draw_mouse", argValue);
        }

        public WindowsGdiGrab setCaptureVideoOffset(int xOffset, int yOffset) {
            return (WindowsGdiGrab)((WindowsGdiGrab)this.addArguments("-offset_x", String.valueOf(xOffset))).addArguments("-offset_y", String.valueOf(yOffset));
        }
    }

    public static class WindowsDirectShow
    extends CaptureInput<WindowsDirectShow> {
        private static final Logger LOGGER = LoggerFactory.getLogger(WindowsDirectShow.class);

        public WindowsDirectShow(String input) {
            super(input);
        }

        public static WindowsDirectShow captureVideo(String videoDevice) {
            return WindowsDirectShow.captureVideoAndAudio(videoDevice, null);
        }

        public static WindowsDirectShow captureAudio(String audioDevice) {
            return WindowsDirectShow.captureVideoAndAudio(null, audioDevice);
        }

        public static WindowsDirectShow captureVideoAndAudio(String videoDevice, String audioDevice) {
            String input = "";
            if (videoDevice != null) {
                input = "video=" + videoDevice;
            }
            if (audioDevice != null) {
                if (!input.isEmpty()) {
                    input = input + ":";
                }
                input = input + "audio=" + audioDevice;
            }
            return (WindowsDirectShow)new WindowsDirectShow(input).setFormat("dshow");
        }

        public WindowsDirectShow setCaptureCursor(boolean captureCursor) {
            LOGGER.warn("Cursor capture option is not supported");
            return this;
        }

        public WindowsDirectShow setCaptureVideoOffset(int xOffset, int yOffset) {
            LOGGER.warn("Capture offset option is not supported");
            return this;
        }
    }
}

