/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;

public class SizeRequirements
implements Serializable {
    public int minimum;
    public int preferred;
    public int maximum;
    public float alignment;

    public SizeRequirements() {
        this.minimum = 0;
        this.preferred = 0;
        this.maximum = 0;
        this.alignment = 0.5f;
    }

    public SizeRequirements(int n, int n2, int n3, float f) {
        this.minimum = n;
        this.preferred = n2;
        this.maximum = n3;
        this.alignment = f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f);
    }

    public String toString() {
        return "[" + this.minimum + "," + this.preferred + "," + this.maximum + "]@" + this.alignment;
    }

    public static SizeRequirements getTiledSizeRequirements(SizeRequirements[] sizeRequirementsArray) {
        SizeRequirements sizeRequirements = new SizeRequirements();
        for (int i = 0; i < sizeRequirementsArray.length; ++i) {
            SizeRequirements sizeRequirements2 = sizeRequirementsArray[i];
            sizeRequirements.minimum = (int)Math.min((long)sizeRequirements.minimum + (long)sizeRequirements2.minimum, Integer.MAX_VALUE);
            sizeRequirements.preferred = (int)Math.min((long)sizeRequirements.preferred + (long)sizeRequirements2.preferred, Integer.MAX_VALUE);
            sizeRequirements.maximum = (int)Math.min((long)sizeRequirements.maximum + (long)sizeRequirements2.maximum, Integer.MAX_VALUE);
        }
        return sizeRequirements;
    }

    public static SizeRequirements getAlignedSizeRequirements(SizeRequirements[] sizeRequirementsArray) {
        int n;
        int n2;
        SizeRequirements sizeRequirements = new SizeRequirements();
        SizeRequirements sizeRequirements2 = new SizeRequirements();
        for (n2 = 0; n2 < sizeRequirementsArray.length; ++n2) {
            SizeRequirements sizeRequirements3 = sizeRequirementsArray[n2];
            n = (int)(sizeRequirements3.alignment * (float)sizeRequirements3.minimum);
            int n3 = sizeRequirements3.minimum - n;
            sizeRequirements.minimum = Math.max(n, sizeRequirements.minimum);
            sizeRequirements2.minimum = Math.max(n3, sizeRequirements2.minimum);
            n = (int)(sizeRequirements3.alignment * (float)sizeRequirements3.preferred);
            n3 = sizeRequirements3.preferred - n;
            sizeRequirements.preferred = Math.max(n, sizeRequirements.preferred);
            sizeRequirements2.preferred = Math.max(n3, sizeRequirements2.preferred);
            n = (int)(sizeRequirements3.alignment * (float)sizeRequirements3.maximum);
            n3 = sizeRequirements3.maximum - n;
            sizeRequirements.maximum = Math.max(n, sizeRequirements.maximum);
            sizeRequirements2.maximum = Math.max(n3, sizeRequirements2.maximum);
        }
        n2 = (int)Math.min((long)sizeRequirements.minimum + (long)sizeRequirements2.minimum, Integer.MAX_VALUE);
        int n4 = (int)Math.min((long)sizeRequirements.preferred + (long)sizeRequirements2.preferred, Integer.MAX_VALUE);
        n = (int)Math.min((long)sizeRequirements.maximum + (long)sizeRequirements2.maximum, Integer.MAX_VALUE);
        float f = 0.0f;
        if (n2 > 0) {
            f = (float)sizeRequirements.minimum / (float)n2;
            f = f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f);
        }
        return new SizeRequirements(n2, n4, n, f);
    }

    public static void calculateTiledPositions(int n, SizeRequirements sizeRequirements, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2) {
        SizeRequirements.calculateTiledPositions(n, sizeRequirements, sizeRequirementsArray, nArray, nArray2, true);
    }

    public static void calculateTiledPositions(int n, SizeRequirements sizeRequirements, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2, boolean bl) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (int i = 0; i < sizeRequirementsArray.length; ++i) {
            l += (long)sizeRequirementsArray[i].minimum;
            l2 += (long)sizeRequirementsArray[i].preferred;
            l3 += (long)sizeRequirementsArray[i].maximum;
        }
        if ((long)n >= l2) {
            SizeRequirements.expandedTile(n, l, l2, l3, sizeRequirementsArray, nArray, nArray2, bl);
        } else {
            SizeRequirements.compressedTile(n, l, l2, l3, sizeRequirementsArray, nArray, nArray2, bl);
        }
    }

    private static void compressedTile(int n, long l, long l2, long l3, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2, boolean bl) {
        float f;
        float f2 = Math.min(l2 - (long)n, l2 - l);
        float f3 = f = l2 - l == 0L ? 0.0f : f2 / (float)(l2 - l);
        if (bl) {
            int n2 = 0;
            for (int i = 0; i < nArray2.length; ++i) {
                nArray[i] = n2;
                SizeRequirements sizeRequirements = sizeRequirementsArray[i];
                float f4 = f * (float)(sizeRequirements.preferred - sizeRequirements.minimum);
                nArray2[i] = (int)((float)sizeRequirements.preferred - f4);
                n2 = (int)Math.min((long)n2 + (long)nArray2[i], Integer.MAX_VALUE);
            }
        } else {
            int n3 = n;
            for (int i = 0; i < nArray2.length; ++i) {
                SizeRequirements sizeRequirements = sizeRequirementsArray[i];
                float f5 = f * (float)(sizeRequirements.preferred - sizeRequirements.minimum);
                nArray2[i] = (int)((float)sizeRequirements.preferred - f5);
                nArray[i] = n3 - nArray2[i];
                n3 = (int)Math.max((long)n3 - (long)nArray2[i], 0L);
            }
        }
    }

    private static void expandedTile(int n, long l, long l2, long l3, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2, boolean bl) {
        float f;
        float f2 = Math.min((long)n - l2, l3 - l2);
        float f3 = f = l3 - l2 == 0L ? 0.0f : f2 / (float)(l3 - l2);
        if (bl) {
            int n2 = 0;
            for (int i = 0; i < nArray2.length; ++i) {
                nArray[i] = n2;
                SizeRequirements sizeRequirements = sizeRequirementsArray[i];
                int n3 = (int)(f * (float)(sizeRequirements.maximum - sizeRequirements.preferred));
                nArray2[i] = (int)Math.min((long)sizeRequirements.preferred + (long)n3, Integer.MAX_VALUE);
                n2 = (int)Math.min((long)n2 + (long)nArray2[i], Integer.MAX_VALUE);
            }
        } else {
            int n4 = n;
            for (int i = 0; i < nArray2.length; ++i) {
                SizeRequirements sizeRequirements = sizeRequirementsArray[i];
                int n5 = (int)(f * (float)(sizeRequirements.maximum - sizeRequirements.preferred));
                nArray2[i] = (int)Math.min((long)sizeRequirements.preferred + (long)n5, Integer.MAX_VALUE);
                nArray[i] = n4 - nArray2[i];
                n4 = (int)Math.max((long)n4 - (long)nArray2[i], 0L);
            }
        }
    }

    public static void calculateAlignedPositions(int n, SizeRequirements sizeRequirements, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2) {
        SizeRequirements.calculateAlignedPositions(n, sizeRequirements, sizeRequirementsArray, nArray, nArray2, true);
    }

    public static void calculateAlignedPositions(int n, SizeRequirements sizeRequirements, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2, boolean bl) {
        float f = bl ? sizeRequirements.alignment : 1.0f - sizeRequirements.alignment;
        int n2 = (int)((float)n * f);
        int n3 = n - n2;
        for (int i = 0; i < sizeRequirementsArray.length; ++i) {
            SizeRequirements sizeRequirements2 = sizeRequirementsArray[i];
            float f2 = bl ? sizeRequirements2.alignment : 1.0f - sizeRequirements2.alignment;
            int n4 = (int)((float)sizeRequirements2.maximum * f2);
            int n5 = sizeRequirements2.maximum - n4;
            int n6 = Math.min(n2, n4);
            int n7 = Math.min(n3, n5);
            nArray[i] = n2 - n6;
            nArray2[i] = (int)Math.min((long)n6 + (long)n7, Integer.MAX_VALUE);
        }
    }

    public static int[] adjustSizes(int n, SizeRequirements[] sizeRequirementsArray) {
        return new int[0];
    }
}

