/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoImpl;
import org.osgi.service.condpermadmin.Condition;

public class ConditionalPermission {
    private final ConditionalPermissionInfoImpl parent;
    private Condition[] conditions;
    private final PermissionCollection permissions;
    private List<Condition> postponed = null;
    final String access;

    ConditionalPermission(Condition[] conds, PermissionCollection perms, String access, ConditionalPermissionInfoImpl cpi) {
        this.conditions = conds;
        this.permissions = perms;
        this.access = access;
        this.parent = cpi;
    }

    boolean checkImmediateOk(Permission perm, boolean checkPostponed) {
        if (this.conditions == null) {
            return false;
        }
        this.postponed = new ArrayList<Condition>(1);
        for (int i = 0; i < this.conditions.length; ++i) {
            Condition c = this.conditions[i];
            if (c == null) continue;
            if (checkPostponed || !c.isPostponed()) {
                boolean mutable = c.isMutable();
                if (c.isSatisfied()) {
                    if (mutable) continue;
                    this.conditions[i] = null;
                    continue;
                }
                if (!mutable) {
                    this.conditions = null;
                }
                this.postponed = null;
                return false;
            }
            this.postponed.add(c);
        }
        return this.permissions.implies(perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkPostponedOk(Map<Class<? extends Condition>, Dictionary<Object, Object>> condDict, List<Class<? extends Condition>> checkedClasses) {
        if (this.conditions == null) {
            return false;
        }
        block5: for (Condition c : this.postponed) {
            boolean bl;
            Class<?> cc = c.getClass();
            if (checkedClasses.contains(cc)) {
                throw new SecurityException("Postponement condition check recursive for class: " + cc);
            }
            Dictionary<Object, Object> d = condDict.get(cc);
            if (d == null) {
                d = new Hashtable<Object, Object>();
                condDict.put(cc, d);
            }
            checkedClasses.add(cc);
            try {
                boolean m = c.isMutable();
                if (c.isSatisfied(new Condition[]{c}, d)) {
                    if (m) continue;
                    for (int i = 0; i < this.conditions.length; ++i) {
                        if (this.conditions[i] != c) continue;
                        this.conditions[i] = null;
                        continue block5;
                    }
                    continue;
                }
                if (!m) {
                    this.conditions = null;
                }
                bl = false;
                return bl;
            }
            catch (Throwable ignore) {
                bl = false;
                return bl;
            }
            finally {
                checkedClasses.remove(checkedClasses.size() - 1);
            }
        }
        return true;
    }

    boolean hasPostponed() {
        return !this.postponed.isEmpty();
    }

    boolean isParent(ConditionalPermissionInfoImpl cpi) {
        return cpi == this.parent;
    }

    public String toString() {
        return "HASH: " + this.hashCode() + " INFO: " + this.parent.toString();
    }
}

