/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.io.xml;

import java.io.IOException;
import java.util.Properties;
import org.freeplane.core.io.xml.LocalEntityResolver;
import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.IXMLReader;
import org.freeplane.n3.nanoxml.StdXMLParser;
import org.freeplane.n3.nanoxml.XMLParseException;

class XMLParser
extends StdXMLParser
implements IXMLParser {
    ContentCollect contentCollect = ContentCollect.NONE;

    public XMLParser() {
        this.setResolver(new LocalEntityResolver());
    }

    void collectContentUntilMatchingTag(boolean findsClosingTagByName) {
        this.contentCollect = findsClosingTagByName ? ContentCollect.BY_CLOSING_TAG_NAME : ContentCollect.BY_CLOSING_TAG_LEVEL;
    }

    @Override
    protected void processElement(String defaultNamespace, Properties namespaces) throws Exception {
        try {
            super.processElement(defaultNamespace, namespaces);
        }
        finally {
            this.contentCollect = ContentCollect.NONE;
        }
    }

    @Override
    protected void processElementContent(String defaultNamespace, Properties namespaces, String fullName, String name, String prefix) throws IOException, XMLParseException, Exception {
        if (this.contentCollect != ContentCollect.NONE) {
            boolean inComment = false;
            TreeXmlReader builder = (TreeXmlReader)this.getBuilder();
            StringBuilder contentBuffer = new StringBuilder();
            int level = 1;
            int confirmedContentBufferLength = 0;
            int closingTagMatchingCharacters = -2;
            while (true) {
                IXMLReader reader = this.getReader();
                char ch = reader.read();
                if (inComment) {
                    contentBuffer.append(ch);
                    if (ch != '-') continue;
                    ch = reader.read();
                    contentBuffer.append(ch);
                    if (ch != '-') continue;
                    ch = reader.read();
                    contentBuffer.append(ch);
                    if (ch != '>') continue;
                    inComment = false;
                    continue;
                }
                if (ch == '<') {
                    ch = reader.read();
                    if (ch == '/') {
                        if (this.contentCollect == ContentCollect.BY_CLOSING_TAG_LEVEL) {
                            if (--level == 0) {
                                break;
                            }
                        } else {
                            confirmedContentBufferLength = contentBuffer.length();
                            closingTagMatchingCharacters = -1;
                        }
                    } else if (this.contentCollect == ContentCollect.BY_CLOSING_TAG_LEVEL) {
                        if (ch == '!') {
                            char read1 = reader.read();
                            char read2 = reader.read();
                            if (read1 != '-' || read2 != '-') {
                                throw new XMLParseException(reader.getSystemID(), reader.getLineNr(), "Invalid input: <!" + read1 + read2);
                            }
                            inComment = true;
                            contentBuffer.append("<!--");
                            continue;
                        }
                        ++level;
                    }
                    contentBuffer.append('<');
                } else if (this.contentCollect == ContentCollect.BY_CLOSING_TAG_LEVEL && ch == '/') {
                    ch = reader.read();
                    if (ch == '>') {
                        if (--level == 0) {
                            throw new XMLParseException(reader.getSystemID(), reader.getLineNr(), "Invalid input: />");
                        }
                    } else if (ch == '<') {
                        contentBuffer.append('/');
                        reader.unread(ch);
                        continue;
                    }
                    contentBuffer.append('/');
                }
                if (this.contentCollect == ContentCollect.BY_CLOSING_TAG_NAME) {
                    if (closingTagMatchingCharacters == -1 || closingTagMatchingCharacters >= 0 && closingTagMatchingCharacters < fullName.length() && fullName.charAt(closingTagMatchingCharacters) == ch) {
                        if (closingTagMatchingCharacters >= 0 && closingTagMatchingCharacters < fullName.length() || ch != ' ' && ch != '\t' && ch != '\n') {
                            ++closingTagMatchingCharacters;
                        }
                    } else {
                        if (ch == '>' && closingTagMatchingCharacters == fullName.length()) {
                            contentBuffer.setLength(confirmedContentBufferLength);
                            this.closingTagIsReadAndVerified = true;
                            break;
                        }
                        closingTagMatchingCharacters = -2;
                    }
                }
                contentBuffer.append(ch);
            }
            builder.setElementContent(contentBuffer.toString());
            return;
        }
        super.processElementContent(defaultNamespace, namespaces, fullName, name, prefix);
    }

    static enum ContentCollect {
        NONE,
        BY_CLOSING_TAG_LEVEL,
        BY_CLOSING_TAG_NAME;

    }
}

