/*
 * Decompiled with CFR 0.152.
 */
package io.github.gitbucket.markedj;

import io.github.gitbucket.markedj.Options;
import io.github.gitbucket.markedj.Utils;

public class Renderer {
    protected Options options;

    public Renderer(Options options) {
        this.options = options;
    }

    public String code(String code, String lang, boolean escaped) {
        if (!Utils.isEmpty(lang)) {
            StringBuilder sb = new StringBuilder();
            sb.append("<pre><code class=\"" + this.options.getLangPrefix() + Utils.escape(lang, true) + "\">");
            if (escaped) {
                sb.append(code);
            } else {
                sb.append(Utils.escape(code, true));
            }
            sb.append("\n</code></pre>\n");
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<pre><code>");
        if (escaped) {
            sb.append(code);
        } else {
            sb.append(Utils.escape(code, true));
        }
        sb.append("\n</code></pre>\n");
        return sb.toString();
    }

    public String blockquote(String quote) {
        return "<blockquote>\n" + quote + "</blockquote>\n";
    }

    public String html(String html) {
        return html;
    }

    public String heading(String text, int level, String raw) {
        return "<h" + level + " id=\"" + this.options.getHeaderPrefix() + raw.toLowerCase().replaceAll("[^\\w]+", "-") + "\">" + text + "</h" + level + ">\n";
    }

    public String hr() {
        return "<hr>\n";
    }

    public String list(String body, boolean ordered) {
        String listType = ordered ? "ol" : "ul";
        return "<" + listType + ">\n" + body + "</" + listType + ">\n";
    }

    public String listitem(String text) {
        return "<li>" + text + "</li>\n";
    }

    public String paragraph(String text) {
        return "<p>" + text + "</p>\n";
    }

    public String table(String header, String body) {
        return "<table>\n<thead>\n" + header + "</thead>\n<tbody>\n" + body + "</tbody>\n</table>\n";
    }

    public String tablerow(String content) {
        return "<tr>\n" + content + "</tr>\n";
    }

    public String tablecell(String content, TableCellFlags flags) {
        String cellType = flags.isHeader() ? "th" : "td";
        String align = flags.getAlign();
        if (align != null) {
            return "<" + cellType + " style=\"text-align: " + align + "\">" + content + "</" + cellType + ">\n";
        }
        return "<" + cellType + ">" + content + "</" + cellType + ">\n";
    }

    public String strong(String text) {
        return "<strong>" + text + "</strong>";
    }

    public String em(String text) {
        return "<em>" + text + "</em>";
    }

    public String codespan(String text) {
        return "<code>" + text + "</code>";
    }

    public String br() {
        return "<br>";
    }

    public String del(String text) {
        return "<del>" + text + "</del>";
    }

    public String link(String href, String title, String text) {
        String titleAttr = "";
        if (title != null) {
            titleAttr = " title=\"" + title + "\"";
        }
        return "<a href=\"" + href + "\"" + titleAttr + ">" + text + "</a>";
    }

    public String image(String href, String title, String text) {
        String titleAttr = "";
        if (title != null) {
            titleAttr = " title=\"" + title + "\"";
        }
        return "<img src=\"" + href + "\" alt=\"" + text + "\"" + titleAttr + ">";
    }

    public String nolink(String text) {
        return Utils.escape(text);
    }

    public String text(String text) {
        return text;
    }

    public static class TableCellFlags {
        private boolean header;
        private String align;

        public TableCellFlags(boolean header, String align) {
            this.header = header;
            this.align = align;
        }

        public boolean isHeader() {
            return this.header;
        }

        public String getAlign() {
            return this.align;
        }
    }
}

