/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.SpanQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanQueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SpanOrQuery
extends QueryBase
implements QueryVariant,
SpanQueryVariant,
ToCopyableBuilder<Builder, SpanOrQuery> {
    @Nonnull
    private final List<SpanQuery> clauses;
    public static final JsonpDeserializer<SpanOrQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanOrQuery::setupSpanOrQueryDeserializer);

    private SpanOrQuery(Builder builder) {
        super(builder);
        this.clauses = ApiTypeHelper.unmodifiableRequired(builder.clauses, (Object)this, "clauses");
    }

    public static SpanOrQuery of(Function<Builder, ObjectBuilder<SpanOrQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.SpanOr;
    }

    @Override
    public SpanQuery.Kind _spanQueryKind() {
        return SpanQuery.Kind.SpanOr;
    }

    @Nonnull
    public final List<SpanQuery> clauses() {
        return this.clauses;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("clauses");
        generator.writeStartArray();
        for (SpanQuery item0 : this.clauses) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSpanOrQueryDeserializer(ObjectDeserializer<Builder> op) {
        SpanOrQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::clauses, JsonpDeserializer.arrayDeserializer(SpanQuery._DESERIALIZER), "clauses");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.clauses.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanOrQuery other = (SpanOrQuery)o;
        return this.clauses.equals(other.clauses);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SpanOrQuery> {
        private List<SpanQuery> clauses;

        public Builder() {
        }

        private Builder(SpanOrQuery o) {
            super(o);
            this.clauses = Builder._listCopy(o.clauses);
        }

        private Builder(Builder o) {
            super(o);
            this.clauses = Builder._listCopy(o.clauses);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clauses(List<SpanQuery> list) {
            this.clauses = Builder._listAddAll(this.clauses, list);
            return this;
        }

        @Nonnull
        public final Builder clauses(SpanQuery value, SpanQuery ... values) {
            this.clauses = Builder._listAdd(this.clauses, value, values);
            return this;
        }

        @Nonnull
        public final Builder clauses(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.clauses(fn.apply(new SpanQuery.Builder()).build(), new SpanQuery[0]);
        }

        @Override
        @Nonnull
        public SpanOrQuery build() {
            this._checkSingleUse();
            return new SpanOrQuery(this);
        }
    }
}

