/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ism;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ism.ExplainPolicyResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class ExplainPolicyRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ExplainPolicyRequest> {
    @Nonnull
    private final JsonData body;
    @Nullable
    private final String index;
    public static final JsonpDeserializer<ExplainPolicyRequest> _DESERIALIZER = ExplainPolicyRequest.createExplainPolicyRequestDeserializer();
    public static final Endpoint<ExplainPolicyRequest, ExplainPolicyResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ExplainPolicyRequest, ExplainPolicyResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_plugins/_ism/explain";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_plugins/_ism/explain/");
            SimpleEndpoint.pathEncode(request.index, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, ExplainPolicyResponse._DESERIALIZER);

    private ExplainPolicyRequest(Builder builder) {
        super(builder);
        this.body = ApiTypeHelper.requireNonNull(builder.body, this, "body");
        this.index = builder.index;
    }

    public static ExplainPolicyRequest of(Function<Builder, ObjectBuilder<ExplainPolicyRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final JsonData body() {
        return this.body;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.body.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static JsonpDeserializer<ExplainPolicyRequest> createExplainPolicyRequestDeserializer() {
        JsonpDeserializer<JsonData> valueDeserializer = JsonData._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper) -> new Builder().body((JsonData)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper)).build());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.body.hashCode();
        result = 31 * result + Objects.hashCode(this.index);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExplainPolicyRequest other = (ExplainPolicyRequest)o;
        return this.body.equals(other.body) && Objects.equals(this.index, other.index);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ExplainPolicyRequest> {
        private JsonData body;
        @Nullable
        private String index;

        public Builder() {
        }

        private Builder(ExplainPolicyRequest o) {
            super(o);
            this.body = o.body;
            this.index = o.index;
        }

        private Builder(Builder o) {
            super(o);
            this.body = o.body;
            this.index = o.index;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder body(JsonData value) {
            this.body = value;
            return this;
        }

        @Nonnull
        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        @Override
        @Nonnull
        public ExplainPolicyRequest build() {
            this._checkSingleUse();
            return new ExplainPolicyRequest(this);
        }
    }
}

