/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.rank_eval.RankEvalMetricDetail;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RankEvalResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RankEvalResponse> {
    @Nonnull
    private final Map<String, RankEvalMetricDetail> details;
    @Nonnull
    private final Map<String, JsonData> failures;
    private final double metricScore;
    public static final JsonpDeserializer<RankEvalResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankEvalResponse::setupRankEvalResponseDeserializer);

    private RankEvalResponse(Builder builder) {
        this.details = ApiTypeHelper.unmodifiableRequired(builder.details, (Object)this, "details");
        this.failures = ApiTypeHelper.unmodifiableRequired(builder.failures, (Object)this, "failures");
        this.metricScore = ApiTypeHelper.requireNonNull(builder.metricScore, this, "metricScore");
    }

    public static RankEvalResponse of(Function<Builder, ObjectBuilder<RankEvalResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, RankEvalMetricDetail> details() {
        return this.details;
    }

    @Nonnull
    public final Map<String, JsonData> failures() {
        return this.failures;
    }

    public final double metricScore() {
        return this.metricScore;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("details");
        generator.writeStartObject();
        for (Map.Entry<String, RankEvalMetricDetail> entry : this.details.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("failures");
        generator.writeStartObject();
        for (Map.Entry<String, JsonpSerializable> entry : this.failures.entrySet()) {
            generator.writeKey(entry.getKey());
            ((JsonData)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("metric_score");
        generator.write(this.metricScore);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRankEvalResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::details, JsonpDeserializer.stringMapDeserializer(RankEvalMetricDetail._DESERIALIZER), "details");
        op.add(Builder::failures, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "failures");
        op.add(Builder::metricScore, JsonpDeserializer.doubleDeserializer(), "metric_score");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.details.hashCode();
        result = 31 * result + this.failures.hashCode();
        result = 31 * result + Double.hashCode(this.metricScore);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RankEvalResponse other = (RankEvalResponse)o;
        return this.details.equals(other.details) && this.failures.equals(other.failures) && this.metricScore == other.metricScore;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RankEvalResponse> {
        private Map<String, RankEvalMetricDetail> details;
        private Map<String, JsonData> failures;
        private Double metricScore;

        public Builder() {
        }

        private Builder(RankEvalResponse o) {
            this.details = Builder._mapCopy(o.details);
            this.failures = Builder._mapCopy(o.failures);
            this.metricScore = o.metricScore;
        }

        private Builder(Builder o) {
            this.details = Builder._mapCopy(o.details);
            this.failures = Builder._mapCopy(o.failures);
            this.metricScore = o.metricScore;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder details(Map<String, RankEvalMetricDetail> map) {
            this.details = Builder._mapPutAll(this.details, map);
            return this;
        }

        @Nonnull
        public final Builder details(String key, RankEvalMetricDetail value) {
            this.details = Builder._mapPut(this.details, key, value);
            return this;
        }

        @Nonnull
        public final Builder details(String key, Function<RankEvalMetricDetail.Builder, ObjectBuilder<RankEvalMetricDetail>> fn) {
            return this.details(key, fn.apply(new RankEvalMetricDetail.Builder()).build());
        }

        @Nonnull
        public final Builder failures(Map<String, JsonData> map) {
            this.failures = Builder._mapPutAll(this.failures, map);
            return this;
        }

        @Nonnull
        public final Builder failures(String key, JsonData value) {
            this.failures = Builder._mapPut(this.failures, key, value);
            return this;
        }

        @Nonnull
        public final Builder metricScore(double value) {
            this.metricScore = value;
            return this;
        }

        @Override
        @Nonnull
        public RankEvalResponse build() {
            this._checkSingleUse();
            return new RankEvalResponse(this);
        }
    }
}

