/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.recovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.cluster.remotestore.restore.RestoreRemoteStoreRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.block.ClusterBlocks;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.metadata.MetadataIndexUpgradeService;
import org.opensearch.cluster.metadata.RepositoriesMetadata;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.Priority;
import org.opensearch.common.UUIDs;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.IndexUtils;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.gateway.remote.RemoteClusterStateService;
import org.opensearch.indices.ShardLimitValidator;
import org.opensearch.repositories.IndexId;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.snapshots.RestoreInfo;
import org.opensearch.snapshots.RestoreService;

public class RemoteStoreRestoreService {
    private static final Logger logger = LogManager.getLogger(RemoteStoreRestoreService.class);
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final MetadataCreateIndexService createIndexService;
    private final MetadataIndexUpgradeService metadataIndexUpgradeService;
    private final ShardLimitValidator shardLimitValidator;
    private final RemoteClusterStateService remoteClusterStateService;

    public RemoteStoreRestoreService(ClusterService clusterService, AllocationService allocationService, MetadataCreateIndexService createIndexService, MetadataIndexUpgradeService metadataIndexUpgradeService, ShardLimitValidator shardLimitValidator, RemoteClusterStateService remoteClusterStateService) {
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.createIndexService = createIndexService;
        this.metadataIndexUpgradeService = metadataIndexUpgradeService;
        this.shardLimitValidator = shardLimitValidator;
        this.remoteClusterStateService = remoteClusterStateService;
    }

    public void restore(final RestoreRemoteStoreRequest request, final ActionListener<RestoreService.RestoreCompletionResponse> listener) {
        this.clusterService.submitStateUpdateTask("restore[remote_store]", new ClusterStateUpdateTask(Priority.URGENT){
            String restoreUUID;
            RestoreInfo restoreInfo;
            {
                super(priority);
                this.restoreInfo = null;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                RemoteRestoreResult remoteRestoreResult = RemoteStoreRestoreService.this.restore(currentState, null, request.restoreAllShards(), request.indices());
                this.restoreUUID = remoteRestoreResult.getRestoreUUID();
                this.restoreInfo = remoteRestoreResult.getRestoreInfo();
                return remoteRestoreResult.getClusterState();
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn("failed to restore from remote store", (Throwable)e);
                listener.onFailure(e);
            }

            @Override
            public TimeValue timeout() {
                return request.clusterManagerNodeTimeout();
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)new RestoreService.RestoreCompletionResponse(this.restoreUUID, null, this.restoreInfo));
            }
        });
    }

    public RemoteRestoreResult restore(ClusterState currentState, @Nullable String restoreClusterUUID, boolean restoreAllShards, String[] indexNames) {
        boolean metadataFromRemoteStore;
        HashMap<String, Tuple<Boolean, IndexMetadata>> indexMetadataMap = new HashMap<String, Tuple<Boolean, IndexMetadata>>();
        ClusterState remoteState = null;
        boolean bl = metadataFromRemoteStore = !(restoreClusterUUID == null || restoreClusterUUID.isEmpty() || restoreClusterUUID.isBlank());
        if (metadataFromRemoteStore) {
            try {
                if (currentState.metadata().clusterUUID().equals(restoreClusterUUID)) {
                    throw new IllegalArgumentException("Cluster UUID for restore must be different from the current cluster UUID.");
                }
                logger.info("Restoring cluster state from remote store for cluster UUID: [{}]", (Object)restoreClusterUUID);
                remoteState = this.remoteClusterStateService.getLatestClusterState(currentState.getClusterName().value(), restoreClusterUUID, false);
                remoteState.getMetadata().getIndices().values().forEach(indexMetadata -> indexMetadataMap.put(indexMetadata.getIndex().getName(), new Tuple((Object)true, indexMetadata)));
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to restore remote index metadata", e);
            }
        } else {
            List<String> filteredIndices = IndexUtils.filterIndices(List.of(currentState.metadata().getConcreteAllIndices()), indexNames, IndicesOptions.fromOptions(true, true, true, true));
            for (String indexName : filteredIndices) {
                IndexMetadata indexMetadata2 = currentState.metadata().index(indexName);
                if (indexMetadata2 == null) {
                    logger.warn("Index restore is not supported for non-existent index. Skipping: {}", (Object)indexName);
                    continue;
                }
                boolean isSearchOnlyClusterBlockEnabled = indexMetadata2.getSettings().getAsBoolean(IndexMetadata.INDEX_BLOCKS_SEARCH_ONLY_SETTING.getKey(), false);
                if (isSearchOnlyClusterBlockEnabled) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Cannot use _remotestore/_restore on search_only mode enabled index [%s].", indexName));
                }
                if (restoreAllShards && !IndexMetadata.State.CLOSE.equals((Object)indexMetadata2.getState())) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "cannot restore index [%s] because an open index with same name/uuid already exists in the cluster.", indexName) + " Close the existing index.");
                }
                indexMetadataMap.put(indexName, (Tuple<Boolean, IndexMetadata>)new Tuple((Object)false, (Object)indexMetadata2));
            }
        }
        return this.executeRestore(currentState, indexMetadataMap, restoreAllShards, remoteState);
    }

    private RemoteRestoreResult executeRestore(ClusterState currentState, Map<String, Tuple<Boolean, IndexMetadata>> indexMetadataMap, boolean restoreAllShards, ClusterState remoteState) {
        String restoreUUID = UUIDs.randomBase64UUID();
        ArrayList<String> indicesToBeRestored = new ArrayList<String>();
        int totalShards = 0;
        boolean metadataFromRemoteStore = false;
        ClusterState.Builder builder = ClusterState.builder(currentState);
        Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        RoutingTable.Builder rtBuilder = RoutingTable.builder(currentState.routingTable());
        for (Map.Entry<String, Tuple<Boolean, IndexMetadata>> indexMetadataEntry : indexMetadataMap.entrySet()) {
            String indexName = indexMetadataEntry.getKey();
            IndexMetadata indexMetadata = (IndexMetadata)indexMetadataEntry.getValue().v2();
            metadataFromRemoteStore = (Boolean)indexMetadataEntry.getValue().v1();
            IndexMetadata updatedIndexMetadata = indexMetadata;
            if (!metadataFromRemoteStore && restoreAllShards) {
                updatedIndexMetadata = IndexMetadata.builder(indexMetadata).state(IndexMetadata.State.OPEN).version(1L + indexMetadata.getVersion()).mappingVersion(1L + indexMetadata.getMappingVersion()).settingsVersion(1L + indexMetadata.getSettingsVersion()).aliasesVersion(1L + indexMetadata.getAliasesVersion()).build();
            }
            IndexId indexId = new IndexId(indexName, updatedIndexMetadata.getIndexUUID(), IndexId.DEFAULT_SHARD_PATH_TYPE);
            if (!metadataFromRemoteStore) {
                Map<ShardId, IndexShardRoutingTable> indexShardRoutingTableMap = currentState.routingTable().index(indexName).shards().values().stream().collect(Collectors.toMap(IndexShardRoutingTable::shardId, Function.identity()));
                RecoverySource.RemoteStoreRecoverySource recoverySource = new RecoverySource.RemoteStoreRecoverySource(restoreUUID, updatedIndexMetadata.getCreationVersion(), indexId);
                rtBuilder.addAsRemoteStoreRestore(updatedIndexMetadata, recoverySource, indexShardRoutingTableMap, restoreAllShards);
            }
            blocks.updateBlocks(updatedIndexMetadata);
            mdBuilder.put(updatedIndexMetadata, true);
            indicesToBeRestored.add(indexName);
            totalShards += updatedIndexMetadata.getNumberOfShards();
        }
        if (remoteState != null) {
            this.restoreGlobalMetadata(mdBuilder, remoteState.getMetadata());
            logger.info("Restoring ClusterState with Remote State version [{}]", (Object)remoteState.version());
            builder.version(remoteState.version());
        }
        RestoreInfo restoreInfo = new RestoreInfo("remote_store", indicesToBeRestored, totalShards, totalShards);
        RoutingTable rt = rtBuilder.build();
        ClusterState updatedState = builder.metadata(mdBuilder).blocks(blocks).routingTable(rt).build();
        if (!metadataFromRemoteStore) {
            updatedState = this.allocationService.reroute(updatedState, "restored from remote store");
        }
        return RemoteRestoreResult.build(restoreUUID, restoreInfo, updatedState);
    }

    private void restoreGlobalMetadata(Metadata.Builder mdBuilder, Metadata remoteMetadata) {
        if (remoteMetadata.persistentSettings() != null) {
            Iterator<Map.Entry<String, Metadata.Custom>> settings = remoteMetadata.persistentSettings();
            this.clusterService.getClusterSettings().validateUpdate((Settings)((Object)settings));
            mdBuilder.persistentSettings((Settings)((Object)settings));
        }
        if (remoteMetadata.templates() != null) {
            for (IndexTemplateMetadata indexTemplateMetadata : remoteMetadata.templates().values()) {
                mdBuilder.put(indexTemplateMetadata);
            }
        }
        if (remoteMetadata.customs() != null) {
            for (Map.Entry<String, Metadata.Custom> entry : remoteMetadata.customs().entrySet()) {
                if ("repositories".equals(entry.getKey())) continue;
                mdBuilder.putCustom(entry.getKey(), entry.getValue());
            }
        }
        Optional<RepositoriesMetadata> repositoriesMetadata = Optional.ofNullable((RepositoriesMetadata)remoteMetadata.custom("repositories"));
        repositoriesMetadata = repositoriesMetadata.map(repositoriesMetadata1 -> new RepositoriesMetadata(repositoriesMetadata1.repositories().stream().filter(repository -> BlobStoreRepository.SYSTEM_REPOSITORY_SETTING.get(repository.settings()) == false).collect(Collectors.toList())));
        repositoriesMetadata.ifPresent(metadata -> mdBuilder.putCustom("repositories", (Metadata.Custom)metadata));
    }

    public static class RemoteRestoreResult {
        private final ClusterState clusterState;
        private final RestoreInfo restoreInfo;
        private final String restoreUUID;

        private RemoteRestoreResult(String restoreUUID, RestoreInfo restoreInfo, ClusterState clusterState) {
            this.clusterState = clusterState;
            this.restoreInfo = restoreInfo;
            this.restoreUUID = restoreUUID;
        }

        public static RemoteRestoreResult build(String restoreUUID, RestoreInfo restoreInfo, ClusterState clusterState) {
            return new RemoteRestoreResult(restoreUUID, restoreInfo, clusterState);
        }

        public ClusterState getClusterState() {
            return this.clusterState;
        }

        public RestoreInfo getRestoreInfo() {
            return this.restoreInfo;
        }

        public String getRestoreUUID() {
            return this.restoreUUID;
        }
    }
}

