/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import java.util.Map;
import java.util.stream.Stream;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.WeightedRoutingMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.WeightedRouting;

public class WeightedRoutingUtils {
    public static boolean isWeighedAway(String nodeId, ClusterState clusterState) {
        WeightedRouting weightedRouting;
        DiscoveryNode node = clusterState.nodes().get(nodeId);
        if (node == null) {
            return false;
        }
        WeightedRoutingMetadata weightedRoutingMetadata = clusterState.metadata().weightedRoutingMetadata();
        if (weightedRoutingMetadata != null && (weightedRouting = weightedRoutingMetadata.getWeightedRouting()) != null && weightedRouting.isSet()) {
            Stream<String> keys = weightedRouting.weights().entrySet().stream().filter(entry -> ((Double)entry.getValue()).intValue() == 0).map(Map.Entry::getKey);
            for (Object key : keys.toArray()) {
                if (!node.getAttributes().get(weightedRouting.attributeName()).equals(key.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean shouldPerformWeightedRouting(boolean ignoreWeightedRouting, WeightedRoutingMetadata weightedRoutingMetadata) {
        return !ignoreWeightedRouting && weightedRoutingMetadata != null && weightedRoutingMetadata.getWeightedRouting().isSet();
    }

    public static boolean shouldPerformStrictWeightedRouting(boolean isStrictWeightedShardRouting, boolean ignoreWeightedRouting, WeightedRoutingMetadata weightedRoutingMetadata) {
        return isStrictWeightedShardRouting && WeightedRoutingUtils.shouldPerformWeightedRouting(ignoreWeightedRouting, weightedRoutingMetadata);
    }
}

