/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.replay.OracleDataSource;
import oracle.jdbc.replay.internal.ReplayableConnection;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.ConnectionInitializationCallback;
import oracle.ucp.jdbc.ConnectionLabelingCallback;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.Poolable;
import oracle.ucp.jdbc.oracle.ReplayDataSourceConnectionFactoryAdapter;
import oracle.ucp.util.UCPErrorHandler;

public class OracleReplayableConnectionConnectionPool
extends OracleConnectionConnectionPool
implements oracle.jdbc.replay.internal.ConnectionInitializationCallback {
    static final String CLASS_NAME = OracleReplayableConnectionConnectionPool.class.getName();
    static final String ORDS_REST_LABEL = "oracle.dbtools.jdbc.label.schema";

    public OracleReplayableConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter, diagnosticsCollector);
        this.core.connectionSource().setReplayable(true);
    }

    public OracleReplayableConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        this(connectionFactoryAdapter, (Diagnosable)DiagnosticsCollectorImpl.getCommon());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.INFO)
    public void start(ConnectionRetrievalInfo connectionRetrievalInfo, boolean bl) throws UniversalConnectionPoolException {
        try {
            void keepMetadataConn;
            void cri;
            this.debug(Level.INFO, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleReplayableConnectionConnectionPool", "start", "entering args ({0}, {1})", null, null, connectionRetrievalInfo, bl);
            if (!this.useVanillaObjects) {
                ReplayDataSourceConnectionFactoryAdapter rcfa = (ReplayDataSourceConnectionFactoryAdapter)this.getConnectionFactoryAdapter();
                OracleDataSource rds = (OracleDataSource)rcfa.getDataSource();
                try {
                    rds.registerConnectionInitializationCallback((oracle.jdbc.replay.internal.ConnectionInitializationCallback)this);
                }
                catch (SQLException sqlexc) {
                    this.trace(Level.WARNING, CLASS_NAME, "start", "", null, sqlexc, new Object[0]);
                }
            }
            super.start((ConnectionRetrievalInfo)cri, (boolean)keepMetadataConn);
            this.debug(Level.INFO, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleReplayableConnectionConnectionPool", "start", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.INFO, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleReplayableConnectionConnectionPool", "start", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.INFO)
    public void initialize(Connection connection) throws SQLException {
        try {
            this.debug(Level.INFO, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleReplayableConnectionConnectionPool", "initialize", "entering args ({0})", null, null, connection);
            try {
                void connection2;
                if (connection2 == null) {
                    throw UCPErrorHandler.newSQLException(65);
                }
                Object ucpConnProxy = ((ReplayableConnection)connection2).getProxyObject();
                if (ucpConnProxy == null || !(ucpConnProxy instanceof Poolable)) {
                    throw UCPErrorHandler.newSQLException(66);
                }
                OracleUniversalPooledConnection oupc = (OracleUniversalPooledConnection)((Poolable)ucpConnProxy).getPooledObject();
                oupc.setStatus(UniversalPooledConnectionStatus.STATUS_RECONNECTING);
                this.trace(Level.FINEST, CLASS_NAME, "initialize", "AC initialize(): found UPC for {0}, status: RECONNECTING", null, null, connection2);
                if (this.isFailoverEnabled()) {
                    CoreConnection coreConn = oupc.getDelegator();
                    coreConn.reinitialize();
                    if (this.m_racManager != null) {
                        this.m_racManager.connectionClosed(oupc);
                    }
                    oupc.initFailoverParameters();
                    oupc.updateInstanceNumber();
                    if (this.m_racManager != null) {
                        this.m_racManager.connectionOpened(oupc);
                    }
                }
                oupc.setStatus(UniversalPooledConnectionStatus.STATUS_NORMAL);
                this.trace(Level.FINEST, CLASS_NAME, "initialize", "AC initialize(): metadata update done for {0}, status: NORMAL", null, null, connection2);
                oracle.ucp.ConnectionLabelingCallback labelingCbk = this.getConnectionLabelingCallback();
                if (labelingCbk != null) {
                    boolean successfullyConfigured;
                    this.trace(Level.FINEST, CLASS_NAME, "initialize", "Registered labeling callback: {0}", null, null, labelingCbk);
                    Properties reqLabels = labelingCbk instanceof ConnectionLabelingCallback ? ((ConnectionLabelingCallback)labelingCbk).getRequestedLabels() : oupc.getConnectionLabels();
                    this.trace(Level.FINEST, CLASS_NAME, "initialize", "Requested labels: {0}", null, null, reqLabels);
                    if (null != reqLabels && reqLabels.getProperty(ORDS_REST_LABEL) != null) {
                        ConnectionRetrievalInfo criNoLabels = oupc.getConnectionRetrievalInfo().getCopyWithNoLabels();
                        oupc.setConnectionRetrievalInfo(criNoLabels);
                        this.trace(Level.FINEST, CLASS_NAME, "initialize", "Cleared labels on new connection", null, null, new Object[0]);
                    }
                    if (!(successfullyConfigured = labelingCbk.configure(reqLabels, this.getConnectionObjectForLabelingConfigure(oupc)))) {
                        this.trace(Level.WARNING, CLASS_NAME, "initialize", "failed to configure connection", null, null, new Object[0]);
                        throw new SQLException("failed to configure connection");
                    }
                    this.trace(Level.FINEST, CLASS_NAME, "initialize", "After configure, new labels: {0}", null, null, oupc.getConnectionLabels());
                } else {
                    ConnectionInitializationCallback connInitCallback = this.getConnectionInitializationCallback();
                    if (connInitCallback != null) {
                        connInitCallback.initialize((Connection)connection2);
                    }
                }
                this.incrementConnectionsCreatedCount();
                this.incrementCumulativeConnectionsCreated();
            }
            catch (SQLException e) {
                this.trace(Level.WARNING, CLASS_NAME, "initialize", "", null, e, new Object[0]);
                throw e;
            }
            catch (UniversalConnectionPoolException e) {
                SQLException newSqlExc = UCPErrorHandler.newSQLException(68, e);
                this.trace(Level.WARNING, CLASS_NAME, "initialize", "", null, e, new Object[0]);
                throw newSqlExc;
            }
            catch (Error | RuntimeException e) {
                this.trace(Level.WARNING, CLASS_NAME, "initialize", "got unchecked exception in AC reinitialization callback", null, null, new Object[0]);
                this.trace(Level.WARNING, CLASS_NAME, "initialize", "", null, e, new Object[0]);
                throw e;
            }
            this.debug(Level.INFO, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleReplayableConnectionConnectionPool", "initialize", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.INFO, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleReplayableConnectionConnectionPool", "initialize", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }
}

