/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import io.opentelemetry.api.common.Attributes;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.Premium;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.rules.CorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleOption;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.server.AuthException;
import org.languagetool.server.BadRequestException;
import org.languagetool.server.BasicAuthentication;
import org.languagetool.server.DatabaseAccess;
import org.languagetool.server.ErrorRequestLimiter;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.PathNotFoundException;
import org.languagetool.server.ServerMetricsCollector;
import org.languagetool.server.ServerTools;
import org.languagetool.server.TextChecker;
import org.languagetool.server.UserInfoEntry;
import org.languagetool.server.UserLimits;
import org.languagetool.tools.TelemetryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApiV2 {
    private static final Logger logger = LoggerFactory.getLogger(ApiV2.class);
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String TEXT_CONTENT_TYPE = "text/plain";
    private static final String ENCODING = "UTF-8";
    private final TextChecker textChecker;
    private final String allowOriginUrl;
    private final JsonFactory factory = new JsonFactory();

    ApiV2(TextChecker textChecker, String allowOriginUrl) {
        this.textChecker = textChecker;
        this.allowOriginUrl = allowOriginUrl;
    }

    void handleRequest(String path, HttpExchange httpExchange, Map<String, String> parameters, ErrorRequestLimiter errorRequestLimiter, String remoteAddress, HTTPServerConfig config) throws Exception {
        String spanName = "/v2/" + path;
        if (path.equals("languages")) {
            TelemetryProvider.INSTANCE.createSpan(spanName, Attributes.empty(), () -> this.handleLanguagesRequest(httpExchange));
        } else if (path.equals("maxtextlength")) {
            TelemetryProvider.INSTANCE.createSpan(spanName, Attributes.empty(), () -> this.handleMaxTextLengthRequest(httpExchange, config));
        } else if (path.equals("configinfo")) {
            TelemetryProvider.INSTANCE.createSpan(spanName, Attributes.empty(), () -> this.handleGetConfigurationInfoRequest(httpExchange, parameters, config));
        } else if (path.equals("info")) {
            TelemetryProvider.INSTANCE.createSpan(spanName, Attributes.empty(), () -> this.handleSoftwareInfoRequest(httpExchange));
        } else if (path.equals("check")) {
            TelemetryProvider.INSTANCE.createSpan(spanName, Attributes.empty(), () -> this.handleCheckRequest(httpExchange, parameters, errorRequestLimiter, remoteAddress, config));
        } else if (path.equals("words")) {
            TelemetryProvider.INSTANCE.createSpan(spanName, Attributes.empty(), () -> this.handleWordsRequest(httpExchange, parameters, config));
        } else if (path.equals("words/add")) {
            TelemetryProvider.INSTANCE.createSpan(spanName, Attributes.empty(), () -> this.handleWordAddRequest(httpExchange, parameters, config));
        } else if (path.equals("words/delete")) {
            TelemetryProvider.INSTANCE.createSpan(spanName, Attributes.empty(), () -> this.handleWordDeleteRequest(httpExchange, parameters, config));
        } else if (path.equals("admin/refreshUser")) {
            TelemetryProvider.INSTANCE.createSpan(spanName, Attributes.empty(), () -> this.handleRefreshUserInfoRequest(httpExchange, parameters, config));
        } else if (path.equals("users/me")) {
            TelemetryProvider.INSTANCE.createSpan(spanName, Attributes.empty(), () -> this.handleGetUserInfoRequest(httpExchange, parameters, config));
        } else {
            throw new PathNotFoundException("Unsupported action: '" + path + "'. Please see https://languagetool.org/http-api/swagger-ui/#/default");
        }
    }

    private void handleLanguagesRequest(HttpExchange httpExchange) throws IOException {
        String response = this.getLanguages();
        ServerTools.setCommonHeaders(httpExchange, JSON_CONTENT_TYPE, this.allowOriginUrl);
        httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
        ServerMetricsCollector.getInstance().logResponse(200);
    }

    private void handleMaxTextLengthRequest(HttpExchange httpExchange, HTTPServerConfig config) throws IOException {
        String response = Integer.toString(config.getMaxTextLengthAnonymous());
        ServerTools.setCommonHeaders(httpExchange, TEXT_CONTENT_TYPE, this.allowOriginUrl);
        httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
        ServerMetricsCollector.getInstance().logResponse(200);
    }

    private void handleGetConfigurationInfoRequest(HttpExchange httpExchange, Map<String, String> parameters, HTTPServerConfig config) throws IOException {
        if (parameters.get("language") == null) {
            throw new BadRequestException("'language' parameter missing");
        }
        Language lang = Languages.getLanguageForShortCode((String)parameters.get("language"));
        String response = this.getConfigurationInfo(lang, config);
        ServerTools.setCommonHeaders(httpExchange, JSON_CONTENT_TYPE, this.allowOriginUrl);
        httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
        ServerMetricsCollector.getInstance().logResponse(200);
    }

    private void handleSoftwareInfoRequest(HttpExchange httpExchange) throws IOException {
        String response = this.getSoftwareInfo();
        ServerTools.setCommonHeaders(httpExchange, JSON_CONTENT_TYPE, this.allowOriginUrl);
        httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
        ServerMetricsCollector.getInstance().logResponse(200);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleCheckRequest(HttpExchange httpExchange, Map<String, String> parameters, ErrorRequestLimiter errorRequestLimiter, String remoteAddress, HTTPServerConfig config) throws Exception {
        AnnotatedText aText;
        if (parameters.containsKey("text") && parameters.containsKey("data")) {
            throw new BadRequestException("Set only 'text' or 'data' parameter, not both");
        }
        if (parameters.containsKey("text")) {
            aText = new AnnotatedTextBuilder().addText(parameters.get("text")).build();
        } else {
            JsonNode data;
            if (!parameters.containsKey("data")) throw new BadRequestException("Missing 'text' or 'data' parameter");
            ObjectMapper mapper = new ObjectMapper();
            try {
                data = mapper.readTree(parameters.get("data"));
            }
            catch (JsonProcessingException e) {
                throw new BadRequestException("Could not parse JSON from 'data' parameter", (Exception)((Object)e));
            }
            if (data.get("text") != null && data.get("annotation") != null) {
                throw new BadRequestException("'data' key in JSON requires either 'text' or 'annotation' key, not both");
            }
            if (data.get("text") != null) {
                aText = this.getAnnotatedTextFromString(data, data.get("text").asText());
            } else {
                if (data.get("annotation") == null) throw new BadRequestException("'data' key in JSON requires 'text' or 'annotation' key");
                aText = this.getAnnotatedTextFromJson(data);
            }
        }
        if (config.logIp && aText.getPlainText().trim().equals(config.logIpMatchingPattern)) {
            this.handleIpLogMatch(httpExchange, remoteAddress, parameters);
            return;
        }
        this.textChecker.checkText(aText, httpExchange, parameters, errorRequestLimiter, remoteAddress);
    }

    private void handleIpLogMatch(HttpExchange httpExchange, String remoteAddress, Map<String, String> parameters) {
        Logger logger = LoggerFactory.getLogger(ApiV2.class);
        InetSocketAddress localAddress = httpExchange.getLocalAddress();
        logger.info(String.format("Found log-my-IP text in request from: %s to: %s, requestParams: %s", remoteAddress, localAddress.toString(), parameters));
    }

    private void handleWordsRequest(HttpExchange httpExchange, Map<String, String> params, HTTPServerConfig config) throws Exception {
        this.ensureGetMethod(httpExchange, "/words");
        UserLimits limits = this.getUserLimits(params, config);
        DatabaseAccess db = DatabaseAccess.getInstance();
        int offset = params.get("offset") != null ? Integer.parseInt(params.get("offset")) : 0;
        int limit = params.get("limit") != null ? Integer.parseInt(params.get("limit")) : 10;
        logger.info("Started reading dictionary for user: {}, offset: {}, limit: {}, dict_cache: {}, dict: {}", new Object[]{limits.getPremiumUid(), offset, limit, limits.getDictCacheSize(), params.get("dict")});
        if (params.containsKey("dict")) {
            throw new IllegalArgumentException("Use parameter 'dicts', not 'dict' in GET /words API method.");
        }
        List<String> groups = null;
        if (params.containsKey("dicts")) {
            groups = Arrays.asList(params.get("dicts").split(","));
        } else if (limits.getAccount() != null && limits.getAccount().getDefaultDictionary() != null && !limits.getAccount().getDefaultDictionary().isEmpty()) {
            groups = Collections.singletonList(limits.getAccount().getDefaultDictionary());
        }
        long start = System.nanoTime();
        List<String> words = db.getWords(limits, groups, offset, limit);
        long durationMilliseconds = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        logger.info("Finished reading dictionary for user: {}, offset: {}, limit: {}, dict_cache: {}, dict: {}, size: {} in {}ms", new Object[]{limits.getPremiumUid(), offset, limit, limits.getDictCacheSize(), params.get("dict"), words.size(), durationMilliseconds});
        this.writeListResponse("words", words, httpExchange);
    }

    private void handleWordAddRequest(HttpExchange httpExchange, Map<String, String> parameters, HTTPServerConfig config) throws Exception {
        this.ensurePostMethod(httpExchange, "/words/add");
        UserLimits limits = this.getUserLimits(parameters, config);
        DatabaseAccess db = DatabaseAccess.getInstance();
        String dict = parameters.get("dict");
        if (dict == null && limits.getAccount() != null && limits.getAccount().getDefaultDictionary() != null && !limits.getAccount().getDefaultDictionary().isEmpty()) {
            dict = limits.getAccount().getDefaultDictionary();
        }
        if ("batch".equals(parameters.get("mode"))) {
            List<String> words = Arrays.asList(parameters.get("words").split("\\s+"));
            db.addWordBatch(words, limits.getPremiumUid(), dict);
            this.writeResponse("added", true, httpExchange);
        } else {
            boolean added = db.addWord(parameters.get("word"), limits.getPremiumUid(), dict);
            this.writeResponse("added", added, httpExchange);
        }
    }

    private void handleWordDeleteRequest(HttpExchange httpExchange, Map<String, String> parameters, HTTPServerConfig config) throws Exception {
        this.ensurePostMethod(httpExchange, "/words/delete");
        UserLimits limits = this.getUserLimits(parameters, config);
        DatabaseAccess db = DatabaseAccess.getInstance();
        String dict = parameters.get("dict");
        if (dict == null && limits.getAccount() != null && limits.getAccount().getDefaultDictionary() != null && !limits.getAccount().getDefaultDictionary().isEmpty()) {
            dict = limits.getAccount().getDefaultDictionary();
        }
        if ("batch".equals(parameters.get("mode"))) {
            List<String> words = Arrays.asList(parameters.get("words").split("\\s+"));
            boolean deleted = db.deleteWordBatch(words, limits.getPremiumUid(), dict);
            this.writeResponse("deleted", deleted, httpExchange);
        } else {
            boolean deleted = db.deleteWord(parameters.get("word"), limits.getPremiumUid(), dict);
            this.writeResponse("deleted", deleted, httpExchange);
        }
    }

    private void handleRuleExamplesRequest(HttpExchange httpExchange, Map<String, String> params) throws Exception {
        this.ensureGetMethod(httpExchange, "/rule/examples");
        if (params.get("lang") == null) {
            throw new BadRequestException("'lang' parameter missing");
        }
        if (params.get("ruleId") == null) {
            throw new BadRequestException("'ruleId' parameter missing");
        }
        Language lang = Languages.getLanguageForShortCode((String)params.get("lang"));
        JLanguageTool lt = new JLanguageTool(lang);
        if (this.textChecker.config.languageModelDir != null) {
            lt.activateLanguageModelRules(this.textChecker.config.languageModelDir);
        }
        List rules = lt.getAllRules();
        ArrayList<Rule> foundRules = new ArrayList<Rule>();
        for (Rule rule : rules) {
            if (!rule.getId().equals(params.get("ruleId"))) continue;
            foundRules.add(rule);
        }
        if (foundRules.isEmpty()) {
            throw new PathNotFoundException("Rule '" + params.get("ruleId") + "' not found for language " + lang + " (LanguageTool version/date: " + JLanguageTool.VERSION + "/" + JLanguageTool.BUILD_DATE + ", total rules of language: " + rules.size() + ")");
        }
        StringWriter sw = new StringWriter();
        try (JsonGenerator g = this.factory.createGenerator((Writer)sw);){
            g.writeStartObject();
            g.writeArrayFieldStart("results");
            g.writeStartObject();
            g.writeStringField("warning", "*** This is not a public API - it may change anytime ***");
            g.writeEndObject();
            for (Rule foundRule : foundRules) {
                for (CorrectExample example : foundRule.getCorrectExamples()) {
                    g.writeStartObject();
                    g.writeStringField("status", "correct");
                    g.writeStringField("sentence", example.getExample());
                    g.writeEndObject();
                }
                for (CorrectExample example : foundRule.getIncorrectExamples()) {
                    g.writeStartObject();
                    g.writeStringField("status", "incorrect");
                    g.writeStringField("sentence", example.getExample());
                    g.writeArrayFieldStart("corrections");
                    for (String s : example.getCorrections()) {
                        g.writeString(s);
                    }
                    g.writeEndArray();
                    g.writeEndObject();
                }
            }
            g.writeEndArray();
            g.writeEndObject();
        }
        this.sendJson(httpExchange, sw);
    }

    private void handleRefreshUserInfoRequest(HttpExchange httpExchange, Map<String, String> params, HTTPServerConfig config) throws Exception {
        this.ensurePostMethod(httpExchange, "/admin/refreshUser");
        UserLimits limits = this.getUserLimits(params, config);
        DatabaseAccess db = DatabaseAccess.getInstance();
        if (limits.getPremiumUid() != null) {
            String user = params.get("username");
            if (user != null) {
                db.invalidateUserInfoCache(user);
                this.writeResponse("success", true, httpExchange);
            } else {
                this.writeResponse("success", false, httpExchange);
            }
        } else {
            this.writeResponse("success", false, httpExchange);
        }
    }

    private void handleGetUserInfoRequest(HttpExchange httpExchange, Map<String, String> parameters, HTTPServerConfig config) throws Exception {
        if (httpExchange.getRequestMethod().equalsIgnoreCase("options")) {
            ServerTools.setAllowOrigin(httpExchange, this.allowOriginUrl);
            httpExchange.getResponseHeaders().put("Access-Control-Allow-Methods", Collections.singletonList("GET, OPTIONS"));
            Object requestHeaders = httpExchange.getRequestHeaders().get("Access-Control-Request-Headers");
            if (requestHeaders != null) {
                httpExchange.getResponseHeaders().put("Access-Control-Allow-Headers", Collections.singletonList(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)requestHeaders)));
            }
            httpExchange.sendResponseHeaders(204, -1L);
            ServerMetricsCollector.getInstance().logResponse(204);
        } else {
            this.ensureGetMethod(httpExchange, "/users/me");
            if (!httpExchange.getRequestHeaders().containsKey("Authorization")) {
                throw new AuthException("Expected Basic Authentication");
            }
            String authParameter = parameters.getOrDefault("authMethod", "password");
            if (!(authParameter.equals("password") || authParameter.equals("apiKey") || authParameter.equals("addonToken"))) {
                throw new IllegalArgumentException("Unknown authMethod: " + authParameter);
            }
            String authHeader = httpExchange.getRequestHeaders().getFirst("Authorization");
            BasicAuthentication basicAuthentication = new BasicAuthentication(authHeader);
            String user = basicAuthentication.getUser();
            String password = basicAuthentication.getPassword();
            UserInfoEntry userInfo = null;
            if (authParameter.equals("password")) {
                userInfo = DatabaseAccess.getInstance().getUserInfoWithPassword(user, password);
            } else if (authParameter.equals("addonToken")) {
                userInfo = DatabaseAccess.getInstance().getUserInfoWithAddonToken(user, password);
            } else if (authParameter.equals("apiKey")) {
                userInfo = DatabaseAccess.getInstance().getUserInfoWithApiKey(user, password);
            }
            String format = parameters.getOrDefault("format", "extended");
            if (userInfo != null) {
                if (format.equals("minimal")) {
                    StringWriter sw = new StringWriter();
                    new ObjectMapper().writeValue((Writer)sw, (Object)userInfo);
                    this.sendJson(httpExchange, sw);
                } else {
                    StringWriter sw = new StringWriter();
                    new ObjectMapper().writeValue((Writer)sw, (Object)DatabaseAccess.getInstance().getExtendedUserInfo(user));
                    this.sendJson(httpExchange, sw);
                }
            } else {
                throw new IllegalStateException("Could not fetch user information");
            }
        }
    }

    private void ensureGetMethod(HttpExchange httpExchange, String url) {
        if (!httpExchange.getRequestMethod().equalsIgnoreCase("get")) {
            throw new BadRequestException(url + " needs to be called with GET");
        }
    }

    private void ensurePostMethod(HttpExchange httpExchange, String url) {
        if (!httpExchange.getRequestMethod().equalsIgnoreCase("post")) {
            throw new BadRequestException(url + " needs to be called with POST");
        }
    }

    @NotNull
    private UserLimits getUserLimits(Map<String, String> parameters, HTTPServerConfig config) {
        UserLimits limits = ServerTools.getUserLimits(parameters, config);
        if (limits.getPremiumUid() == null) {
            throw new BadRequestException("This end point needs a user id");
        }
        return limits;
    }

    private void writeResponse(String fieldName, boolean added, HttpExchange httpExchange) throws IOException {
        StringWriter sw = new StringWriter();
        try (JsonGenerator g = this.factory.createGenerator((Writer)sw);){
            g.writeStartObject();
            g.writeBooleanField(fieldName, added);
            g.writeEndObject();
        }
        this.sendJson(httpExchange, sw);
    }

    private void writeListResponse(String fieldName, List<String> words, HttpExchange httpExchange) throws IOException {
        StringWriter sw = new StringWriter();
        try (JsonGenerator g = this.factory.createGenerator((Writer)sw);){
            g.writeStartObject();
            g.writeArrayFieldStart(fieldName);
            for (String word : words) {
                g.writeString(word);
            }
            g.writeEndArray();
            g.writeEndObject();
        }
        this.sendJson(httpExchange, sw);
    }

    private void sendJson(HttpExchange httpExchange, StringWriter sw) throws IOException {
        String response = sw.toString();
        ServerTools.setCommonHeaders(httpExchange, JSON_CONTENT_TYPE, this.allowOriginUrl);
        httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
        ServerMetricsCollector.getInstance().logResponse(200);
    }

    private AnnotatedText getAnnotatedTextFromString(JsonNode data, String text) {
        AnnotatedTextBuilder textBuilder = new AnnotatedTextBuilder().addText(text);
        if (data.has("metaData")) {
            JsonNode metaData = data.get("metaData");
            Iterator it = metaData.fieldNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                String val = metaData.get(key).asText();
                try {
                    AnnotatedText.MetaDataKey metaDataKey = AnnotatedText.MetaDataKey.valueOf((String)key);
                    textBuilder.addGlobalMetaData(metaDataKey, val);
                }
                catch (IllegalArgumentException e) {
                    textBuilder.addGlobalMetaData(key, val);
                }
            }
        }
        return textBuilder.build();
    }

    private AnnotatedText getAnnotatedTextFromJson(JsonNode data) {
        AnnotatedTextBuilder atb = new AnnotatedTextBuilder();
        for (JsonNode node : data.get("annotation")) {
            if (node.get("text") != null && node.get("markup") != null) {
                throw new BadRequestException("Only either 'text' or 'markup' are supported in an object in 'annotation' list, not both: " + node);
            }
            if (node.get("text") != null && node.get("interpretAs") != null) {
                throw new BadRequestException("'text' cannot be used with 'interpretAs' (only 'markup' can): " + node);
            }
            if (node.get("text") != null) {
                atb.addText(node.get("text").asText());
                continue;
            }
            if (node.get("markup") != null) {
                if (node.get("interpretAs") != null) {
                    atb.addMarkup(node.get("markup").asText(), node.get("interpretAs").asText());
                    continue;
                }
                atb.addMarkup(node.get("markup").asText());
                continue;
            }
            throw new BadRequestException("Only 'text' and 'markup' are supported in 'annotation' list: " + node);
        }
        return atb.build();
    }

    String getLanguages() throws IOException {
        StringWriter sw = new StringWriter();
        try (JsonGenerator g = this.factory.createGenerator((Writer)sw);){
            g.writeStartArray();
            ArrayList languages = new ArrayList(Languages.get());
            HashSet<String> longCodes = new HashSet<String>();
            for (Language lang : languages) {
                g.writeStartObject();
                g.writeStringField("name", lang.getName());
                g.writeStringField("code", lang.getShortCode());
                g.writeStringField("longCode", lang.getShortCodeWithCountryAndVariant());
                longCodes.add(lang.getShortCodeWithCountryAndVariant());
                g.writeEndObject();
            }
            Map codeMap = Languages.getLongCodeToLangMapping();
            for (Map.Entry entry : codeMap.entrySet()) {
                if (longCodes.contains(entry.getKey())) continue;
                g.writeStartObject();
                g.writeStringField("name", ((Language)entry.getValue()).getName());
                g.writeStringField("code", ((Language)entry.getValue()).getShortCode());
                g.writeStringField("longCode", (String)entry.getKey());
                g.writeEndObject();
            }
            g.writeEndArray();
        }
        return sw.toString();
    }

    String getSoftwareInfo() throws IOException {
        StringWriter sw = new StringWriter();
        try (JsonGenerator g = this.factory.createGenerator((Writer)sw);){
            g.writeStartObject();
            g.writeObjectFieldStart("software");
            g.writeStringField("name", "LanguageTool");
            g.writeStringField("version", JLanguageTool.VERSION);
            g.writeStringField("buildDate", JLanguageTool.BUILD_DATE);
            g.writeStringField("commit", JLanguageTool.GIT_SHORT_ID);
            g.writeBooleanField("premium", Premium.isPremiumVersion());
            if (Premium.isPremiumVersion()) {
                Premium premium = Premium.get();
                g.writeObjectFieldStart("premiumBuildInfo");
                g.writeStringField("version", premium.getVersion());
                g.writeStringField("buildDate", premium.getBuildDate());
                g.writeStringField("commit", premium.getShortGitId());
                g.writeEndObject();
            }
            g.writeEndObject();
            g.writeEndObject();
        }
        return sw.toString();
    }

    String getConfigurationInfo(Language lang, HTTPServerConfig config) throws IOException {
        StringWriter sw = new StringWriter();
        JLanguageTool lt = new JLanguageTool(lang);
        if (this.textChecker.config.languageModelDir != null) {
            lt.activateLanguageModelRules(this.textChecker.config.languageModelDir);
        }
        List rules = lt.getAllRules();
        rules = rules.stream().filter(rule -> !Premium.get().isPremiumRule(rule)).collect(Collectors.toList());
        try (JsonGenerator g = this.factory.createGenerator((Writer)sw);){
            g.writeStartObject();
            g.writeObjectFieldStart("software");
            g.writeStringField("name", "LanguageTool");
            g.writeStringField("version", JLanguageTool.VERSION);
            g.writeStringField("buildDate", JLanguageTool.BUILD_DATE);
            g.writeBooleanField("premium", Premium.isPremiumVersion());
            g.writeEndObject();
            g.writeObjectFieldStart("parameter");
            g.writeNumberField("maxTextLength", config.getMaxTextHardLength());
            g.writeEndObject();
            g.writeArrayFieldStart("rules");
            for (Rule rule2 : rules) {
                RuleOption[] ruleOptions;
                g.writeStartObject();
                g.writeStringField("ruleId", rule2.getId());
                g.writeStringField("description", rule2.getDescription());
                if (rule2.isDictionaryBasedSpellingRule()) {
                    g.writeStringField("isDictionaryBasedSpellingRule", "yes");
                }
                if (rule2.isDefaultOff()) {
                    g.writeStringField("isDefaultOff", "yes");
                }
                if (rule2.isOfficeDefaultOff()) {
                    g.writeStringField("isOfficeDefaultOff", "yes");
                }
                if (rule2.isOfficeDefaultOn()) {
                    g.writeStringField("isOfficeDefaultOn", "yes");
                }
                if ((ruleOptions = rule2.getRuleOptions()) != null) {
                    if (ruleOptions[0].getDefaultValue() instanceof Integer) {
                        g.writeStringField("hasConfigurableValue", "yes");
                        g.writeStringField("configureText", ruleOptions[0].getConfigureText());
                        g.writeStringField("maxConfigurableValue", Integer.toString((Integer)ruleOptions[0].getMaxConfigurableValue()));
                        g.writeStringField("minConfigurableValue", Integer.toString((Integer)ruleOptions[0].getMinConfigurableValue()));
                        g.writeStringField("defaultValue", Integer.toString((Integer)ruleOptions[0].getDefaultValue()));
                    }
                    g.writeArrayFieldStart("ruleOptions");
                    for (RuleOption rOption : ruleOptions) {
                        g.writeStartObject();
                        Object o = rOption.getDefaultValue();
                        if (o instanceof Integer) {
                            g.writeStringField("defaultType", "Integer");
                            g.writeNumberField("defaultValue", ((Integer)o).intValue());
                            g.writeNumberField("minConfigurableValue", ((Integer)rOption.getMinConfigurableValue()).intValue());
                            g.writeNumberField("maxConfigurableValue", ((Integer)rOption.getMaxConfigurableValue()).intValue());
                        } else if (o instanceof Character) {
                            g.writeStringField("defaultType", "Character");
                            g.writeStringField("defaultValue", o.toString());
                            g.writeStringField("defaultValue", rOption.getMinConfigurableValue().toString());
                            g.writeStringField("defaultValue", rOption.getMaxConfigurableValue().toString());
                        } else if (o instanceof Boolean) {
                            g.writeStringField("defaultType", "Boolean");
                            g.writeBooleanField("defaultValue", ((Boolean)o).booleanValue());
                            g.writeNumberField("minConfigurableValue", ((Integer)rOption.getMinConfigurableValue()).intValue());
                            g.writeNumberField("maxConfigurableValue", ((Integer)rOption.getMaxConfigurableValue()).intValue());
                        } else if (o instanceof Float) {
                            g.writeStringField("defaultType", "Float");
                            g.writeNumberField("defaultValue", ((Float)o).floatValue());
                            g.writeNumberField("minConfigurableValue", ((Float)rOption.getMinConfigurableValue()).floatValue());
                            g.writeNumberField("maxConfigurableValue", ((Float)rOption.getMaxConfigurableValue()).floatValue());
                        } else if (o instanceof Double) {
                            g.writeStringField("defaultType", "Double");
                            g.writeNumberField("defaultValue", ((Double)o).doubleValue());
                            g.writeNumberField("minConfigurableValue", ((Double)rOption.getMinConfigurableValue()).doubleValue());
                            g.writeNumberField("maxConfigurableValue", ((Double)rOption.getMaxConfigurableValue()).doubleValue());
                        } else {
                            g.writeStringField("defaultType", "String");
                            g.writeStringField("defaultValue", o.toString());
                            g.writeStringField("minConfigurableValue", rOption.getMinConfigurableValue().toString());
                            g.writeStringField("maxConfigurableValue", rOption.getMaxConfigurableValue().toString());
                        }
                        g.writeStringField("configureText", rOption.getConfigureText());
                        g.writeEndObject();
                    }
                    g.writeEndArray();
                }
                g.writeStringField("categoryId", rule2.getCategory().getId().toString());
                g.writeStringField("categoryName", rule2.getCategory().getName());
                g.writeStringField("locQualityIssueType", rule2.getLocQualityIssueType().toString());
                if (rule2 instanceof TextLevelRule) {
                    g.writeStringField("isTextLevelRule", "yes");
                    g.writeStringField("minToCheckParagraph", Integer.toString(((TextLevelRule)rule2).minToCheckParagraph()));
                }
                g.writeEndObject();
            }
            g.writeEndArray();
            g.writeEndObject();
        }
        return sw.toString();
    }
}

