/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.List;
import java.util.function.BiPredicate;
import org.keycloak.events.Event;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.workflow.WorkflowEvent;
import org.keycloak.provider.ProviderEvent;

public enum ResourceOperationType {
    USER_CREATED(List.of(OperationType.CREATE, EventType.REGISTER)),
    USER_AUTHENTICATED(List.of(EventType.LOGIN), ResourceOperationType.userLoginPredicate()),
    USER_FEDERATED_IDENTITY_ADDED(List.of(FederatedIdentityModel.FederatedIdentityCreatedEvent.class), ResourceOperationType.fedIdentityPredicate()),
    USER_FEDERATED_IDENTITY_REMOVED(List.of(FederatedIdentityModel.FederatedIdentityRemovedEvent.class), ResourceOperationType.fedIdentityPredicate()),
    USER_GROUP_MEMBERSHIP_ADDED(List.of(GroupModel.GroupMemberJoinEvent.class), ResourceOperationType.groupMembershipPredicate()),
    USER_GROUP_MEMBERSHIP_REMOVED(List.of(GroupModel.GroupMemberLeaveEvent.class), ResourceOperationType.groupMembershipPredicate()),
    USER_ROLE_GRANTED(List.of(RoleModel.RoleGrantedEvent.class), ResourceOperationType.roleMembershipPredicate()),
    USER_ROLE_REVOKED(List.of(RoleModel.RoleRevokedEvent.class), ResourceOperationType.roleMembershipPredicate()),
    AD_HOC(List.of(new Class[0]));

    private final List<Object> types;
    private final List<Object> deactivationTypes;
    private final BiPredicate<WorkflowEvent, String> conditionPredicate;

    private ResourceOperationType(List<Object> types) {
        this.types = types;
        this.deactivationTypes = List.of();
        this.conditionPredicate = this.defaultPredicate();
    }

    private ResourceOperationType(List<Object> types, BiPredicate<WorkflowEvent, String> conditionPredicate) {
        this.types = types;
        this.deactivationTypes = List.of();
        this.conditionPredicate = this.defaultPredicate().and(conditionPredicate);
    }

    public static ResourceOperationType toOperationType(Enum<?> from) {
        return ResourceOperationType.toOperationType(from);
    }

    public static ResourceOperationType toOperationType(Class<?> from) {
        return ResourceOperationType.toOperationType(from);
    }

    private static ResourceOperationType toOperationType(Object from) {
        for (ResourceOperationType value : ResourceOperationType.values()) {
            if (value.types.contains(from)) {
                return value;
            }
            for (Object type : value.types) {
                Class cls;
                if (!(type instanceof Class) || !(cls = (Class)type).isAssignableFrom((Class)from)) continue;
                return value;
            }
        }
        return null;
    }

    public String getResourceId(ProviderEvent event) {
        if (event instanceof GroupModel.GroupMemberJoinEvent) {
            GroupModel.GroupMemberJoinEvent gme = (GroupModel.GroupMemberJoinEvent)event;
            return gme.getUser().getId();
        }
        if (event instanceof GroupModel.GroupMemberLeaveEvent) {
            GroupModel.GroupMemberLeaveEvent gme = (GroupModel.GroupMemberLeaveEvent)event;
            return gme.getUser().getId();
        }
        if (event instanceof FederatedIdentityModel.FederatedIdentityCreatedEvent) {
            FederatedIdentityModel.FederatedIdentityCreatedEvent fie = (FederatedIdentityModel.FederatedIdentityCreatedEvent)event;
            return fie.getUser().getId();
        }
        if (event instanceof FederatedIdentityModel.FederatedIdentityRemovedEvent) {
            FederatedIdentityModel.FederatedIdentityRemovedEvent fie = (FederatedIdentityModel.FederatedIdentityRemovedEvent)event;
            return fie.getUser().getId();
        }
        if (event instanceof RoleModel.RoleGrantedEvent) {
            RoleModel.RoleGrantedEvent rge = (RoleModel.RoleGrantedEvent)event;
            return rge.getUser().getId();
        }
        if (event instanceof RoleModel.RoleRevokedEvent) {
            RoleModel.RoleRevokedEvent rre = (RoleModel.RoleRevokedEvent)event;
            return rre.getUser().getId();
        }
        return null;
    }

    public boolean isDeactivationEvent(Class<?> eventType) {
        for (Object deactivationType : this.deactivationTypes) {
            Class cls;
            if (!(deactivationType instanceof Class) || !(cls = (Class)deactivationType).isAssignableFrom(eventType)) continue;
            return true;
        }
        return false;
    }

    public boolean test(WorkflowEvent event, String detail) {
        return this.conditionPredicate.test(event, detail);
    }

    private BiPredicate<WorkflowEvent, String> defaultPredicate() {
        return (event, detail) -> event.getOperation().equals((Object)this);
    }

    private static BiPredicate<WorkflowEvent, String> userLoginPredicate() {
        return (event, detail) -> {
            if (detail != null) {
                Event loginEvent = (Event)event.getEvent();
                return detail.equals(loginEvent.getClientId());
            }
            return true;
        };
    }

    private static BiPredicate<WorkflowEvent, String> groupMembershipPredicate() {
        return (event, groupName) -> {
            if (groupName != null) {
                ProviderEvent groupEvent;
                if (!((String)groupName).startsWith("/")) {
                    groupName = "/" + (String)groupName;
                }
                if ((groupEvent = (ProviderEvent)event.getEvent()) instanceof GroupModel.GroupMemberJoinEvent) {
                    GroupModel.GroupMemberJoinEvent joinEvent = (GroupModel.GroupMemberJoinEvent)groupEvent;
                    return ((String)groupName).equals(KeycloakModelUtils.buildGroupPath(joinEvent.getGroup()));
                }
                if (groupEvent instanceof GroupModel.GroupMemberLeaveEvent) {
                    GroupModel.GroupMemberLeaveEvent leaveEvent = (GroupModel.GroupMemberLeaveEvent)groupEvent;
                    return ((String)groupName).equals(KeycloakModelUtils.buildGroupPath(leaveEvent.getGroup()));
                }
                return false;
            }
            return true;
        };
    }

    private static BiPredicate<WorkflowEvent, String> roleMembershipPredicate() {
        return (event, roleName) -> {
            if (roleName != null) {
                ProviderEvent roleEvent = (ProviderEvent)event.getEvent();
                if (roleEvent instanceof RoleModel.RoleGrantedEvent) {
                    RoleModel.RoleGrantedEvent roleGrantedEvent = (RoleModel.RoleGrantedEvent)roleEvent;
                    return roleName.equals(roleGrantedEvent.getRole().getName());
                }
                if (roleEvent instanceof RoleModel.RoleRevokedEvent) {
                    RoleModel.RoleRevokedEvent roleRevokedEvent = (RoleModel.RoleRevokedEvent)roleEvent;
                    return roleName.equals(roleRevokedEvent.getRole().getName());
                }
                return false;
            }
            return true;
        };
    }

    private static BiPredicate<WorkflowEvent, String> fedIdentityPredicate() {
        return (event, idpAlias) -> {
            if (idpAlias != null) {
                ProviderEvent fedIdentityEvent = (ProviderEvent)event.getEvent();
                if (fedIdentityEvent instanceof FederatedIdentityModel.FederatedIdentityCreatedEvent) {
                    FederatedIdentityModel.FederatedIdentityCreatedEvent fedIdentityCreatedEvent = (FederatedIdentityModel.FederatedIdentityCreatedEvent)fedIdentityEvent;
                    return idpAlias.equals(fedIdentityCreatedEvent.getFederatedIdentity().getIdentityProvider());
                }
                if (fedIdentityEvent instanceof FederatedIdentityModel.FederatedIdentityRemovedEvent) {
                    FederatedIdentityModel.FederatedIdentityRemovedEvent fedIdentityRemovedEvent = (FederatedIdentityModel.FederatedIdentityRemovedEvent)fedIdentityEvent;
                    return idpAlias.equals(fedIdentityRemovedEvent.getFederatedIdentity().getIdentityProvider());
                }
                return false;
            }
            return true;
        };
    }
}

