/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.api.Error;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

class ReifyingAllocator
implements ObjectAllocator {
    private final Class<? extends IRubyObject> klass;
    private final Constructor<? extends IRubyObject> cons;

    public ReifyingAllocator(Class<? extends IRubyObject> klass) {
        this.klass = klass;
        try {
            this.cons = klass.getDeclaredConstructor(Ruby.class, RubyClass.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }

    @Override
    public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
        try {
            if (klazz.getReifiedRubyClass() == this.klass) {
                return this.cons.newInstance(runtime2, klazz);
            }
            ReifyingAllocator.reifyWithAncestors(klazz);
            return klazz.getAllocator().allocate(runtime2, klazz);
        }
        catch (InstantiationException ie) {
            throw Error.typeError(runtime2.getCurrentContext(), "could not allocate " + String.valueOf(this.klass) + " with default constructor:\n" + String.valueOf(ie));
        }
        catch (IllegalAccessException iae) {
            throw runtime2.newSecurityError("could not allocate " + String.valueOf(this.klass) + " due to inaccessible default constructor:\n" + String.valueOf(iae));
        }
        catch (InvocationTargetException ite) {
            throw runtime2.newSecurityError("could not allocate " + String.valueOf(this.klass) + " due to inaccessible default constructor:\n" + String.valueOf(ite));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reifyWithAncestors(RubyClass klazz) {
        RubyClass realSuper = klazz.getSuperClass().getRealClass();
        if (realSuper.getReifiedRubyClass() == null) {
            ReifyingAllocator.reifyWithAncestors(realSuper);
        }
        RubyClass rubyClass = klazz;
        synchronized (rubyClass) {
            klazz.reify();
            klazz.allocator(new ReifyingAllocator(klazz.getReifiedRubyClass()));
        }
    }
}

