/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import java.util.Arrays;
import org.joni.Region;

public final class MultiRegion
extends Region {
    private final int[] begEnd;

    public MultiRegion(int num) {
        this.begEnd = new int[num * 2];
    }

    public MultiRegion(int begin2, int end2) {
        this.begEnd = new int[]{begin2, end2};
    }

    @Override
    public final int getNumRegs() {
        return this.begEnd.length / 2;
    }

    @Override
    public MultiRegion clone() {
        MultiRegion region = new MultiRegion(this.getNumRegs());
        System.arraycopy(this.begEnd, 0, region.begEnd, 0, this.begEnd.length);
        if (this.getCaptureTree() != null) {
            region.setCaptureTree(this.getCaptureTree().cloneTree());
        }
        return region;
    }

    @Override
    public int getBeg(int index2) {
        return this.begEnd[index2 * 2];
    }

    @Override
    public int setBeg(int index2, int value2) {
        int n = value2;
        this.begEnd[index2 * 2] = n;
        return n;
    }

    @Override
    public int getEnd(int index2) {
        return this.begEnd[index2 * 2 + 1];
    }

    @Override
    public int setEnd(int index2, int value2) {
        int n = value2;
        this.begEnd[index2 * 2 + 1] = n;
        return n;
    }

    @Override
    void clear() {
        Arrays.fill(this.begEnd, -1);
    }
}

