/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuardImpl;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.ModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.util.SimpleModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.Strings;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiTreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiTreeChangePreprocessor;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentFactoryMap;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;

public final class PsiModificationTrackerImpl
implements PsiTreeChangePreprocessor,
PsiModificationTracker {
    private final SimpleModificationTracker myModificationCount;
    private final SimpleModificationTracker myAllLanguagesTracker;
    private final Map<Language, SimpleModificationTracker> myLanguageTrackers;
    private final PsiModificationTracker.Listener myPublisher;

    public PsiModificationTrackerImpl(@NotNull Project project) {
        if (project == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(0);
        }
        this.myModificationCount = new SimpleModificationTracker();
        this.myAllLanguagesTracker = new SimpleModificationTracker();
        this.myLanguageTrackers = ConcurrentFactoryMap.createWeakMap(language2 -> new SimpleModificationTracker());
        MessageBus bus = project.getMessageBus();
        this.myPublisher = (PsiModificationTracker.Listener)bus.syncPublisher(TOPIC);
        bus.connect().subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                PsiModificationTrackerImpl.this.doIncCounter();
            }

            public void exitDumbMode() {
                PsiModificationTrackerImpl.this.doIncCounter();
            }
        });
    }

    private void doIncCounter() {
        ApplicationManager.getApplication().runWriteAction(() -> this.incCountersInner());
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void incCounter() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.incCountersInner();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void incOutOfCodeBlockModificationCounter() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.incCountersInner();
    }

    private void fireEvent() {
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        this.myPublisher.modificationCountChanged();
    }

    private void incCountersInner() {
        this.myModificationCount.incModificationCount();
        this.fireEvent();
    }

    @Override
    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(1);
        }
        if (!PsiModificationTrackerImpl.canAffectPsi(event)) {
            return;
        }
        this.incLanguageCounters(event);
        this.incCountersInner();
    }

    public static boolean canAffectPsi(@NotNull PsiTreeChangeEventImpl event) {
        PsiTreeChangeEventImpl.PsiEventType code;
        if (event == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(2);
        }
        return (code = event.getCode()) != PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE && (code != PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED || !Strings.areSameInstance(event.getPropertyName(), "writable"));
    }

    private void incLanguageCounters(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(3);
        }
        PsiTreeChangeEventImpl.PsiEventType code = event.getCode();
        String propertyName = event.getPropertyName();
        if (code == PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED && (Strings.areSameInstance(propertyName, "propUnloadedPsi") || Strings.areSameInstance(propertyName, "roots") || Strings.areSameInstance(propertyName, "propFileTypes")) || code == PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED && event.getChild() instanceof PsiDirectory) {
            this.myAllLanguagesTracker.incModificationCount();
            return;
        }
        PsiElement[] elements = new PsiElement[]{event.getFile(), event.getParent(), event.getOldParent(), event.getNewParent(), event.getElement(), event.getChild(), event.getOldChild(), event.getNewChild()};
        this.incLanguageModificationCount(Language.ANY);
        for (PsiElement o2 : elements) {
            if (o2 == null || o2 instanceof PsiDirectory) continue;
            if (o2 instanceof PsiFile) {
                for (Language language2 : ((PsiFile)o2).getViewProvider().getLanguages()) {
                    this.incLanguageModificationCount(language2);
                }
                continue;
            }
            try {
                Language language2;
                IElementType type = PsiUtilCore.getElementType(o2);
                language2 = type != null ? type.getLanguage() : o2.getLanguage();
                this.incLanguageModificationCount(language2);
            }
            catch (PsiInvalidElementAccessException e2) {
                PsiDocumentManagerBase.LOG.warn(e2);
            }
        }
    }

    @Override
    public long getModificationCount() {
        return this.myModificationCount.getModificationCount();
    }

    @Override
    @NotNull
    public ModificationTracker getJavaStructureModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myModificationCount;
        if (simpleModificationTracker == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(4);
        }
        return simpleModificationTracker;
    }

    @ApiStatus.Experimental
    public void incLanguageModificationCount(@Nullable Language language2) {
        if (language2 == null) {
            return;
        }
        this.myLanguageTrackers.get(language2).incModificationCount();
    }

    @Override
    @NotNull
    public ModificationTracker forLanguage(@NotNull Language language2) {
        if (language2 == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(5);
        }
        SimpleModificationTracker languageTracker = this.myLanguageTrackers.get(language2);
        ModificationTracker modificationTracker = () -> languageTracker.getModificationCount() + this.myAllLanguagesTracker.getModificationCount();
        if (modificationTracker == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(6);
        }
        return modificationTracker;
    }

    @Override
    @NotNull
    public ModificationTracker forLanguages(@NotNull Predicate<? super Language> condition) {
        if (condition == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(7);
        }
        ModificationTracker modificationTracker = () -> {
            long result2 = this.myAllLanguagesTracker.getModificationCount();
            for (Language l2 : this.myLanguageTrackers.keySet()) {
                if (!condition.test(l2)) continue;
                result2 += this.myLanguageTrackers.get(l2).getModificationCount();
            }
            return result2;
        };
        if (modificationTracker == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(8);
        }
        return modificationTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiModificationTrackerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiModificationTrackerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaStructureModificationTracker";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguages";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "treeChanged";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canAffectPsi";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "incLanguageCounters";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forLanguages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

