/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.disassemble;

import docking.ActionContext;
import ghidra.app.plugin.assembler.Assembler;
import ghidra.app.plugin.assembler.Assemblers;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.core.assembler.AssemblyDualTextField;
import ghidra.app.plugin.core.assembler.PatchInstructionAction;
import ghidra.app.plugin.core.debug.disassemble.DebuggerDisassemblerPlugin;
import ghidra.app.plugin.core.debug.disassemble.TraceDisassembleCommand;
import ghidra.app.services.DebuggerControlService;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.DefaultLanguageService;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractTracePatchInstructionAction
extends PatchInstructionAction {
    protected final DebuggerDisassemblerPlugin plugin;

    public AbstractTracePatchInstructionAction(DebuggerDisassemblerPlugin plugin, String name) {
        super((Plugin)plugin, name);
        this.plugin = plugin;
    }

    protected abstract TracePlatform getPlatform(CodeUnit var1);

    protected RegisterValue getContextValue(CodeUnit cu) {
        return DebuggerDisassemblerPlugin.deriveAlternativeDefaultContext(this.getPlatform(cu).getLanguage(), this.getAlternativeLanguageID(cu), cu.getAddress());
    }

    protected LanguageID getAlternativeLanguageID(CodeUnit cu) {
        return this.getPlatform(cu).getLanguage().getLanguageID();
    }

    protected AssemblyDualTextField newAssemblyDualTextField() {
        return new AssemblyDualTextField(){
            AssemblyPatternBlock ctx = null;

            protected AssemblyPatternBlock getContext() {
                return this.ctx;
            }

            public void setAddress(Address address) {
                super.setAddress(address);
                RegisterValue rv = AbstractTracePatchInstructionAction.this.getContextValue(AbstractTracePatchInstructionAction.this.getCodeUnit());
                this.ctx = rv == null ? AssemblyPatternBlock.nop() : AssemblyPatternBlock.fromRegisterValue((RegisterValue)rv).fillMask();
            }
        };
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!super.isAddToPopup(context)) {
            return false;
        }
        CodeUnit cu = this.getCodeUnit(context);
        return this.isApplicableToUnit(cu);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!super.isEnabledForContext(context)) {
            return false;
        }
        CodeUnit cu = this.getCodeUnit(context);
        return this.isApplicableToUnit(cu);
    }

    public void actionPerformed(ActionContext context) {
        try {
            DefaultLanguageService.getLanguageService().getLanguage(this.getAlternativeLanguageID(this.getCodeUnit(context)));
        }
        catch (LanguageNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        super.actionPerformed(context);
    }

    protected Language getLanguage(CodeUnit cu) {
        return this.getPlatform(cu).getLanguage();
    }

    protected Assembler getAssembler(CodeUnit cu) {
        return Assemblers.getAssembler((Language)this.language);
    }

    protected void applyPatch(byte[] data) throws MemoryAccessException {
        TraceProgramView view = this.getView();
        if (view == null) {
            return;
        }
        PatchInstructionCommand patch = new PatchInstructionCommand(data);
        patch.run(this.tool, (DomainObject)view);
    }

    protected TraceProgramView getView() {
        Program program = this.getProgram();
        if (!(program instanceof TraceProgramView)) {
            return null;
        }
        TraceProgramView view = (TraceProgramView)program;
        return view;
    }

    class PatchInstructionCommand
    extends BackgroundCommand<TraceProgramView> {
        private final byte[] data;

        public PatchInstructionCommand(byte[] data) {
            this.data = data;
        }

        public boolean applyTo(TraceProgramView view, TaskMonitor monitor) {
            DebuggerControlService controlService = (DebuggerControlService)AbstractTracePatchInstructionAction.this.tool.getService(DebuggerControlService.class);
            if (controlService == null) {
                return true;
            }
            DebuggerControlService.StateEditor editor = controlService.createStateEditor(view);
            Address address = AbstractTracePatchInstructionAction.this.getAddress();
            CodeUnit cu = AbstractTracePatchInstructionAction.this.getCodeUnit();
            RegisterValue contextValue = AbstractTracePatchInstructionAction.this.getContextValue(cu);
            TracePlatform platform = AbstractTracePatchInstructionAction.this.getPlatform(cu);
            try {
                editor.setVariable(address, this.data).get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                this.setStatusMsg("Couldn't patch: " + String.valueOf(e));
                Msg.error((Object)((Object)this), (Object)"Couldn't patch", (Throwable)e);
                return false;
            }
            AddressSet set = new AddressSet(address, address.add((long)(this.data.length - 1)));
            TraceDisassembleCommand dis = new TraceDisassembleCommand(platform, address, (AddressSetView)set);
            if (contextValue != null) {
                dis.setInitialContext(contextValue);
            }
            dis.run(AbstractTracePatchInstructionAction.this.tool, (DomainObject)view);
            return true;
        }
    }
}

