/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.flags.CliFlags;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexImplementation;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliTableManifestResource
extends CliAbstractTable {
    public CliTableManifestResource(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliManifestResourceRow row = new CliManifestResourceRow(reader.readNextInt(), reader.readNextInt(), this.readStringIndex(reader), CliIndexImplementation.readCodedIndex(reader, stream));
            this.rows.add(row);
            this.strings.add(row.nameIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "ManifestResource Row", 0);
        rowDt.add(DWORD, "Offset", null);
        rowDt.add((DataType)CliFlags.CliEnumManifestResourceAttributes.dataType, "Flags", "Bitmask of type ManifestResourceAttributes");
        rowDt.add(this.metadataStream.getStringIndexDataType(), "Name", "index into String heap");
        rowDt.add(CliIndexImplementation.toDataType(this.metadataStream), "Implementation", "Implementation coded index");
        return rowDt;
    }

    public class CliManifestResourceRow
    extends CliAbstractTableRow {
        public int offset;
        public int flags;
        public int nameIndex;
        public int implIndex;

        public CliManifestResourceRow(int offset, int flags, int nameIndex, int implIndex) {
            this.offset = offset;
            this.flags = flags;
            this.nameIndex = nameIndex;
            this.implIndex = implIndex;
        }

        @Override
        public String getRepresentation() {
            String implRep;
            try {
                implRep = CliTableManifestResource.this.getRowRepresentationSafe(CliIndexImplementation.getTableName(this.implIndex), CliIndexImplementation.getRowIndex(this.implIndex));
            }
            catch (InvalidInputException e) {
                implRep = Integer.toHexString(this.implIndex);
            }
            return String.format("%s Offset %x Flags %s Implementation %s", CliTableManifestResource.this.metadataStream.getStringsStream().getString(this.nameIndex), this.offset, CliFlags.CliEnumManifestResourceAttributes.dataType.getName(this.flags & 0xFFFFFFFF), implRep);
        }
    }
}

