/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.appearance;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.appearance.api.Function;
import org.gephi.desktop.appearance.AppearanceUIController;
import org.gephi.desktop.appearance.AppearanceUIModel;
import org.gephi.desktop.appearance.TableObserverExecutor;
import org.openide.util.Lookup;

public class FunctionObserverExecutor
implements Runnable {
    private static final long DEFAULT_DELAY = 1250L;
    private final AppearanceUIModel model;
    private ScheduledExecutorService executor;

    public FunctionObserverExecutor(AppearanceUIModel model) {
        this.model = model;
    }

    public void start() {
        this.executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "Appearance Function Observer"));
        this.executor.scheduleWithFixedDelay(this, this.getDelayInMs(), this.getDelayInMs(), TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
        }
        this.executor = null;
    }

    @Override
    public void run() {
        try {
            Function selectedFunction = this.model.getSelectedFunction();
            if (selectedFunction != null && selectedFunction.hasChanged()) {
                ((AppearanceUIController)Lookup.getDefault().lookup(AppearanceUIController.class)).refreshFunction();
            }
        }
        catch (Exception e) {
            Logger.getLogger(TableObserverExecutor.class.getName()).log(Level.SEVERE, "Error while refreshing appearance's function", e);
        }
    }

    public boolean isRunning() {
        return this.executor != null;
    }

    private long getDelayInMs() {
        return 1250L;
    }
}

