/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.filter;

import java.util.regex.Matcher;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.filter.SecurityRequestChannel;
import org.opensearch.security.filter.SecurityRestFilter;

public class SecurityRestUtils {
    public static String path(String uri) {
        int index = uri.indexOf(63);
        if (index >= 0) {
            return uri.substring(0, index);
        }
        return uri;
    }

    public static boolean shouldSkipAuthentication(SecurityRequestChannel request) {
        Matcher matcher = SecurityRestFilter.PATTERN_PATH_PREFIX.matcher(request.path());
        String suffix = matcher.matches() ? matcher.group(2) : null;
        boolean shouldSkipAuthentication = request.method() == RestRequest.Method.OPTIONS || "health".equals(suffix) || "whoami".equals(suffix);
        return shouldSkipAuthentication;
    }
}

