/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.sequence;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.tribuo.Example;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.sequence.SequenceExample;
import org.tribuo.sequence.SequenceModel;

public class IndependentSequenceModel<T extends Output<T>>
extends SequenceModel<T> {
    private static final Logger logger = Logger.getLogger(IndependentSequenceModel.class.getName());
    private static final long serialVersionUID = 1L;
    private final Model<T> model;

    IndependentSequenceModel(String name, ModelProvenance description, Model<T> model) {
        super(name, description, model.getFeatureIDMap(), model.getOutputIDInfo());
        this.model = model;
    }

    @Override
    public List<Prediction<T>> predict(SequenceExample<T> example) {
        ArrayList<Prediction<T>> output = new ArrayList<Prediction<T>>();
        for (Example<T> e : example) {
            output.add(this.model.predict(e));
        }
        return output;
    }

    @Override
    public Map<String, List<Pair<String, Double>>> getTopFeatures(int n) {
        return this.model.getTopFeatures(n);
    }
}

