/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.onnx;

import ai.onnx.proto.OnnxMl;
import com.google.protobuf.ByteString;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class ONNXAttribute {
    public static final int VARIADIC_INPUT = -1;
    private final String name;
    private final OnnxMl.AttributeProto.AttributeType type;
    private final boolean mandatory;

    public ONNXAttribute(String name, OnnxMl.AttributeProto.AttributeType type, boolean mandatory) {
        this.name = name;
        this.type = type;
        this.mandatory = mandatory;
    }

    public String getName() {
        return this.name;
    }

    public OnnxMl.AttributeProto.AttributeType getType() {
        return this.type;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public OnnxMl.AttributeProto build(Object value) {
        OnnxMl.AttributeProto.Builder builder = OnnxMl.AttributeProto.newBuilder();
        builder.setName(this.name);
        builder.setType(this.type);
        switch (this.type) {
            case FLOAT: {
                if (value instanceof Float) {
                    builder.setF(((Float)value).floatValue());
                    break;
                }
                throw new IllegalArgumentException("Expected Float, found " + value.getClass() + " with value " + value);
            }
            case INT: {
                if (value instanceof Integer) {
                    builder.setI(((Integer)value).intValue());
                    break;
                }
                throw new IllegalArgumentException("Expected Integer, found " + value.getClass() + " with value " + value);
            }
            case STRING: {
                if (value instanceof String) {
                    builder.setS(ByteString.copyFrom((String)((String)value), (Charset)StandardCharsets.UTF_8));
                    break;
                }
                throw new IllegalArgumentException("Expected String, found " + value.getClass() + " with value " + value);
            }
            case FLOATS: {
                if (value instanceof float[]) {
                    float[] arr = (float[])value;
                    for (int i = 0; i < arr.length; ++i) {
                        builder.addFloats(arr[i]);
                    }
                    break;
                }
                throw new IllegalArgumentException("Expected float[], found " + value.getClass() + " with value " + value);
            }
            case INTS: {
                if (value instanceof int[]) {
                    int[] arr = (int[])value;
                    for (int i = 0; i < arr.length; ++i) {
                        builder.addInts(arr[i]);
                    }
                    break;
                }
                throw new IllegalArgumentException("Expected int[], found " + value.getClass() + " with value " + value);
            }
            case STRINGS: {
                if (value instanceof String[]) {
                    String[] arr = (String[])value;
                    for (int i = 0; i < arr.length; ++i) {
                        builder.addStrings(ByteString.copyFrom((String)arr[i], (Charset)StandardCharsets.UTF_8));
                    }
                    break;
                }
                throw new IllegalArgumentException("Expected String[], found " + value.getClass() + " with value " + value);
            }
            case TENSOR: {
                if (value instanceof OnnxMl.TensorProto) {
                    builder.setT((OnnxMl.TensorProto)value);
                    break;
                }
                throw new IllegalArgumentException("Expected TensorProto, found " + value.getClass() + " with value " + value);
            }
            case GRAPH: 
            case SPARSE_TENSOR: 
            case TENSORS: 
            case GRAPHS: 
            case SPARSE_TENSORS: 
            case UNDEFINED: {
                throw new UnsupportedOperationException("Type: " + (Object)((Object)this.type) + " is not supported.");
            }
        }
        return builder.build();
    }

    public String toString() {
        return "ONNXAttribute(name='" + this.name + "',type=" + (Object)((Object)this.type) + ",mandatory=" + this.mandatory + ")";
    }
}

