/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410PrivateKey;
import org.bouncycastle.jcajce.interfaces.GOST3410PrivateKey;
import org.bouncycastle.jcajce.provider.GOST3410Util;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.jcajce.spec.GOST3410DomainParameterSpec;
import org.bouncycastle.jcajce.spec.GOST3410ParameterSpec;
import org.bouncycastle.jcajce.spec.GOST3410PrivateKeySpec;

class ProvGOST3410PrivateKey
implements Destroyable,
GOST3410PrivateKey,
ProvKey<AsymmetricGOST3410PrivateKey> {
    private static final long serialVersionUID = 8581661527592305464L;
    private transient AsymmetricGOST3410PrivateKey baseKey;

    ProvGOST3410PrivateKey(Algorithm algorithm, GOST3410PrivateKey gOST3410PrivateKey) {
        this.baseKey = new AsymmetricGOST3410PrivateKey(algorithm, GOST3410Util.convertToParams(gOST3410PrivateKey.getParams()), gOST3410PrivateKey.getX());
    }

    ProvGOST3410PrivateKey(Algorithm algorithm, GOST3410PrivateKeySpec gOST3410PrivateKeySpec) {
        this.baseKey = new AsymmetricGOST3410PrivateKey(algorithm, GOST3410Util.convertToParams(gOST3410PrivateKeySpec.getParams()), gOST3410PrivateKeySpec.getX());
    }

    ProvGOST3410PrivateKey(AsymmetricGOST3410PrivateKey asymmetricGOST3410PrivateKey) {
        this.baseKey = asymmetricGOST3410PrivateKey;
    }

    @Override
    public BigInteger getX() {
        return this.baseKey.getX();
    }

    @Override
    public GOST3410ParameterSpec<GOST3410DomainParameterSpec> getParams() {
        return GOST3410Util.convertToSpec(this.baseKey.getParameters());
    }

    @Override
    public AsymmetricGOST3410PrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        KeyUtil.checkDestroyed(this);
        return "GOST3410";
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvGOST3410PrivateKey)) {
            return false;
        }
        ProvGOST3410PrivateKey provGOST3410PrivateKey = (ProvGOST3410PrivateKey)object;
        return this.baseKey.equals(provGOST3410PrivateKey.baseKey);
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("GOST3410");
        }
        try {
            return KeyUtil.privateKeyToString("GOST3410", this.baseKey.getX(), this.baseKey.getParameters().getDomainParameters());
        }
        catch (Exception exception) {
            return KeyUtil.restrictedToString("GOST3410");
        }
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricGOST3410PrivateKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

