/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.time.Duration;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public final class JoinPhaser
extends Phaser {
    private AtomicInteger joinPhaseNumber = new AtomicInteger(-1);

    public JoinPhaser() {
        super(1);
    }

    public boolean join(Duration timeout) throws InterruptedException {
        int currentPhase;
        int lastArrivedPhase = this.joinPhaseNumber.get();
        if (lastArrivedPhase != (currentPhase = this.getPhase()) && this.joinPhaseNumber.compareAndSet(lastArrivedPhase, currentPhase)) {
            this.arrive();
        }
        try {
            this.awaitAdvanceInterruptibly(currentPhase, timeout.toNanos(), TimeUnit.NANOSECONDS);
            return true;
        }
        catch (TimeoutException timeoutException) {
            return false;
        }
    }
}

