/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ldap;

import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

public class ConnectionUtil {
    public static InitialLdapContext getDefaultDirCtx(String string, String string2, String string3, String string4) throws NamingException {
        long l = 10000L;
        Hashtable hashtable = ConnectionUtil.a(string, string2, string3, string4);
        hashtable.put("java.naming.ldap.attributes.binary", "userpkcs12");
        ConnectThread connectThread = new ConnectThread(hashtable, null);
        connectThread.start();
        try {
            connectThread.join(l);
        }
        catch (InterruptedException interruptedException) {
            throw new CommunicationException("Thread InterruptedException encountered - enable to create JNDI connection");
        }
        InitialLdapContext initialLdapContext = connectThread.a();
        if (connectThread.isAlive() && initialLdapContext == null) {
            connectThread.interrupt();
            throw new CommunicationException("returnInitialLdapContext() times out after " + l + " ms - JNDI initialization method not returning");
        }
        if (initialLdapContext == null) {
            NamingException namingException = connectThread.b();
            namingException.fillInStackTrace();
            throw namingException;
        }
        return initialLdapContext;
    }

    public static InitialLdapContext getSSLDirCtx(String string, String string2, String string3, String string4) throws NamingException {
        Hashtable hashtable = ConnectionUtil.a(string, string2, string3, string4);
        hashtable.put("java.naming.ldap.attributes.binary", "userpkcs12");
        hashtable.put("java.naming.ldap.factory.socket", "oracle.security.pki.ldap.LdapSSLSocketFactory");
        hashtable.put("java.naming.security.protocol", "ssl");
        String string5 = Security.getProperty("jdk.tls.disabledAlgorithms");
        string5 = string5.replace("anon,", "");
        string5 = string5.replace("3DES_EDE_CBC,", "");
        Security.setProperty("jdk.tls.disabledAlgorithms", string5);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
        int n = 0;
        while (true) {
            ++n;
            try {
                return new InitialLdapContext(hashtable, null);
            }
            catch (NamingException namingException) {
                Throwable throwable;
                if (((throwable = namingException.getRootCause()) instanceof SSLHandshakeException || throwable instanceof SSLException) && n <= 2) continue;
                throw namingException;
            }
            break;
        }
    }

    private static Hashtable a(String string, String string2, String string3, String string4) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration<Object> enumeration = System.getProperties().keys();
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            if (!string5.startsWith("java.naming.") || System.getProperty(string5).equals("com.evermind.server.ApplicationInitialContextFactory")) continue;
            hashtable.put(string5, System.getProperty(string5));
        }
        if (hashtable.get("java.naming.factory.initial") == null) {
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        hashtable.put("java.naming.provider.url", "ldap://" + string + ":" + string2 + "/");
        hashtable.put("java.naming.security.authentication", "simple");
        hashtable.put("java.naming.security.principal", string3);
        hashtable.put("java.naming.security.credentials", string4);
        hashtable.put("java.naming.referral", "follow");
        return hashtable;
    }

    static class ConnectThread
    extends Thread {
        Hashtable a = null;
        Control[] b = null;
        InitialLdapContext c = null;
        NamingException d = null;

        ConnectThread(Hashtable hashtable, Control[] controlArray) {
            this.a = hashtable;
            this.b = controlArray;
        }

        @Override
        public void run() {
            try {
                this.c = new InitialLdapContext(this.a, null);
            }
            catch (NamingException namingException) {
                this.d = namingException;
            }
        }

        synchronized InitialLdapContext a() {
            return this.c;
        }

        NamingException b() {
            return this.d;
        }
    }
}

