/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.spi;

import jakarta.persistence.NamedNativeQuery;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.internal.util.collections.CollectionHelper;

public record NamedNativeQueryRegistration(String name, NamedNativeQuery configuration) {
    public String getQueryString() {
        return this.configuration.query();
    }

    public Class<?> getResultClass() {
        return this.configuration.resultClass();
    }

    public String getResultSetMapping() {
        return this.configuration.resultSetMapping();
    }

    public Map<String, String> getQueryHints() {
        Object[] hints = this.configuration.hints();
        if (CollectionHelper.isEmpty(hints)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = CollectionHelper.linkedMapOfSize(hints.length);
        for (Object hint : hints) {
            result.put(hint.name(), hint.value());
        }
        return result;
    }
}

