/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.internal.models;

import io.smallrye.openapi.model.BaseExtensibleModel;
import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.servers.Server;

public class Operation
extends BaseExtensibleModel<org.eclipse.microprofile.openapi.models.Operation>
implements org.eclipse.microprofile.openapi.models.Operation {
    public static final PropertyMetadata PROPERTIES = new Properties();

    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }

    protected org.eclipse.microprofile.openapi.models.Operation filter(OASFilter filter) {
        return filter.filterOperation((org.eclipse.microprofile.openapi.models.Operation)this);
    }

    public List<String> getTags() {
        return this.getListProperty("tags");
    }

    public void setTags(List<String> newValue) {
        this.setListProperty("tags", newValue);
    }

    public Operation addTag(String newValue) {
        this.addListPropertyEntry("tags", newValue);
        return this;
    }

    public void removeTag(String value) {
        this.removeListPropertyEntry("tags", value);
    }

    public String getOperationId() {
        return (String)this.getProperty("operationId", String.class);
    }

    public void setOperationId(String newValue) {
        this.setProperty("operationId", newValue);
    }

    public List<Parameter> getParameters() {
        return this.getListProperty("parameters");
    }

    public void setParameters(List<Parameter> newValue) {
        this.setListProperty("parameters", newValue);
    }

    public Operation addParameter(Parameter newValue) {
        this.addListPropertyEntry("parameters", newValue);
        return this;
    }

    public void removeParameter(Parameter value) {
        this.removeListPropertyEntry("parameters", value);
    }

    public RequestBody getRequestBody() {
        return (RequestBody)this.getProperty("requestBody", RequestBody.class);
    }

    public void setRequestBody(RequestBody newValue) {
        this.setProperty("requestBody", newValue);
    }

    public APIResponses getResponses() {
        return (APIResponses)this.getProperty("responses", APIResponses.class);
    }

    public void setResponses(APIResponses newValue) {
        this.setProperty("responses", newValue);
    }

    public Map<String, Callback> getCallbacks() {
        return this.getMapProperty("callbacks");
    }

    public void setCallbacks(Map<String, Callback> newValue) {
        this.setMapProperty("callbacks", newValue);
    }

    public Operation addCallback(String newKey, Callback newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("callbacks", newKey, newValue);
        return this;
    }

    public void removeCallback(String key) {
        this.removeMapPropertyEntry("callbacks", key);
    }

    public Boolean getDeprecated() {
        return (Boolean)this.getProperty("deprecated", Boolean.class);
    }

    public void setDeprecated(Boolean newValue) {
        this.setProperty("deprecated", newValue);
    }

    public List<Server> getServers() {
        return this.getListProperty("servers");
    }

    public void setServers(List<Server> newValue) {
        this.setListProperty("servers", newValue);
    }

    public Operation addServer(Server newValue) {
        this.addListPropertyEntry("servers", newValue);
        return this;
    }

    public void removeServer(Server value) {
        this.removeListPropertyEntry("servers", value);
    }

    public List<SecurityRequirement> getSecurity() {
        return this.getListProperty("security");
    }

    public void setSecurity(List<SecurityRequirement> newValue) {
        this.setListProperty("security", newValue);
    }

    public Operation addSecurityRequirement(SecurityRequirement newValue) {
        this.addListPropertyEntry("security", newValue);
        return this;
    }

    public void removeSecurityRequirement(SecurityRequirement value) {
        this.removeListPropertyEntry("security", value);
    }

    public static class Properties
    implements PropertyMetadata {
        private final Map<String, DataType> types = new HashMap<String, DataType>(12);
        private final Map<String, OpenApiVersion> minVersions = new HashMap<String, OpenApiVersion>(12);

        public Properties() {
            this.types.put("tags", DataType.listOf((DataType)DataType.type(String.class)));
            this.minVersions.put("tags", OpenApiVersion.V3_0);
            this.types.put("summary", DataType.type(String.class));
            this.minVersions.put("summary", OpenApiVersion.V3_0);
            this.types.put("description", DataType.type(String.class));
            this.minVersions.put("description", OpenApiVersion.V3_0);
            this.types.put("externalDocs", DataType.type(ExternalDocumentation.class));
            this.minVersions.put("externalDocs", OpenApiVersion.V3_0);
            this.types.put("operationId", DataType.type(String.class));
            this.minVersions.put("operationId", OpenApiVersion.V3_0);
            this.types.put("parameters", DataType.listOf((DataType)DataType.type(Parameter.class)));
            this.minVersions.put("parameters", OpenApiVersion.V3_0);
            this.types.put("requestBody", DataType.type(RequestBody.class));
            this.minVersions.put("requestBody", OpenApiVersion.V3_0);
            this.types.put("responses", DataType.type(APIResponses.class));
            this.minVersions.put("responses", OpenApiVersion.V3_0);
            this.types.put("callbacks", DataType.mapOf((DataType)DataType.type(Callback.class)));
            this.minVersions.put("callbacks", OpenApiVersion.V3_0);
            this.types.put("deprecated", DataType.type(Boolean.class));
            this.minVersions.put("deprecated", OpenApiVersion.V3_0);
            this.types.put("servers", DataType.listOf((DataType)DataType.type(Server.class)));
            this.minVersions.put("servers", OpenApiVersion.V3_0);
            this.types.put("security", DataType.listOf((DataType)DataType.type(SecurityRequirement.class)));
            this.minVersions.put("security", OpenApiVersion.V3_0);
        }

        public DataType getPropertyType(String name) {
            if (this.types.containsKey(name)) {
                return this.types.get(name);
            }
            return DataType.type(Object.class);
        }

        public OpenApiVersion getMinVersion(String name) {
            return this.minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}

