/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaGenericsUtil {
    public static boolean isReifiableType(PsiType type2) {
        if (type2 instanceof PsiArrayType) {
            return JavaGenericsUtil.isReifiableType(((PsiArrayType)type2).getComponentType());
        }
        if (type2 instanceof PsiPrimitiveType) {
            return true;
        }
        if (PsiUtil.resolveClassInType(type2) instanceof PsiTypeParameter) {
            return false;
        }
        if (type2 instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)PsiUtil.convertAnonymousToBaseType(type2);
            if (classType.isRaw()) {
                return true;
            }
            PsiType[] parameters = classType.getParameters();
            if (parameters.length > 0) {
                for (PsiType parameter : parameters) {
                    if (parameter instanceof PsiWildcardType && ((PsiWildcardType)parameter).getBound() == null) continue;
                    return false;
                }
                return true;
            }
            PsiClassType.ClassResolveResult resolved = classType.resolveGenerics();
            PsiClass aClass = resolved.getElement();
            if (aClass instanceof PsiTypeParameter) {
                return false;
            }
            if (aClass != null && !aClass.hasModifierProperty("static")) {
                PsiClass stopClassLevel = PsiUtil.isLocalClass(aClass) ? null : aClass.getContainingClass();
                PsiModifierListOwner enclosingStaticElement = PsiUtil.getEnclosingStaticElement(aClass, stopClassLevel);
                PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, true);
                if (containingClass != null && (enclosingStaticElement == null || PsiTreeUtil.isAncestor(enclosingStaticElement, containingClass, false))) {
                    while (containingClass instanceof PsiAnonymousClass) {
                        containingClass = PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class, true);
                    }
                    if (containingClass == null || enclosingStaticElement != null && !PsiTreeUtil.isAncestor(enclosingStaticElement, containingClass, false)) {
                        return true;
                    }
                    return JavaGenericsUtil.isReifiableType(JavaPsiFacade.getElementFactory(aClass.getProject()).createType(containingClass, resolved.getSubstitutor()));
                }
            }
            return true;
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            return JavaGenericsUtil.isReifiableType(((PsiCapturedWildcardType)type2).getUpperBound());
        }
        return false;
    }

    public static boolean isUncheckedCast(@NotNull PsiType castType, @NotNull PsiType operandType) {
        if (castType == null) {
            JavaGenericsUtil.$$$reportNull$$$0(3);
        }
        if (operandType == null) {
            JavaGenericsUtil.$$$reportNull$$$0(4);
        }
        if (TypeConversionUtil.isAssignable(castType, operandType, false)) {
            return false;
        }
        if ((castType = castType.getDeepComponentType()) instanceof PsiClassType) {
            PsiClassType castClassType = (PsiClassType)castType;
            if ((operandType = operandType.getDeepComponentType()) instanceof PsiCapturedWildcardType) {
                operandType = ((PsiCapturedWildcardType)operandType).getUpperBound();
            }
            if (!(operandType instanceof PsiClassType)) {
                return false;
            }
            PsiClassType operandClassType = (PsiClassType)operandType;
            PsiClassType.ClassResolveResult castResult = castClassType.resolveGenerics();
            PsiClassType.ClassResolveResult operandResult = operandClassType.resolveGenerics();
            PsiClass operandClass = operandResult.getElement();
            PsiClass castClass = castResult.getElement();
            if (operandClass == null || castClass == null) {
                return false;
            }
            if (castClass instanceof PsiTypeParameter) {
                return true;
            }
            if (castClassType.hasNonTrivialParameters()) {
                if (operandClassType.isRaw()) {
                    return true;
                }
                if (castClass.isInheritor(operandClass, true)) {
                    PsiSubstitutor castSubstitutor = castResult.getSubstitutor();
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory(castClass.getProject());
                    for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(castClass)) {
                        PsiSubstitutor modifiedSubstitutor = castSubstitutor.put(typeParameter, null);
                        PsiClassType otherType = factory.createType(castClass, modifiedSubstitutor);
                        if (!TypeConversionUtil.isAssignable(operandType, otherType, false)) continue;
                        return true;
                    }
                    PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(operandClass, castClass, castResult.getSubstitutor());
                    PsiSubstitutor operandSubstitutor = operandResult.getSubstitutor();
                    PsiClass superClass = operandResult.getElement();
                    if (superClass == null) {
                        return true;
                    }
                    HashSet<PsiTypeParameter> capturedWildcardType = new HashSet<PsiTypeParameter>();
                    for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(operandClass)) {
                        PsiType operandParameterType = operandSubstitutor.substitute(parameter);
                        if (operandParameterType instanceof PsiCapturedWildcardType) {
                            capturedWildcardType.add(parameter);
                        }
                        PsiType superParameterType = superSubstitutor.substitute(parameter);
                        if (operandParameterType == null || superParameterType == null || TypeConversionUtil.typesAgree(superParameterType, operandParameterType, false)) continue;
                        return true;
                    }
                    return !JavaGenericsUtil.capturedWildcardTypesAreNotMerged(capturedWildcardType, operandClass, castClass);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean capturedWildcardTypesAreNotMerged(Set<PsiTypeParameter> capturedSuperClassTypes, PsiClass superClass, PsiClass derivedClass) {
        if (capturedSuperClassTypes.isEmpty()) {
            return true;
        }
        PsiSubstitutor substitutor2 = TypeConversionUtil.getSuperClassSubstitutor(superClass, derivedClass, PsiSubstitutor.EMPTY);
        if (substitutor2 == PsiSubstitutor.EMPTY) {
            return true;
        }
        HashSet<String> capturedSourceTypeParameters = new HashSet<String>();
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(superClass)) {
            PsiClass resolved;
            PsiType substituted;
            if (!capturedSuperClassTypes.contains(parameter) || !((substituted = substitutor2.substitute(parameter)) instanceof PsiClassType) || !((resolved = ((PsiClassType)substituted).resolve()) instanceof PsiTypeParameter)) continue;
            PsiTypeParameter typeParameter = (PsiTypeParameter)resolved;
            if (capturedSourceTypeParameters.contains(typeParameter.getName())) {
                return false;
            }
            capturedSourceTypeParameters.add(typeParameter.getName());
        }
        return true;
    }

    public static boolean isRawToGeneric(PsiType lType, PsiType rType) {
        if (lType instanceof PsiPrimitiveType || rType instanceof PsiPrimitiveType) {
            return false;
        }
        if (lType.equals(rType)) {
            return false;
        }
        if (lType instanceof PsiArrayType && rType instanceof PsiArrayType) {
            return JavaGenericsUtil.isRawToGeneric(((PsiArrayType)lType).getComponentType(), ((PsiArrayType)rType).getComponentType());
        }
        if (lType instanceof PsiArrayType || rType instanceof PsiArrayType) {
            return false;
        }
        if (rType instanceof PsiIntersectionType) {
            for (PsiType type2 : ((PsiIntersectionType)rType).getConjuncts()) {
                if (!JavaGenericsUtil.isRawToGeneric(lType, type2)) continue;
                return true;
            }
            return false;
        }
        if (lType instanceof PsiIntersectionType) {
            for (PsiType type3 : ((PsiIntersectionType)lType).getConjuncts()) {
                if (!JavaGenericsUtil.isRawToGeneric(type3, rType)) continue;
                return true;
            }
            return false;
        }
        if (rType instanceof PsiCapturedWildcardType) {
            return JavaGenericsUtil.isRawToGeneric(lType, ((PsiCapturedWildcardType)rType).getUpperBound());
        }
        if (!(lType instanceof PsiClassType) || !(rType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType.ClassResolveResult lResolveResult = ((PsiClassType)lType).resolveGenerics();
        PsiClassType.ClassResolveResult rResolveResult = ((PsiClassType)rType).resolveGenerics();
        PsiClass lClass = lResolveResult.getElement();
        PsiClass rClass = rResolveResult.getElement();
        if (rClass instanceof PsiAnonymousClass) {
            return JavaGenericsUtil.isRawToGeneric(lType, ((PsiAnonymousClass)rClass).getBaseClassType());
        }
        PsiSubstitutor lSubstitutor = lResolveResult.getSubstitutor();
        PsiSubstitutor rSubstitutor = rResolveResult.getSubstitutor();
        if (lClass == null || rClass == null) {
            return false;
        }
        if (lClass instanceof PsiTypeParameter && !InheritanceUtil.isInheritorOrSelf(rClass, lClass, true)) {
            return true;
        }
        if (!lClass.getManager().areElementsEquivalent(lClass, rClass)) {
            if (lClass.isInheritor(rClass, true)) {
                lSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(rClass, lClass, lSubstitutor);
                lClass = rClass;
            } else if (rClass.isInheritor(lClass, true)) {
                rSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(lClass, rClass, rSubstitutor);
                rClass = lClass;
            } else {
                return false;
            }
        }
        Iterator<PsiTypeParameter> lIterator = PsiUtil.typeParametersIterator(lClass);
        Iterator<PsiTypeParameter> rIterator = PsiUtil.typeParametersIterator(rClass);
        while (lIterator.hasNext()) {
            if (!rIterator.hasNext()) {
                return false;
            }
            PsiTypeParameter lParameter = lIterator.next();
            PsiTypeParameter rParameter = rIterator.next();
            PsiType lTypeArg = lSubstitutor.substitute(lParameter);
            PsiType rTypeArg = rSubstitutor.substituteWithBoundsPromotion(rParameter);
            if (lTypeArg == null) continue;
            if (rTypeArg == null) {
                if (lTypeArg instanceof PsiWildcardType && ((PsiWildcardType)lTypeArg).getBound() == null) continue;
                return true;
            }
            if (TypeConversionUtil.typesAgree(lTypeArg, rTypeArg, true)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiType getCollectionItemType(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            JavaGenericsUtil.$$$reportNull$$$0(5);
        }
        return JavaGenericsUtil.getCollectionItemType(expression2.getType(), expression2.getResolveScope());
    }

    @Nullable
    public static PsiType getCollectionItemType(@Nullable PsiType type2, @NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            JavaGenericsUtil.$$$reportNull$$$0(6);
        }
        if (type2 instanceof PsiArrayType) {
            return ((PsiArrayType)type2).getComponentType();
        }
        if (type2 instanceof PsiClassType) {
            PsiTypeParameter typeParameter;
            PsiClass myClass;
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type2).resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass == null) {
                return null;
            }
            PsiManager manager = aClass.getManager();
            String qName = aClass.getQualifiedName();
            PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
            JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
            if (qName != null && (myClass = facade.findClass(qName, scope2)) != null && myClass != aClass) {
                PsiTypeParameter thisTypeParameter = JavaGenericsUtil.getIterableTypeParameter(facade, myClass);
                if (thisTypeParameter == null) {
                    return null;
                }
                PsiTypeParameter thatTypeParameter = JavaGenericsUtil.getIterableTypeParameter(facade, aClass);
                if (thatTypeParameter != null) {
                    substitutor2 = substitutor2.put(thisTypeParameter, substitutor2.substitute(thatTypeParameter));
                }
                aClass = myClass;
            }
            if ((typeParameter = JavaGenericsUtil.getIterableTypeParameter(facade, aClass)) == null) {
                return null;
            }
            PsiClass owner = (PsiClass)typeParameter.getOwner();
            if (owner == null) {
                return null;
            }
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor(owner, aClass, substitutor2);
            if (superClassSubstitutor == null) {
                return null;
            }
            PsiType itemType = superClassSubstitutor.substitute(typeParameter);
            return itemType == null ? PsiType.getJavaLangObject(manager, aClass.getResolveScope()) : itemType;
        }
        if (type2 instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type2).getConjuncts()) {
                PsiType itemType = JavaGenericsUtil.getCollectionItemType(conjunct, scope2);
                if (itemType == null) continue;
                return itemType;
            }
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            return JavaGenericsUtil.getCollectionItemType(((PsiCapturedWildcardType)type2).getUpperBound(), scope2);
        }
        return null;
    }

    @Nullable
    private static PsiTypeParameter getIterableTypeParameter(JavaPsiFacade facade, PsiClass context) {
        PsiClass iterable = facade.findClass("java.lang.Iterable", context.getResolveScope());
        if (iterable == null) {
            return null;
        }
        PsiTypeParameter[] typeParameters2 = iterable.getTypeParameters();
        if (typeParameters2.length != 1) {
            return null;
        }
        return typeParameters2[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/JavaGenericsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isUncheckedWarning";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isUncheckedCast";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getCollectionItemType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

