/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.move.processor;

import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.permissions.KaAnalysisPermissionRegistry;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2ChangePackageDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.processor.MoveConflictUtilKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.processor.MoveUsageUtilKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.processor.MoveUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u001d\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bH\u0014\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0013H\u0014J\u001d\u0010\u0014\u001a\u00020\u00152\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bH\u0014\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/processor/K2ChangePackageRefactoringProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "descriptor", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2ChangePackageDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2ChangePackageDescriptor;)V", "getCommandName", "", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "preprocessUsages", "", "refUsages", "Lcom/intellij/openapi/util/Ref;", "performRefactoring", "", "([Lcom/intellij/usageView/UsageInfo;)V", "getBeforeData", "Lcom/intellij/refactoring/listeners/RefactoringEventData;", "kotlin.refactorings.move.k2"})
@SourceDebugExtension(value={"SMAP\nK2ChangePackageRefactoringProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2ChangePackageRefactoringProcessor.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/processor/K2ChangePackageRefactoringProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 permissions.kt\norg/jetbrains/kotlin/analysis/api/permissions/PermissionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,59:1\n1374#2:60\n1460#2,5:61\n1869#2,2:72\n1285#2,2:74\n1299#2,4:76\n1869#2,2:80\n1285#2,2:85\n1299#2,4:87\n1869#2,2:91\n37#3:66\n36#3,3:67\n41#4,2:70\n44#4,3:82\n48#4:93\n4135#5,11:94\n*S KotlinDebug\n*F\n+ 1 K2ChangePackageRefactoringProcessor.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/processor/K2ChangePackageRefactoringProcessor\n*L\n27#1:60\n27#1:61,5\n50#1:72,2\n51#1:74,2\n51#1:76,4\n52#1:80,2\n51#1:85,2\n51#1:87,4\n52#1:91,2\n29#1:66\n29#1:67,3\n48#1:70,2\n48#1:82,3\n48#1:93\n41#1:94,11\n*E\n"})
public final class K2ChangePackageRefactoringProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final K2ChangePackageDescriptor descriptor;

    public K2ChangePackageRefactoringProcessor(@NotNull K2ChangePackageDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        super(descriptor2.getProject());
        this.descriptor = descriptor2;
    }

    @NotNull
    protected String getCommandName() {
        Object[] objectArray = new Object[]{MoveUtilKt.presentablePkgName(this.descriptor.getTarget())};
        return KotlinBundle.message((String)"text.change.file.package.to.0", (Object[])objectArray);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages2) {
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        return (UsageViewDescriptor)MoveUtilKt.usageViewDescriptor(this.descriptor);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected UsageInfo[] findUsages() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.descriptor.getFiles();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = MoveUsageUtilKt.findUsages(it, this.descriptor.getSearchInComments(), this.descriptor.getSearchForText(), this.descriptor.getTarget());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new UsageInfo[0]);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        Intrinsics.checkNotNullParameter(refUsages, (String)"refUsages");
        UsageInfo[] usages2 = (UsageInfo[])refUsages.get();
        Project project = this.descriptor.getProject();
        String string = RefactoringBundle.message((String)"detecting.possible.conflicts");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        MultiMap conflicts = (MultiMap)ActionUtil.underModalProgress((Project)project, (String)string, () -> K2ChangePackageRefactoringProcessor.preprocessUsages$lambda$1(this, usages2));
        return this.showConflicts(conflicts, usages2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages2) {
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        boolean $i$f$allowAnalysisOnEdt = false;
        KaAnalysisPermissionRegistry permissionRegistry$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
        if (permissionRegistry$iv.isAnalysisAllowedOnEdt()) {
            boolean bl = false;
            Set<KtFile> files = this.descriptor.getFiles();
            Iterable $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtFile it = (KtFile)element$iv;
                boolean bl2 = false;
                MoveUtilKt.updatePackageDirective(it, this.descriptor.getTarget());
            }
            Iterable $this$associateWith$iv = files;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                KtFile ktFile2 = (KtFile)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl3 = false;
                void var18_45 = it;
                map2.put(t, var18_45);
            }
            Map oldToNewMap = MapsKt.toMutableMap((Map)result$iv);
            Iterable $this$forEach$iv2 = files;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                KtFile file = (KtFile)element$iv;
                boolean bl4 = false;
                Iterable $this$forEach$iv3 = MoveUsageUtilKt.getAllDeclarationsToUpdate((KtDeclarationContainer)file);
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    KtNamedDeclaration decl = (KtNamedDeclaration)element$iv2;
                    boolean bl5 = false;
                    oldToNewMap.put(decl, decl);
                }
            }
            MoveUsageUtilKt.retargetUsagesAfterMove(ArraysKt.toList((Object[])usages2), oldToNewMap);
        } else {
            permissionRegistry$iv.setAnalysisAllowedOnEdt(true);
            try {
                boolean bl = false;
                Set<KtFile> files = this.descriptor.getFiles();
                Iterable $this$forEach$iv = files;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtFile it = (KtFile)element$iv;
                    boolean bl6 = false;
                    MoveUtilKt.updatePackageDirective(it, this.descriptor.getTarget());
                }
                Iterable $this$associateWith$iv = files;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    void it;
                    KtFile $i$f$forEach3 = (KtFile)element$iv$iv;
                    Object t = element$iv$iv;
                    Map map3 = result$iv;
                    boolean bl7 = false;
                    void var18_46 = it;
                    map3.put(t, var18_46);
                }
                Map oldToNewMap = MapsKt.toMutableMap((Map)result$iv);
                Iterable $this$forEach$iv4 = files;
                boolean $i$f$forEach4 = false;
                for (Object element$iv : $this$forEach$iv4) {
                    KtFile file = (KtFile)element$iv;
                    boolean bl8 = false;
                    Iterable $this$forEach$iv5 = MoveUsageUtilKt.getAllDeclarationsToUpdate((KtDeclarationContainer)file);
                    boolean $i$f$forEach5 = false;
                    for (Object element$iv3 : $this$forEach$iv5) {
                        KtNamedDeclaration decl = (KtNamedDeclaration)element$iv3;
                        boolean bl9 = false;
                        oldToNewMap.put(decl, decl);
                    }
                }
                MoveUsageUtilKt.retargetUsagesAfterMove(ArraysKt.toList((Object[])usages2), oldToNewMap);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                permissionRegistry$iv.setAnalysisAllowedOnEdt(false);
            }
        }
    }

    @NotNull
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData refactoringEventData;
        RefactoringEventData $this$getBeforeData_u24lambda_u247 = refactoringEventData = new RefactoringEventData();
        boolean bl = false;
        $this$getBeforeData_u24lambda_u247.addElements((Collection)this.descriptor.getFiles());
        return refactoringEventData;
    }

    /*
     * WARNING - void declaration
     */
    private static final MultiMap preprocessUsages$lambda$1(K2ChangePackageRefactoringProcessor this$0, UsageInfo[] $usages) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Iterable iterable = this$0.descriptor.getFiles();
        FqName fqName2 = this$0.descriptor.getTarget();
        Intrinsics.checkNotNull((Object)$usages);
        UsageInfo[] usageInfoArray = $usages;
        FqName fqName3 = fqName2;
        Iterable iterable2 = iterable;
        boolean $i$f$filterIsInstance = false;
        void var4_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MoveRenameUsageInfo)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return MoveConflictUtilKt.findAllMoveConflicts(iterable2, fqName3, list2);
    }
}

