/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutineDebuggerMode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011H\u0002J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector;", "", "<init>", "()V", "KOTLIN_STDLIB", "", "KOTLINX_COROUTINES_DEBUG_INTERNAL_PACKAGE", "MINIMAL_SUPPORTED_COROUTINES_VERSION", "Lorg/apache/maven/artifact/versioning/DefaultArtifactVersion;", "KOTLINX_COROUTINES_CORE", "KOTLINX_COROUTINES_CORE_JVM_JAR_REGEX", "Lkotlin/text/Regex;", "attachCoroutineAgent", "", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "findKotlinxCoroutinesCoreJar", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector$KotlinxCoroutinesSearchResult;", "getKotlinxCoroutinesJarsFromClasspath", "", "determineCoreVersionMode", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;", "version", "initializeCoroutineAgent", "jarPath", "KotlinxCoroutinesSearchResult", "kotlin.jvm-debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\nCoroutineAgentConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineAgentConnector.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1463#2,14:111\n10135#3:125\n10557#3,2:126\n11546#3,9:128\n13472#3:137\n13473#3:139\n11555#3:140\n10559#3,3:141\n11546#3,9:144\n13472#3:153\n13473#3:155\n11555#3:156\n1#4:138\n1#4:154\n774#5:157\n865#5,2:158\n1869#5,2:160\n*S KotlinDebug\n*F\n+ 1 CoroutineAgentConnector.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector\n*L\n40#1:111,14\n62#1:125\n62#1:126,2\n69#1:128,9\n69#1:137\n69#1:139\n69#1:140\n62#1:141,3\n75#1:144,9\n75#1:153\n75#1:155\n75#1:156\n69#1:138\n75#1:154\n93#1:157\n93#1:158,2\n93#1:160,2\n*E\n"})
public final class CoroutineAgentConnector {
    @NotNull
    public static final CoroutineAgentConnector INSTANCE = new CoroutineAgentConnector();
    @NotNull
    private static final String KOTLIN_STDLIB = "kotlin-stdlib";
    @NotNull
    private static final String KOTLINX_COROUTINES_DEBUG_INTERNAL_PACKAGE = "kotlinx.coroutines.debug.internal";
    @NotNull
    private static final DefaultArtifactVersion MINIMAL_SUPPORTED_COROUTINES_VERSION = new DefaultArtifactVersion("1.3.7-255");
    @NotNull
    private static final String KOTLINX_COROUTINES_CORE = "kotlinx-coroutines-core";
    @NotNull
    private static final Regex KOTLINX_COROUTINES_CORE_JVM_JAR_REGEX = new Regex(".+\\Wkotlinx-coroutines-core(-jvm)?-(\\d[\\w.\\-]+)?\\.jar");

    private CoroutineAgentConnector() {
    }

    public final boolean attachCoroutineAgent(@NotNull Project project, @Nullable RunConfigurationBase<?> configuration2, @NotNull JavaParameters params) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        KotlinxCoroutinesSearchResult searchResult = this.findKotlinxCoroutinesCoreJar(project, configuration2);
        if (searchResult.getDebuggerMode() == CoroutineDebuggerMode.VERSION_1_3_8_AND_UP && searchResult.getJarPath() != null) {
            return this.initializeCoroutineAgent(params, searchResult.getJarPath());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinxCoroutinesSearchResult findKotlinxCoroutinesCoreJar(Project project, RunConfigurationBase<?> configuration2) {
        Object v0;
        void $this$maxByOrNull$iv;
        List<String> jarPaths = this.getKotlinxCoroutinesJarsFromClasspath(project, configuration2);
        Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)jarPaths), CoroutineAgentConnector::findKotlinxCoroutinesCoreJar$lambda$0);
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                MatchResult it = (MatchResult)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = (Comparable)new DefaultArtifactVersion((String)it.getGroupValues().get(2));
                do {
                    Object e$iv = iterator$iv.next();
                    MatchResult it2 = (MatchResult)e$iv;
                    $i$a$-maxByOrNull-CoroutineAgentConnector$findKotlinxCoroutinesCoreJar$newestKotlinxCoroutinesJar$2 = false;
                    Comparable v$iv = (Comparable)new DefaultArtifactVersion((String)it2.getGroupValues().get(2));
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        MatchResult newestKotlinxCoroutinesJar = v0;
        if (newestKotlinxCoroutinesJar == null || newestKotlinxCoroutinesJar.getGroupValues().size() < 3) {
            return new KotlinxCoroutinesSearchResult(null, CoroutineDebuggerMode.DISABLED);
        }
        return new KotlinxCoroutinesSearchResult(newestKotlinxCoroutinesJar.getValue(), this.determineCoreVersionMode((String)newestKotlinxCoroutinesJar.getGroupValues().get(2)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getKotlinxCoroutinesJarsFromClasspath(Project project, RunConfigurationBase<?> configuration2) {
        List list2;
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)project).findPackage(KOTLINX_COROUTINES_DEBUG_INTERNAL_PACKAGE);
        if (psiPackage == null) {
            return CollectionsKt.emptyList();
        }
        PsiPackage coroutinesPsiPackage = psiPackage;
        if (configuration2 != null && configuration2 instanceof ModuleBasedConfiguration) {
            void $this$flatMapTo$iv$iv;
            Module[] moduleArray = ((ModuleBasedConfiguration)configuration2).getModules();
            Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"getModules(...)");
            Object[] $this$flatMap$iv = moduleArray;
            boolean $i$f$flatMap = false;
            Object[] objectArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapNotNullTo$iv$iv;
                GlobalSearchScope moduleScope;
                Module module = (Module)element$iv$iv;
                boolean bl = false;
                Object[] objectArray2 = new GlobalSearchScope[]{GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module), module.getModuleRuntimeScope(true)};
                Intrinsics.checkNotNullExpressionValue((Object)GlobalSearchScope.union((Collection)CollectionsKt.listOf((Object[])objectArray2)), (String)"union(...)");
                PsiDirectory[] psiDirectoryArray = coroutinesPsiPackage.getDirectories(moduleScope);
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getDirectories(...)");
                Object[] $this$mapNotNull$iv = psiDirectoryArray;
                boolean $i$f$mapNotNull = false;
                Object[] objectArray3 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int j = 0; j < n; ++j) {
                    String it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv2 = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                    boolean bl2 = false;
                    PsiDirectory it = (PsiDirectory)element$iv$iv2;
                    boolean bl3 = false;
                    VirtualFile virtualFile = JarFileSystem.getInstance().getVirtualFileForJar(it.getVirtualFile());
                    if ((virtualFile != null ? virtualFile.getPath() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            PsiDirectory[] psiDirectoryArray = coroutinesPsiPackage.getDirectories();
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getDirectories(...)");
            Object[] $this$flatMap$iv = psiDirectoryArray;
            boolean $i$f$mapNotNull = false;
            void $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                String it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                PsiDirectory it = (PsiDirectory)element$iv$iv;
                boolean bl5 = false;
                VirtualFile virtualFile = JarFileSystem.getInstance().getVirtualFileForJar(it.getVirtualFile());
                if ((virtualFile != null ? virtualFile.getPath() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    private final CoroutineDebuggerMode determineCoreVersionMode(String version) {
        return new DefaultArtifactVersion(version).compareTo((ArtifactVersion)MINIMAL_SUPPORTED_COROUTINES_VERSION) > 0 ? CoroutineDebuggerMode.VERSION_1_3_8_AND_UP : CoroutineDebuggerMode.DISABLED;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean initializeCoroutineAgent(JavaParameters params, String jarPath) {
        ParametersList parametersList = params.getVMParametersList();
        if (parametersList == null) {
            return false;
        }
        ParametersList vmParametersList = parametersList;
        vmParametersList.add("-javaagent:" + jarPath);
        if (params.isClasspathFile()) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            List list2 = params.getClassPath().getRootDirs();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getRootDirs(...)");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)KOTLIN_STDLIB, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                VirtualFileSystem fs;
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getFileSystem(), (String)"getFileSystem(...)");
                if (fs instanceof ArchiveFileSystem) {
                    VirtualFile virtualFile = ((ArchiveFileSystem)fs).getLocalByEntry(it);
                    string = virtualFile != null ? virtualFile.getPath() : null;
                } else {
                    string = it.getPath();
                }
                String path2 = string;
                it.putUserData(JdkUtil.AGENT_RUNTIME_CLASSPATH, (Object)path2);
            }
        }
        return true;
    }

    private static final MatchResult findKotlinxCoroutinesCoreJar$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return KOTLINX_COROUTINES_CORE_JVM_JAR_REGEX.matchEntire((CharSequence)it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector$KotlinxCoroutinesSearchResult;", "", "jarPath", "", "debuggerMode", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;)V", "getJarPath", "()Ljava/lang/String;", "getDebuggerMode", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.jvm-debugger.coroutines"})
    private static final class KotlinxCoroutinesSearchResult {
        @Nullable
        private final String jarPath;
        @NotNull
        private final CoroutineDebuggerMode debuggerMode;

        public KotlinxCoroutinesSearchResult(@Nullable String jarPath, @NotNull CoroutineDebuggerMode debuggerMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)debuggerMode), (String)"debuggerMode");
            this.jarPath = jarPath;
            this.debuggerMode = debuggerMode;
        }

        @Nullable
        public final String getJarPath() {
            return this.jarPath;
        }

        @NotNull
        public final CoroutineDebuggerMode getDebuggerMode() {
            return this.debuggerMode;
        }

        @Nullable
        public final String component1() {
            return this.jarPath;
        }

        @NotNull
        public final CoroutineDebuggerMode component2() {
            return this.debuggerMode;
        }

        @NotNull
        public final KotlinxCoroutinesSearchResult copy(@Nullable String jarPath, @NotNull CoroutineDebuggerMode debuggerMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)debuggerMode), (String)"debuggerMode");
            return new KotlinxCoroutinesSearchResult(jarPath, debuggerMode);
        }

        public static /* synthetic */ KotlinxCoroutinesSearchResult copy$default(KotlinxCoroutinesSearchResult kotlinxCoroutinesSearchResult, String string, CoroutineDebuggerMode coroutineDebuggerMode, int n, Object object) {
            if ((n & 1) != 0) {
                string = kotlinxCoroutinesSearchResult.jarPath;
            }
            if ((n & 2) != 0) {
                coroutineDebuggerMode = kotlinxCoroutinesSearchResult.debuggerMode;
            }
            return kotlinxCoroutinesSearchResult.copy(string, coroutineDebuggerMode);
        }

        @NotNull
        public String toString() {
            return "KotlinxCoroutinesSearchResult(jarPath=" + this.jarPath + ", debuggerMode=" + this.debuggerMode + ")";
        }

        public int hashCode() {
            int result2 = this.jarPath == null ? 0 : this.jarPath.hashCode();
            result2 = result2 * 31 + this.debuggerMode.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KotlinxCoroutinesSearchResult)) {
                return false;
            }
            KotlinxCoroutinesSearchResult kotlinxCoroutinesSearchResult = (KotlinxCoroutinesSearchResult)other;
            if (!Intrinsics.areEqual((Object)this.jarPath, (Object)kotlinxCoroutinesSearchResult.jarPath)) {
                return false;
            }
            return this.debuggerMode == kotlinxCoroutinesSearchResult.debuggerMode;
        }
    }
}

