/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.codeInsight.hints.RangeKtExpressionType;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.AbstractRangeInspection;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001f B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0014\u0010\n\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH&J\u001d\u0010\u0013\u001a\u00070\u000e\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u0002*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u001c\u001a\u0004\u0018\u00010\t*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016R\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\u00070\u000e\u00a2\u0006\u0002\b\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u0017\u0010\u0014\u001a\u00070\u000e\u00a2\u0006\u0002\b\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/AbstractReplaceRangeToInspection;", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/AbstractRangeInspection;", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/AbstractReplaceRangeToInspection$Context;", "<init>", "()V", "isApplicableToRangeExpression", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isApplicableArgumentType", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "replacementPattern", "", "getReplacementPattern", "()Ljava/lang/String;", "problemDescription", "Lcom/intellij/codeInspection/util/InspectionMessage;", "getProblemDescription", "quickFixDescription", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getQuickFixDescription", "range", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/AbstractRangeInspection$RangeExpression;", "context", "isApplicableByPsi", "prepareContext", "unfoldMinusOne", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "Context", "ReplaceRangeToQuickFix", "kotlin.code-insight.inspections.shared"})
public abstract class AbstractReplaceRangeToInspection
extends AbstractRangeInspection<Context> {
    public abstract boolean isApplicableToRangeExpression(@NotNull KaSession var1, @NotNull KtExpression var2);

    public abstract boolean isApplicableArgumentType(@NotNull KaSession var1, @NotNull KaType var2);

    @NotNull
    public abstract String getReplacementPattern();

    @NotNull
    public abstract String getProblemDescription();

    @NotNull
    public abstract String getQuickFixDescription();

    @Override
    @NotNull
    public String getProblemDescription(@NotNull AbstractRangeInspection.RangeExpression range2, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getProblemDescription();
    }

    @Override
    public boolean isApplicableByPsi(@NotNull AbstractRangeInspection.RangeExpression range2) {
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        return range2.getType() == RangeKtExpressionType.RANGE_TO;
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull AbstractRangeInspection.RangeExpression range2) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        if (!this.isApplicableToRangeExpression($this$prepareContext, range2.getExpression())) {
            return null;
        }
        Pair<KtExpression, KtExpression> pair = range2.getArguments();
        KtExpression left = (KtExpression)pair.component1();
        KtExpression right = (KtExpression)pair.component2();
        Object object = left;
        if (object == null || (object = $this$prepareContext.getExpressionType((KtExpression)object)) == null) {
            return null;
        }
        Object leftType = object;
        Object object2 = right;
        if (object2 == null || (object2 = $this$prepareContext.getExpressionType((KtExpression)object2)) == null) {
            return null;
        }
        Object rightType = object2;
        if (!this.isApplicableArgumentType($this$prepareContext, (KaType)leftType) || !this.isApplicableArgumentType($this$prepareContext, (KaType)rightType)) {
            return null;
        }
        KtExpression ktExpression = KtPsiUtil.safeDeparenthesize((KtExpression)right);
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"safeDeparenthesize(...)");
        KtExpression ktExpression2 = this.unfoldMinusOne($this$prepareContext, ktExpression);
        if (ktExpression2 == null) {
            return null;
        }
        KtExpression rightUnfolded = ktExpression2;
        return new Context((SmartPsiElementPointer<KtExpression>)SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)left)), (SmartPsiElementPointer<KtExpression>)SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)rightUnfolded)));
    }

    private final KtExpression unfoldMinusOne(KaSession $this$unfoldMinusOne, KtExpression expression) {
        if (!(expression instanceof KtBinaryExpression) || !Intrinsics.areEqual((Object)((KtBinaryExpression)expression).getOperationToken(), (Object)KtTokens.MINUS)) {
            return null;
        }
        Object object = ((KtBinaryExpression)expression).getRight();
        if (object == null || (object = $this$unfoldMinusOne.evaluate((KtExpression)object)) == null) {
            return null;
        }
        Object constantValue = object;
        Object object2 = constantValue.getValue();
        Number number = object2 instanceof Number ? (Number)((Number)object2) : (Number)null;
        if (!(number != null ? number.intValue() == 1 : false)) {
            return null;
        }
        return ((KtBinaryExpression)expression).getLeft();
    }

    @Override
    @NotNull
    public KotlinModCommandQuickFix<KtExpression> createQuickFix(@NotNull AbstractRangeInspection.RangeExpression range2, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new ReplaceRangeToQuickFix(this.getReplacementPattern(), this.getQuickFixDescription(), context);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/AbstractReplaceRangeToInspection$Context;", "", "left", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "right", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getLeft", "()Lcom/intellij/psi/SmartPsiElementPointer;", "getRight", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.code-insight.inspections.shared"})
    public static final class Context {
        @NotNull
        private final SmartPsiElementPointer<KtExpression> left;
        @NotNull
        private final SmartPsiElementPointer<KtExpression> right;

        public Context(@NotNull SmartPsiElementPointer<KtExpression> left, @NotNull SmartPsiElementPointer<KtExpression> right) {
            Intrinsics.checkNotNullParameter(left, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            this.left = left;
            this.right = right;
        }

        @NotNull
        public final SmartPsiElementPointer<KtExpression> getLeft() {
            return this.left;
        }

        @NotNull
        public final SmartPsiElementPointer<KtExpression> getRight() {
            return this.right;
        }

        @NotNull
        public final SmartPsiElementPointer<KtExpression> component1() {
            return this.left;
        }

        @NotNull
        public final SmartPsiElementPointer<KtExpression> component2() {
            return this.right;
        }

        @NotNull
        public final Context copy(@NotNull SmartPsiElementPointer<KtExpression> left, @NotNull SmartPsiElementPointer<KtExpression> right) {
            Intrinsics.checkNotNullParameter(left, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            return new Context(left, right);
        }

        public static /* synthetic */ Context copy$default(Context context, SmartPsiElementPointer smartPsiElementPointer, SmartPsiElementPointer smartPsiElementPointer2, int n, Object object) {
            if ((n & 1) != 0) {
                smartPsiElementPointer = context.left;
            }
            if ((n & 2) != 0) {
                smartPsiElementPointer2 = context.right;
            }
            return context.copy(smartPsiElementPointer, smartPsiElementPointer2);
        }

        @NotNull
        public String toString() {
            return "Context(left=" + this.left + ", right=" + this.right + ")";
        }

        public int hashCode() {
            int result2 = this.left.hashCode();
            result2 = result2 * 31 + this.right.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual(this.left, context.left)) {
                return false;
            }
            return Intrinsics.areEqual(this.right, context.right);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B$\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0006H\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/AbstractReplaceRangeToInspection$ReplaceRangeToQuickFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "replacementPattern", "", "description", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "context", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/AbstractReplaceRangeToInspection$Context;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/AbstractReplaceRangeToInspection$Context;)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.code-insight.inspections.shared"})
    private static final class ReplaceRangeToQuickFix
    extends KotlinModCommandQuickFix<KtExpression> {
        @NotNull
        private final String replacementPattern;
        @NotNull
        private final String description;
        @NotNull
        private final Context context;

        public ReplaceRangeToQuickFix(@NotNull String replacementPattern, @NotNull String description, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)replacementPattern, (String)"replacementPattern");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.replacementPattern = replacementPattern;
            this.description = description;
            this.context = context;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return this.description;
        }

        @Override
        protected void applyFix(@NotNull Project project, @NotNull KtExpression element, @NotNull ModPsiUpdater updater2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            KtExpression ktExpression = (KtExpression)this.context.getLeft().getElement();
            if (ktExpression == null) {
                return;
            }
            KtExpression left = ktExpression;
            KtExpression ktExpression2 = (KtExpression)this.context.getRight().getElement();
            if (ktExpression2 == null) {
                return;
            }
            KtExpression right = ktExpression2;
            Object[] objectArray = new Object[]{left, right};
            element.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)this.replacementPattern, (Object[])objectArray, (boolean)false, (int)4, null));
        }
    }
}

