/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.dependency.fest_util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Dates {
    public static final DateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat ISO_DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final DateFormat ISO_DATE_TIME_FORMAT_WITH_MS = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public static synchronized String formatAsDatetime(Date date) {
        return date == null ? null : ISO_DATE_TIME_FORMAT.format(date);
    }

    public static synchronized String formatAsDatetimeWithMs(Date date) {
        return date == null ? null : ISO_DATE_TIME_FORMAT_WITH_MS.format(date);
    }

    public static String formatAsDatetime(Calendar calendar) {
        return calendar == null ? null : Dates.formatAsDatetime(calendar.getTime());
    }

    public static Date parse(String dateAsString) {
        try {
            return dateAsString == null ? null : ISO_DATE_FORMAT.parse(dateAsString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date parseDatetime(String dateAsString) {
        try {
            return dateAsString == null ? null : ISO_DATE_TIME_FORMAT.parse(dateAsString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Calendar toCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static int yearOf(Date date) {
        return Dates.toCalendar(date).get(1);
    }

    public static int monthOf(Date date) {
        return Dates.toCalendar(date).get(2) + 1;
    }

    public static int dayOfMonthOf(Date date) {
        return Dates.toCalendar(date).get(5);
    }

    public static int dayOfWeekOf(Date date) {
        return Dates.toCalendar(date).get(7);
    }

    public static int hourOfDay(Date date) {
        return Dates.toCalendar(date).get(11);
    }

    public static int minuteOf(Date date) {
        return Dates.toCalendar(date).get(12);
    }

    public static int secondOf(Date date) {
        return Dates.toCalendar(date).get(13);
    }

    public static int millisecondOf(Date date) {
        return Dates.toCalendar(date).get(14);
    }

    public static Date truncateTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Dates.toCalendar(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date today() {
        return new Date();
    }

    public static Date yesterday() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date tomorrow() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        return cal.getTime();
    }
}

