/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.telemetry;

import com.intellij.platform.diagnostic.telemetry.rt.context.TelemetryContext;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.ParallelRunnerForServer;

public final class MavenServerOpenTelemetry {
    private static final String INSTRUMENTATION_NAME = "MavenServer";
    @NotNull
    private final Tracer tracer;
    @NotNull
    private final Scope myScope;

    private MavenServerOpenTelemetry(@NotNull TelemetryContext remoteContext) {
        if (remoteContext == null) {
            MavenServerOpenTelemetry.$$$reportNull$$$0(0);
        }
        OpenTelemetry telemetry = GlobalOpenTelemetry.get();
        Context context = remoteContext.extract(telemetry.getPropagators().getTextMapPropagator());
        this.myScope = context.makeCurrent();
        this.tracer = telemetry.getTracer(INSTRUMENTATION_NAME);
    }

    public <T> T callWithSpan(@NotNull String spanName, @NotNull Supplier<T> fn) {
        if (spanName == null) {
            MavenServerOpenTelemetry.$$$reportNull$$$0(1);
        }
        if (fn == null) {
            MavenServerOpenTelemetry.$$$reportNull$$$0(2);
        }
        SpanBuilder spanBuilder = this.tracer.spanBuilder(spanName);
        Span span = spanBuilder.startSpan();
        try {
            T t;
            block13: {
                Scope ignore = span.makeCurrent();
                try {
                    t = fn.get();
                    if (ignore == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        span.recordException((Throwable)e);
                        span.setStatus(StatusCode.ERROR);
                        throw e;
                    }
                }
                ignore.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    public <T, R> List<R> execute(boolean inParallel, @NotNull Collection<T> collection, @NotNull Function<T, R> method) {
        if (collection == null) {
            MavenServerOpenTelemetry.$$$reportNull$$$0(3);
        }
        if (method == null) {
            MavenServerOpenTelemetry.$$$reportNull$$$0(4);
        }
        Context context = Context.current();
        return ParallelRunnerForServer.execute((boolean)inParallel, collection, (Function)context.wrapFunction(method));
    }

    public <T, R> List<R> executeWithSpan(@NotNull String spanName, boolean inParallel, @NotNull Collection<T> collection, @NotNull Function<T, R> method) {
        if (spanName == null) {
            MavenServerOpenTelemetry.$$$reportNull$$$0(5);
        }
        if (collection == null) {
            MavenServerOpenTelemetry.$$$reportNull$$$0(6);
        }
        if (method == null) {
            MavenServerOpenTelemetry.$$$reportNull$$$0(7);
        }
        return this.callWithSpan(spanName, () -> this.execute(inParallel, collection, method));
    }

    public void shutdown() {
        this.myScope.close();
    }

    @NotNull
    public static MavenServerOpenTelemetry from(@NotNull TelemetryContext context) {
        if (context == null) {
            MavenServerOpenTelemetry.$$$reportNull$$$0(8);
        }
        return new MavenServerOpenTelemetry(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteContext";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spanName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fn";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/maven/server/telemetry/MavenServerOpenTelemetry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "callWithSpan";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "executeWithSpan";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "from";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

