/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import androidx.compose.foundation.text.CoreTextFieldKt;
import androidx.compose.foundation.text.LegacyTextFieldState;
import androidx.compose.foundation.text.TextFieldDelegate;
import androidx.compose.foundation.text.TextLayoutResultProxy;
import androidx.compose.foundation.text.selection.TextFieldSelectionManager;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.autofill.ContentDataType;
import androidx.compose.ui.focus.FocusRequester;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.DelegatingNode;
import androidx.compose.ui.node.SemanticsModifierNode;
import androidx.compose.ui.node.SemanticsModifierNodeKt;
import androidx.compose.ui.semantics.SemanticsPropertiesKt;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteAllCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.FinishComposingTextCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextInputSession;
import androidx.compose.ui.text.input.TransformedText;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b'\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002BU\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J(\u0010;\u001a\u00020<2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010=\u001a\u00020>2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002JV\u0010?\u001a\u00020<2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010@\u001a\u00020<*\u00020AH\u0016R\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0017\"\u0004\b\"\u0010\u0019R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0017\"\u0004\b,\u0010\u0019R\u0014\u0010-\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0017R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:\u00a8\u0006B"}, d2={"Landroidx/compose/foundation/text/input/internal/CoreTextFieldSemanticsModifierNode;", "Landroidx/compose/ui/node/DelegatingNode;", "Landroidx/compose/ui/node/SemanticsModifierNode;", "transformedText", "Landroidx/compose/ui/text/input/TransformedText;", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "state", "Landroidx/compose/foundation/text/LegacyTextFieldState;", "readOnly", "", "enabled", "isPassword", "offsetMapping", "Landroidx/compose/ui/text/input/OffsetMapping;", "manager", "Landroidx/compose/foundation/text/selection/TextFieldSelectionManager;", "imeOptions", "Landroidx/compose/ui/text/input/ImeOptions;", "focusRequester", "Landroidx/compose/ui/focus/FocusRequester;", "(Landroidx/compose/ui/text/input/TransformedText;Landroidx/compose/ui/text/input/TextFieldValue;Landroidx/compose/foundation/text/LegacyTextFieldState;ZZZLandroidx/compose/ui/text/input/OffsetMapping;Landroidx/compose/foundation/text/selection/TextFieldSelectionManager;Landroidx/compose/ui/text/input/ImeOptions;Landroidx/compose/ui/focus/FocusRequester;)V", "getEnabled", "()Z", "setEnabled", "(Z)V", "getFocusRequester", "()Landroidx/compose/ui/focus/FocusRequester;", "setFocusRequester", "(Landroidx/compose/ui/focus/FocusRequester;)V", "getImeOptions", "()Landroidx/compose/ui/text/input/ImeOptions;", "setImeOptions", "(Landroidx/compose/ui/text/input/ImeOptions;)V", "setPassword", "getManager", "()Landroidx/compose/foundation/text/selection/TextFieldSelectionManager;", "setManager", "(Landroidx/compose/foundation/text/selection/TextFieldSelectionManager;)V", "getOffsetMapping", "()Landroidx/compose/ui/text/input/OffsetMapping;", "setOffsetMapping", "(Landroidx/compose/ui/text/input/OffsetMapping;)V", "getReadOnly", "setReadOnly", "shouldMergeDescendantSemantics", "getShouldMergeDescendantSemantics", "getState", "()Landroidx/compose/foundation/text/LegacyTextFieldState;", "setState", "(Landroidx/compose/foundation/text/LegacyTextFieldState;)V", "getTransformedText", "()Landroidx/compose/ui/text/input/TransformedText;", "setTransformedText", "(Landroidx/compose/ui/text/input/TransformedText;)V", "getValue", "()Landroidx/compose/ui/text/input/TextFieldValue;", "setValue", "(Landroidx/compose/ui/text/input/TextFieldValue;)V", "handleTextUpdateFromSemantics", "", "text", "", "updateNodeSemantics", "applySemantics", "Landroidx/compose/ui/semantics/SemanticsPropertyReceiver;", "foundation"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCoreTextFieldSemanticsModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreTextFieldSemanticsModifier.kt\nandroidx/compose/foundation/text/input/internal/CoreTextFieldSemanticsModifierNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,335:1\n1#2:336\n*E\n"})
public final class CoreTextFieldSemanticsModifierNode
extends DelegatingNode
implements SemanticsModifierNode {
    @NotNull
    private TransformedText transformedText;
    @NotNull
    private TextFieldValue value;
    @NotNull
    private LegacyTextFieldState state;
    private boolean readOnly;
    private boolean enabled;
    private boolean isPassword;
    @NotNull
    private OffsetMapping offsetMapping;
    @NotNull
    private TextFieldSelectionManager manager;
    @NotNull
    private ImeOptions imeOptions;
    @NotNull
    private FocusRequester focusRequester;
    public static final int $stable = 8;

    public CoreTextFieldSemanticsModifierNode(@NotNull TransformedText transformedText, @NotNull TextFieldValue value, @NotNull LegacyTextFieldState state2, boolean readOnly, boolean enabled, boolean isPassword, @NotNull OffsetMapping offsetMapping, @NotNull TextFieldSelectionManager manager, @NotNull ImeOptions imeOptions, @NotNull FocusRequester focusRequester) {
        Intrinsics.checkNotNullParameter((Object)transformedText, (String)"transformedText");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"offsetMapping");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter((Object)focusRequester, (String)"focusRequester");
        this.transformedText = transformedText;
        this.value = value;
        this.state = state2;
        this.readOnly = readOnly;
        this.enabled = enabled;
        this.isPassword = isPassword;
        this.offsetMapping = offsetMapping;
        this.manager = manager;
        this.imeOptions = imeOptions;
        this.focusRequester = focusRequester;
        this.manager.setRequestAutofillAction$foundation((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                DelegatableNodeKt.requestAutofill(this);
            }
        }));
    }

    @NotNull
    public final TransformedText getTransformedText() {
        return this.transformedText;
    }

    public final void setTransformedText(@NotNull TransformedText transformedText) {
        Intrinsics.checkNotNullParameter((Object)transformedText, (String)"<set-?>");
        this.transformedText = transformedText;
    }

    @NotNull
    public final TextFieldValue getValue() {
        return this.value;
    }

    public final void setValue(@NotNull TextFieldValue textFieldValue) {
        Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"<set-?>");
        this.value = textFieldValue;
    }

    @NotNull
    public final LegacyTextFieldState getState() {
        return this.state;
    }

    public final void setState(@NotNull LegacyTextFieldState legacyTextFieldState) {
        Intrinsics.checkNotNullParameter((Object)legacyTextFieldState, (String)"<set-?>");
        this.state = legacyTextFieldState;
    }

    public final boolean getReadOnly() {
        return this.readOnly;
    }

    public final void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final boolean isPassword() {
        return this.isPassword;
    }

    public final void setPassword(boolean bl) {
        this.isPassword = bl;
    }

    @NotNull
    public final OffsetMapping getOffsetMapping() {
        return this.offsetMapping;
    }

    public final void setOffsetMapping(@NotNull OffsetMapping offsetMapping) {
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"<set-?>");
        this.offsetMapping = offsetMapping;
    }

    @NotNull
    public final TextFieldSelectionManager getManager() {
        return this.manager;
    }

    public final void setManager(@NotNull TextFieldSelectionManager textFieldSelectionManager) {
        Intrinsics.checkNotNullParameter((Object)textFieldSelectionManager, (String)"<set-?>");
        this.manager = textFieldSelectionManager;
    }

    @NotNull
    public final ImeOptions getImeOptions() {
        return this.imeOptions;
    }

    public final void setImeOptions(@NotNull ImeOptions imeOptions) {
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"<set-?>");
        this.imeOptions = imeOptions;
    }

    @NotNull
    public final FocusRequester getFocusRequester() {
        return this.focusRequester;
    }

    public final void setFocusRequester(@NotNull FocusRequester focusRequester) {
        Intrinsics.checkNotNullParameter((Object)focusRequester, (String)"<set-?>");
        this.focusRequester = focusRequester;
    }

    @Override
    public boolean getShouldMergeDescendantSemantics() {
        return true;
    }

    @Override
    public void applySemantics(@NotNull SemanticsPropertyReceiver $this$applySemantics) {
        Intrinsics.checkNotNullParameter((Object)$this$applySemantics, (String)"<this>");
        SemanticsPropertiesKt.setEditableText($this$applySemantics, this.transformedText.getText());
        SemanticsPropertiesKt.setTextSelectionRange-FDrldGo($this$applySemantics, this.value.getSelection-d9O1mEE());
        SemanticsPropertiesKt.setContentDataType($this$applySemantics, ContentDataType.Companion.getText());
        SemanticsPropertiesKt.onAutofillText$default($this$applySemantics, null, (Function1)new Function1<AnnotatedString, Boolean>(this){
            final /* synthetic */ CoreTextFieldSemanticsModifierNode this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Boolean invoke(AnnotatedString text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.this$0.getState().setJustAutofilled(true);
                this.this$0.getState().setAutofillHighlightOn(true);
                CoreTextFieldSemanticsModifierNode.access$handleTextUpdateFromSemantics(this.this$0, this.this$0.getState(), text.getText(), this.this$0.getReadOnly(), this.this$0.getEnabled());
                return true;
            }
        }, 1, null);
        if (!this.enabled) {
            SemanticsPropertiesKt.disabled($this$applySemantics);
        }
        if (this.isPassword) {
            SemanticsPropertiesKt.password($this$applySemantics);
        }
        boolean editable = this.enabled && !this.readOnly;
        SemanticsPropertiesKt.setEditable($this$applySemantics, editable);
        SemanticsPropertiesKt.getTextLayoutResult$default($this$applySemantics, null, (Function1)new Function1<List<TextLayoutResult>, Boolean>(this){
            final /* synthetic */ CoreTextFieldSemanticsModifierNode this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Boolean invoke(List<TextLayoutResult> it) {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (this.this$0.getState().getLayoutResult() != null) {
                    TextLayoutResultProxy textLayoutResultProxy = this.this$0.getState().getLayoutResult();
                    Intrinsics.checkNotNull((Object)textLayoutResultProxy);
                    it.add(textLayoutResultProxy.getValue());
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
        }, 1, null);
        if (editable) {
            SemanticsPropertiesKt.setText$default($this$applySemantics, null, (Function1)new Function1<AnnotatedString, Boolean>(this){
                final /* synthetic */ CoreTextFieldSemanticsModifierNode this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Boolean invoke(AnnotatedString text) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    CoreTextFieldSemanticsModifierNode.access$handleTextUpdateFromSemantics(this.this$0, this.this$0.getState(), text.getText(), this.this$0.getReadOnly(), this.this$0.getEnabled());
                    return true;
                }
            }, 1, null);
            SemanticsPropertiesKt.insertTextAtCursor$default($this$applySemantics, null, (Function1)new Function1<AnnotatedString, Boolean>(this, $this$applySemantics){
                final /* synthetic */ CoreTextFieldSemanticsModifierNode this$0;
                final /* synthetic */ SemanticsPropertyReceiver $this_applySemantics;
                {
                    this.this$0 = $receiver;
                    this.$this_applySemantics = $receiver2;
                    super(1);
                }

                public final Boolean invoke(AnnotatedString text) {
                    block3: {
                        Unit unit;
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                        if (this.this$0.getReadOnly() || !this.this$0.getEnabled()) {
                            return false;
                        }
                        TextInputSession textInputSession2 = this.this$0.getState().getInputSession();
                        if (textInputSession2 != null) {
                            object = textInputSession2;
                            CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode = this.this$0;
                            TextInputSession session = object;
                            boolean bl = false;
                            Object[] objectArray = new EditCommand[]{new FinishComposingTextCommand(), new CommitTextCommand(text, 1)};
                            TextFieldDelegate.Companion.onEditCommand$foundation(CollectionsKt.listOf((Object[])objectArray), coreTextFieldSemanticsModifierNode.getState().getProcessor(), coreTextFieldSemanticsModifierNode.getState().getOnValueChange(), session);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        if (unit != null) break block3;
                        SemanticsPropertyReceiver semanticsPropertyReceiver = this.$this_applySemantics;
                        object = this.this$0;
                        SemanticsPropertyReceiver $this$invoke_u24lambda_u241 = semanticsPropertyReceiver;
                        boolean bl = false;
                        String string = ((CoreTextFieldSemanticsModifierNode)object).getValue().getText();
                        int n = TextRange.getStart-impl(((CoreTextFieldSemanticsModifierNode)object).getValue().getSelection-d9O1mEE());
                        int n2 = TextRange.getEnd-impl(((CoreTextFieldSemanticsModifierNode)object).getValue().getSelection-d9O1mEE());
                        String newText = ((Object)StringsKt.replaceRange((CharSequence)string, (int)n, (int)n2, (CharSequence)text)).toString();
                        long newCursor = TextRangeKt.TextRange(TextRange.getStart-impl(((CoreTextFieldSemanticsModifierNode)object).getValue().getSelection-d9O1mEE()) + text.length());
                        ((CoreTextFieldSemanticsModifierNode)object).getState().getOnValueChange().invoke((Object)new TextFieldValue(newText, newCursor, null, 4, null));
                    }
                    return true;
                }
            }, 1, null);
        }
        SemanticsPropertiesKt.setSelection$default($this$applySemantics, null, (Function3)new Function3<Integer, Integer, Boolean, Boolean>(this){
            final /* synthetic */ CoreTextFieldSemanticsModifierNode this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final Boolean invoke(int selectionStart, int selectionEnd, boolean relativeToOriginalText) {
                boolean bl;
                int end2;
                int start = relativeToOriginalText ? selectionStart : this.this$0.getOffsetMapping().transformedToOriginal(selectionStart);
                int n = end2 = relativeToOriginalText ? selectionEnd : this.this$0.getOffsetMapping().transformedToOriginal(selectionEnd);
                if (!this.this$0.getEnabled()) {
                    bl = false;
                } else if (start == TextRange.getStart-impl(this.this$0.getValue().getSelection-d9O1mEE()) && end2 == TextRange.getEnd-impl(this.this$0.getValue().getSelection-d9O1mEE())) {
                    bl = false;
                } else if (Math.min(start, end2) >= 0 && Math.max(start, end2) <= this.this$0.getValue().getAnnotatedString().length()) {
                    if (relativeToOriginalText || start == end2) {
                        this.this$0.getManager().exitSelectionMode$foundation();
                    } else {
                        TextFieldSelectionManager.enterSelectionMode$foundation$default(this.this$0.getManager(), false, 1, null);
                    }
                    this.this$0.getState().getOnValueChange().invoke((Object)new TextFieldValue(this.this$0.getValue().getAnnotatedString(), TextRangeKt.TextRange(start, end2), null, 4, null));
                    bl = true;
                } else {
                    this.this$0.getManager().exitSelectionMode$foundation();
                    bl = false;
                }
                return bl;
            }
        }, 1, null);
        SemanticsPropertiesKt.onImeAction-9UiTYpY$default($this$applySemantics, this.imeOptions.getImeAction-eUduSuo(), null, (Function0)new Function0<Boolean>(this){
            final /* synthetic */ CoreTextFieldSemanticsModifierNode this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                this.this$0.getState().getOnImeActionPerformed().invoke((Object)ImeAction.box-impl(this.this$0.getImeOptions().getImeAction-eUduSuo()));
                return true;
            }
        }, 2, null);
        SemanticsPropertiesKt.onClick$default($this$applySemantics, null, (Function0)new Function0<Boolean>(this){
            final /* synthetic */ CoreTextFieldSemanticsModifierNode this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                CoreTextFieldKt.requestFocusAndShowKeyboardIfNeeded(this.this$0.getState(), this.this$0.getFocusRequester(), !this.this$0.getReadOnly());
                return true;
            }
        }, 1, null);
        SemanticsPropertiesKt.onLongClick$default($this$applySemantics, null, (Function0)new Function0<Boolean>(this){
            final /* synthetic */ CoreTextFieldSemanticsModifierNode this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                TextFieldSelectionManager.enterSelectionMode$foundation$default(this.this$0.getManager(), false, 1, null);
                return true;
            }
        }, 1, null);
        if (!TextRange.getCollapsed-impl(this.value.getSelection-d9O1mEE()) && !this.isPassword) {
            SemanticsPropertiesKt.copyText$default($this$applySemantics, null, (Function0)new Function0<Boolean>(this){
                final /* synthetic */ CoreTextFieldSemanticsModifierNode this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final Boolean invoke() {
                    TextFieldSelectionManager.copy$foundation$default(this.this$0.getManager(), false, 1, null);
                    return true;
                }
            }, 1, null);
            if (this.enabled && !this.readOnly) {
                SemanticsPropertiesKt.cutText$default($this$applySemantics, null, (Function0)new Function0<Boolean>(this){
                    final /* synthetic */ CoreTextFieldSemanticsModifierNode this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final Boolean invoke() {
                        this.this$0.getManager().cut$foundation();
                        return true;
                    }
                }, 1, null);
            }
        }
        if (this.enabled && !this.readOnly) {
            SemanticsPropertiesKt.pasteText$default($this$applySemantics, null, (Function0)new Function0<Boolean>(this){
                final /* synthetic */ CoreTextFieldSemanticsModifierNode this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final Boolean invoke() {
                    this.this$0.getManager().paste$foundation();
                    return true;
                }
            }, 1, null);
        }
    }

    public final void updateNodeSemantics(@NotNull TransformedText transformedText, @NotNull TextFieldValue value, @NotNull LegacyTextFieldState state2, boolean readOnly, boolean enabled, boolean isPassword, @NotNull OffsetMapping offsetMapping, @NotNull TextFieldSelectionManager manager, @NotNull ImeOptions imeOptions, @NotNull FocusRequester focusRequester) {
        Intrinsics.checkNotNullParameter((Object)transformedText, (String)"transformedText");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"offsetMapping");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter((Object)focusRequester, (String)"focusRequester");
        boolean previousEditable = this.enabled && !this.readOnly;
        boolean previousEnabled = this.enabled;
        boolean previousIsPassword = this.isPassword;
        ImeOptions previousImeOptions = this.imeOptions;
        TextFieldSelectionManager previousManager = this.manager;
        boolean editable = enabled && !readOnly;
        this.transformedText = transformedText;
        this.value = value;
        this.state = state2;
        this.readOnly = readOnly;
        this.enabled = enabled;
        this.offsetMapping = offsetMapping;
        this.manager = manager;
        this.imeOptions = imeOptions;
        this.focusRequester = focusRequester;
        if (enabled != previousEnabled || editable != previousEditable || !Intrinsics.areEqual((Object)imeOptions, (Object)previousImeOptions) || isPassword != previousIsPassword || !TextRange.getCollapsed-impl(value.getSelection-d9O1mEE())) {
            SemanticsModifierNodeKt.invalidateSemantics(this);
        }
        if (!Intrinsics.areEqual((Object)manager, (Object)previousManager)) {
            manager.setRequestAutofillAction$foundation((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ CoreTextFieldSemanticsModifierNode this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    DelegatableNodeKt.requestAutofill(this.this$0);
                }
            }));
        }
    }

    private final void handleTextUpdateFromSemantics(LegacyTextFieldState state2, String text, boolean readOnly, boolean enabled) {
        block3: {
            Unit unit;
            if (readOnly || !enabled) {
                return;
            }
            TextInputSession textInputSession2 = state2.getInputSession();
            if (textInputSession2 != null) {
                TextInputSession session = textInputSession2;
                boolean bl = false;
                Object[] objectArray = new EditCommand[]{new DeleteAllCommand(), new CommitTextCommand(text, 1)};
                TextFieldDelegate.Companion.onEditCommand$foundation(CollectionsKt.listOf((Object[])objectArray), state2.getProcessor(), state2.getOnValueChange(), session);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block3;
            CoreTextFieldSemanticsModifierNode $this$handleTextUpdateFromSemantics_u24lambda_u241 = this;
            boolean bl = false;
            state2.getOnValueChange().invoke((Object)new TextFieldValue(text, TextRangeKt.TextRange(text.length()), null, 4, null));
        }
    }

    public static final /* synthetic */ void access$handleTextUpdateFromSemantics(CoreTextFieldSemanticsModifierNode $this, LegacyTextFieldState state2, String text, boolean readOnly, boolean enabled) {
        $this.handleTextUpdateFromSemantics(state2, text, readOnly, enabled);
    }
}

