# WPE, chapter 3
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("wpe02.tst");

# doc/tutorial.xml:14-20
gap> LoadPackage("WPE");;
gap> K := AlternatingGroup(5);;
gap> H := SymmetricGroup(4);;
gap> G := WreathProduct(K, H);
<permutation group of size 311040000 with 10 generators>

# doc/tutorial.xml:37-43
gap> gList := [ (1,5,2,4,3), (1,3,5,2,4), (1,5,3,4,2), (1,4,5), (1,3)(2,4) ];;
gap> g := WreathProductElementList(G, gList);
(1,15,3,11,5,12)(2,14)(4,13)(6,18,8,20)(7,19,10,17)(9,16)
gap> g in G;
true

# doc/tutorial.xml:47-52
gap> ListWreathProductElement(G, g);
[ (1,5,2,4,3), (1,3,5,2,4), (1,5,3,4,2), (1,4,5), (1,3)(2,4) ]
gap> last = gList;
true

# doc/tutorial.xml:63-66
gap> Territory(gList);
[ 1, 2, 3, 4 ]

# doc/tutorial.xml:73-82
gap> h := (1,2,3) ^ Embedding(G,2)
>       * (1,5,2,4,3) ^ Embedding(G,4)
>       * (1,2,4) ^ Embedding(G, 5);
(1,6,17,4,9,19,3,8,16,5,10,20,2,7,18)
gap> hList := ListWreathProductElement(G, h);
[ (), (1,2,3), (), (1,5,2,4,3), (1,2,4) ]
gap> IsWreathCycle(hList);
true

# doc/tutorial.xml:98-108
gap> LoadPackage("WPE");;
gap> K := AlternatingGroup(5);;
gap> H := SymmetricGroup(4);;
gap> G := WreathProduct(K, H);;
gap> iso := IsomorphismWreathProduct(G);;
gap> W := Image(iso);;
gap> g := (1,15,8,20)(2,14,7,19,5,12,6,18,3,11,10,17)(4,13,9,16);;
gap> g in G;
true

# doc/tutorial.xml:112-115
gap> w := g ^ iso;
< wreath product element with 4 base components >

# doc/tutorial.xml:119-126
gap> Print(w, "\n");
[ (1,5,2,4,3), (1,3,5,2,4), (1,5,3,4,2), (1,4,5), (1,3,2,4) ]
gap> L := ListWreathProductElement(W, w);
[ (1,5,2,4,3), (1,3,5,2,4), (1,5,3,4,2), (1,4,5), (1,3,2,4) ]
gap> L = ListWreathProductElement(G, g);
true

# doc/tutorial.xml:130-134
gap> Display(w);
       1            2            3          4        top   
( (1,5,2,4,3), (1,3,5,2,4), (1,5,3,4,2), (1,4,5); (1,3,2,4) )

# doc/tutorial.xml:141-151
gap> Display(w, rec(horizontal := false));
  1: (1,5,2,4,3)
  2: (1,3,5,2,4)
  3: (1,5,3,4,2)
  4: (1,4,5)
top: (1,3,2,4)
gap> Display(w);
       1            2            3          4        top   
( (1,5,2,4,3), (1,3,5,2,4), (1,5,3,4,2), (1,4,5); (1,3,2,4) )

# doc/tutorial.xml:154-162
gap> SetDisplayOptionsForWreathProductElements(rec(horizontal := false));
gap> Display(w);
  1: (1,5,2,4,3)
  2: (1,3,5,2,4)
  3: (1,5,3,4,2)
  4: (1,4,5)
top: (1,3,2,4)

# doc/tutorial.xml:165-170
gap> ResetDisplayOptionsForWreathProductElements();
gap> Display(w);
       1            2            3          4        top   
( (1,5,2,4,3), (1,3,5,2,4), (1,5,3,4,2), (1,4,5); (1,3,2,4) )

# doc/tutorial.xml:176-185
gap> a := BaseComponentOfWreathProductElement(w, 3);
(1,5,3,4,2)
gap> a = L[3];
true
gap> b := TopComponentOfWreathProductElement(w);
(1,3,2,4)
gap> b = L[5];
true

# doc/tutorial.xml:201-212
gap> LoadPackage("WPE");;
gap> K := Group([ (1,2,3,4,5), (1,2,4,3) ]);; # F(5)
gap> H := Group([ (1,2,3,4,5,6), (2,6)(3,5) ]);; # D(12)
gap> G := WreathProduct(K, H);
<permutation group of size 768000000 with 4 generators>
gap> P := WreathProduct(K, SymmetricGroup(NrMovedPoints(H)));
<permutation group of size 46080000000 with 4 generators>
gap> IsSubgroup(P, G);
true
gap> iso := IsomorphismWreathProduct(P);;

# doc/tutorial.xml:216-229
gap> x := (1,23,12,6,4,24,13,9,5,21,15,10,2,25,14,7)(3,22,11,8)(16,30,20,28)(17,27,19,26)(18,29);;
gap> y := (1,12,26,8,3,14,28,7,2,13,27,10,5,11,30,6)(4,15,29,9)(16,23,20,22)(17,24,19,21)(18,25);;
gap> Display(x ^ iso);
      1          2          3          4           5           6           top      
( (1,3,2,5), (1,4,5,2), (1,3,4,2), (1,5,3,4), (1,5,4,3,2), (1,2,4,3); (1,5,3,2)(4,6) )
gap> Display(y ^ iso);
       1       2        3            4           5           6           top      
( (1,2,3,4,5), (), (1,5,4,3,2), (1,3,5,2,4), (1,2)(3,5), (1,3,2,5); (1,3,6,2)(4,5) )
gap> x in P and y in P;
true
gap> not x in G and not y in G;
true

# doc/tutorial.xml:243-246
gap> RepresentativeAction(G, x, y);
fail

# doc/tutorial.xml:249-257
gap> c := RepresentativeAction(P, x, y);
(2,5)(3,4)(6,8,9,7)(11,29,25)(12,26,21,13,28,22,15,27,24,14,30,23)
gap> Display(c^iso);
      1           2          3      4       5          6        top  
( (2,5)(3,4), (1,3,4,2), (1,4,5,2), (), (1,3,2,5), (2,4,5,3); (3,6,5) )
gap> x ^ c = y;
true

# doc/tutorial.xml:272-276
gap> CC := ConjugacyClasses(G);;
gap> Length(CC);
1960

# doc/tutorial.xml:280-283
gap> A := CC[1617];
(2,4,5,3)(6,26)(7,29,9,30,10,28,8,27)(11,21)(12,22)(13,23)(14,24)(15,25)^G

# doc/tutorial.xml:287-290
gap> Size(A);
60000

# doc/tutorial.xml:293-299
gap> a := Representative(A);
(2,4,5,3)(6,26)(7,29,9,30,10,28,8,27)(11,21)(12,22)(13,23)(14,24)(15,25)
gap> Display(a ^ iso);
      1          2      3   4   5   6      top    
( (2,4,5,3), (2,4,5,3), (), (), (), (); (2,6)(3,5) )

# doc/tutorial.xml:316-320
gap> C := Centralizer(G, x);
Group([ (16,20)(17,19)(26,27)(28,30), (16,19,20,17)(26,28,27,30),
        (1,4,5,2)(6,9,10,7)(12,13,15,14)(21,25,23,24) ])

# doc/tutorial.xml:325-328
gap> Size(C);
16

# doc/tutorial.xml:333-345
gap> for g in GeneratorsOfGroup(C) do
>   Display(g ^ iso);
> od;
  1   2   3       4       5       6       top
( (), (), (), (1,5)(2,4), (), (1,2)(3,5); () )

  1   2   3       4      5       6      top
( (), (), (), (1,4,5,2), (), (1,3,2,5); () )

      1          2          3      4       5      6   top
( (1,4,5,2), (1,4,5,2), (2,3,5,4), (), (1,5,3,4), (); () )

# doc/tutorial.xml:358-367
gap> LoadPackage("WPE");;
gap> K := Group([ (1,2), (1,2,3) ]);; # S(3)
gap> H := Group([ (1,2) ]);; # C(2)
gap> G_impr := WreathProduct(K, H);;
gap> NrMovedPoints(G_impr);
6
gap> Order(G_impr);
72

# doc/tutorial.xml:371-375
gap> c_impr := CycleIndex(G_impr);
1/72*x_1^6+1/12*x_1^4*x_2+1/18*x_1^3*x_3+1/8*x_1^2*x_2^2+1/6*x_1*x_2*x_3
+1/12*x_2^3+1/4*x_2*x_4+1/18*x_3^2+1/6*x_6

# doc/tutorial.xml:381-386
gap> Display(ExtRepPolynomialRatFun(c_impr));
[ [ 6, 1 ], 1/6, [ 3, 2 ], 1/18, [ 2, 1, 4, 1 ], 1/4, [ 2, 3 ], 1/12, 
  [ 1, 1, 2, 1, 3, 1 ], 1/6, [ 1, 2, 2, 2 ], 1/8, [ 1, 3, 3, 1 ], 1/18, 
  [ 1, 4, 2, 1 ], 1/12, [ 1, 6 ], 1/72 ]

# doc/tutorial.xml:400-406
gap> G_prod := WreathProductProductAction(K, H);;
gap> NrMovedPoints(G_prod);
9
gap> c_prod := CycleIndex(G_prod);
1/72*x_1^9+1/6*x_1^3*x_2^3+1/8*x_1*x_2^4+1/4*x_1*x_4^2+1/9*x_3^3+1/3*x_3*x_6

# doc/tutorial.xml:413-420
gap> c1 := CycleIndexWreathProductImprimitiveAction(K, H);;
gap> c_impr = c1;
true
gap> c2 := CycleIndexWreathProductProductAction(K, H);;
gap> c_prod = c2;
true

#
gap> STOP_TEST("wpe02.tst", 1);
