/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.checkBoxTree;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.util.Objects;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.openstreetmap.gui.jmapviewer.AbstractLayer;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.LayerGroup;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodeData;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodeEditor;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodeRenderer;

public class CheckBoxTree
extends JTree {
    private static final long serialVersionUID = 6943401106938034256L;
    private final CheckBoxNodeEditor editor;

    public CheckBoxTree(AbstractLayer layer) {
        this(new CheckBoxNodeData(layer));
    }

    public CheckBoxTree(String rootName) {
        this(new CheckBoxNodeData(rootName));
    }

    public CheckBoxTree(CheckBoxNodeData root) {
        this(new DefaultMutableTreeNode(root));
    }

    public CheckBoxTree(DefaultMutableTreeNode node) {
        super(new DefaultTreeModel(node));
        CheckBoxNodeRenderer renderer = new CheckBoxNodeRenderer();
        this.setCellRenderer(renderer);
        this.editor = new CheckBoxNodeEditor(this);
        this.setCellEditor(this.editor);
        this.setEditable(true);
        this.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                DefaultTreeModel model = (DefaultTreeModel)e.getSource();
                Object[] nodes = e.getChildren();
                DefaultMutableTreeNode node = nodes == null || nodes.length == 0 ? CheckBoxTree.node(model.getRoot()) : CheckBoxTree.node(nodes[0]);
                CheckBoxTree.nodeChanged(node);
                CheckBoxTree.this.repaint();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
    }

    public void addNodeListener(MouseAdapter listener) {
        this.editor.addNodeListener(listener);
    }

    public static void main(String[] args) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new CheckBoxNodeData("Root", Boolean.TRUE));
        DefaultMutableTreeNode accessibility = CheckBoxTree.add(root, "Accessibility", true);
        CheckBoxTree.add(accessibility, "Move system caret with focus/selection changes", false);
        CheckBoxTree.add(accessibility, "Always expand alt text for images", true);
        root.add(accessibility);
        DefaultMutableTreeNode browsing = new DefaultMutableTreeNode(new CheckBoxNodeData("Browsing", null));
        CheckBoxTree.add(browsing, "Notify when downloads complete", true);
        CheckBoxTree.add(browsing, "Disable script debugging", true);
        CheckBoxTree.add(browsing, "Use AutoComplete", true);
        CheckBoxTree.add(browsing, "Browse in a new process", false);
        root.add(browsing);
        CheckBoxTree tree = new CheckBoxTree(root);
        ((DefaultMutableTreeNode)tree.getModel().getRoot()).add(new DefaultMutableTreeNode(new CheckBoxNodeData("gggg", null)));
        ((DefaultTreeModel)tree.getModel()).reload();
        JFrame frame = new JFrame("CheckBox Tree");
        JScrollPane scrollPane = new JScrollPane(tree);
        frame.getContentPane().add((Component)scrollPane, "Center");
        frame.setDefaultCloseOperation(3);
        frame.setSize(300, 150);
        frame.setVisible(true);
    }

    private static Boolean childStatus(DefaultMutableTreeNode node) {
        Boolean status = CheckBoxTree.data(node.getChildAt(0)).isSelected();
        for (int i = 1; i < node.getChildCount() && status != null; ++i) {
            if (status.equals(CheckBoxTree.data(node.getChildAt(i)).isSelected())) continue;
            return null;
        }
        return status;
    }

    private static void changeParents(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parent;
        if (node != null && (parent = CheckBoxTree.node(node.getParent())) != null) {
            CheckBoxNodeData dataParent = CheckBoxTree.data(parent);
            Boolean childStatus = CheckBoxTree.childStatus(parent);
            if (childStatus != null && !childStatus.equals(dataParent.isSelected())) {
                dataParent.setSelected(childStatus);
                CheckBoxTree.changeParents(parent);
            }
        }
    }

    private static void nodeChanged(DefaultMutableTreeNode node) {
        if (node != null) {
            CheckBoxTree.changeParents(node);
            CheckBoxTree.setChildrens(node, CheckBoxTree.data(node).isSelected());
        }
    }

    private static void setChildrens(DefaultMutableTreeNode node, Boolean value) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = CheckBoxTree.node(node.getChildAt(i));
            CheckBoxNodeData childData = CheckBoxTree.data(childNode);
            CheckBoxNodeData nodeData = CheckBoxTree.data(node);
            if (childData == null || nodeData == null || Objects.equals(childData.isSelected(), nodeData.isSelected())) continue;
            CheckBoxTree.data(childNode).setSelected(CheckBoxTree.data(node).isSelected());
            CheckBoxTree.setChildrens(childNode, value);
        }
    }

    public DefaultMutableTreeNode rootNode() {
        return CheckBoxTree.node(this.getModel().getRoot());
    }

    public LayerGroup rootLayer() {
        return (LayerGroup)this.rootData().getAbstractLayer();
    }

    public CheckBoxNodeData rootData() {
        return CheckBoxTree.data(this.rootNode());
    }

    private static DefaultMutableTreeNode node(Object node) {
        return (DefaultMutableTreeNode)node;
    }

    public static CheckBoxNodeData data(DefaultMutableTreeNode node) {
        return node == null ? null : (CheckBoxNodeData)node.getUserObject();
    }

    private static CheckBoxNodeData data(Object node) {
        return CheckBoxTree.data(CheckBoxTree.node(node));
    }

    private static DefaultMutableTreeNode add(DefaultMutableTreeNode parent, String text, boolean checked) {
        CheckBoxNodeData data = new CheckBoxNodeData(text, checked);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(data);
        parent.add(node);
        return node;
    }

    public static CheckBoxNodeData createNodeData(AbstractLayer layer) {
        return new CheckBoxNodeData(layer);
    }

    public static DefaultMutableTreeNode createNode(AbstractLayer layer) {
        return new DefaultMutableTreeNode(CheckBoxTree.createNodeData(layer));
    }

    public Layer addLayer(String name) {
        Layer layer = new Layer(name);
        this.addLayer(layer);
        return layer;
    }

    public DefaultMutableTreeNode addLayer(AbstractLayer layer) {
        if (layer != null) {
            DefaultMutableTreeNode parent;
            if (layer.getParent() == null) {
                this.rootLayer().add(layer);
                parent = this.rootNode();
            } else {
                parent = this.searchNode(layer.getParent());
                if (parent == null) {
                    parent = this.addLayer(layer.getParent());
                }
            }
            return this.add(parent, layer);
        }
        return null;
    }

    public DefaultMutableTreeNode add(DefaultMutableTreeNode parent, AbstractLayer layer) {
        layer.setVisible(CheckBoxTree.data(parent).isSelected());
        DefaultMutableTreeNode node = CheckBoxTree.createNode(layer);
        parent.add(node);
        ((DefaultTreeModel)this.getModel()).reload();
        return node;
    }

    public DefaultMutableTreeNode searchNode(AbstractLayer layer) {
        return this.searchNode(this.rootNode(), layer);
    }

    public DefaultMutableTreeNode searchNode(DefaultMutableTreeNode node, AbstractLayer layer) {
        CheckBoxNodeData data = CheckBoxTree.data(node);
        if (data.getAbstractLayer() == layer) {
            return node;
        }
        DefaultMutableTreeNode found = null;
        for (int i = 0; i < node.getChildCount() && found == null; ++i) {
            found = this.searchNode((DefaultMutableTreeNode)node.getChildAt(i), layer);
        }
        return found;
    }
}

