/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class AbstractDataSource
implements DBPDataSource,
DBSObject {
    @NotNull
    protected final DBPDataSourceContainer container;
    private final Map<String, Object> contextAttributes = new LinkedHashMap<String, Object>();

    public AbstractDataSource(@NotNull DBPDataSourceContainer container) {
        this.container = container;
    }

    @Override
    @NotNull
    public DBPDataSourceContainer getContainer() {
        return this.container;
    }

    @Override
    @NotNull
    public DBPDataSource getDataSource() {
        return this;
    }

    @Override
    public DBSObject getParentObject() {
        return this.container;
    }

    @Override
    @NotNull
    public String getName() {
        return this.container.getName();
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.container.getDescription();
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    @Override
    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    @Override
    public Map<String, ?> getContextAttributes() {
        return new LinkedHashMap<String, Object>(this.contextAttributes);
    }

    @Override
    public <T> T getContextAttribute(String attributeName) {
        return (T)this.contextAttributes.get(attributeName);
    }

    @Override
    public <T> void setContextAttribute(String attributeName, T attributeValue) {
        this.contextAttributes.put(attributeName, attributeValue);
    }

    @Override
    public void removeContextAttribute(String attributeName) {
        this.contextAttributes.remove(attributeName);
    }
}

