/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageDatabaseEditors
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.editors";
    private Button keepEditorsOnRestart;
    private Button keepEditorsOnDisconnect;
    private Button disconnectOnEditorsClose;
    private Button refreshEditorOnOpen;
    private Button editorFullName;
    private Button showTableGrid;
    private Button showPreviewOnSave;
    private Button syncEditorDataSourceWithNavigator;

    public PrefPageDatabaseEditors() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        Group groupEditors = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_editors, (int)1, (int)2, (int)0);
        this.keepEditorsOnRestart = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_keep_database_editors, (boolean)store.getBoolean("ui.editors.reopen-after-restart"));
        this.keepEditorsOnRestart.setToolTipText(CoreMessages.pref_page_ui_general_keep_database_editors_tip);
        this.keepEditorsOnDisconnect = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_keep_database_editors_on_disconnect, (String)CoreMessages.pref_page_ui_general_keep_database_editors_on_disconnect_tip, (boolean)store.getBoolean("ui.editors.keep-editors-on-disconnect"), (int)1);
        this.disconnectOnEditorsClose = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_disconnect_on_editors_close, (String)CoreMessages.pref_page_ui_general_disconnect_on_editors_close_tip, (boolean)store.getBoolean("ui.editors.disconnect-on-editors-close"), (int)1);
        this.refreshEditorOnOpen = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_refresh_editor_on_open, (boolean)store.getBoolean("navigator.refresh.editor.open"));
        this.refreshEditorOnOpen.setToolTipText(CoreMessages.pref_page_ui_general_refresh_editor_on_open_tip);
        this.editorFullName = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_show_full_name_in_editor, (boolean)store.getBoolean("navigator.editor.full-name"));
        this.showTableGrid = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_show_table_grid, (boolean)store.getBoolean("navigator.editor.showGrid"));
        this.showPreviewOnSave = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_show_preview_on_save, (boolean)store.getBoolean("navigator.editor.show.preview"));
        this.syncEditorDataSourceWithNavigator = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_database_general_label_sync_editor_connection_with_navigator, (String)CoreMessages.pref_page_database_general_label_sync_editor_connection_with_navigator_tip, (boolean)store.getBoolean("navigator.sync.editor.datasource"), (int)2);
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.keepEditorsOnRestart.setSelection(store.getDefaultBoolean("ui.editors.reopen-after-restart"));
        this.keepEditorsOnDisconnect.setSelection(store.getDefaultBoolean("ui.editors.keep-editors-on-disconnect"));
        this.disconnectOnEditorsClose.setSelection(store.getDefaultBoolean("ui.editors.disconnect-on-editors-close"));
        this.refreshEditorOnOpen.setSelection(store.getDefaultBoolean("navigator.refresh.editor.open"));
        this.editorFullName.setSelection(store.getDefaultBoolean("navigator.editor.full-name"));
        this.showTableGrid.setSelection(store.getDefaultBoolean("navigator.editor.showGrid"));
        this.showPreviewOnSave.setSelection(store.getDefaultBoolean("navigator.editor.show.preview"));
        this.syncEditorDataSourceWithNavigator.setSelection(store.getDefaultBoolean("navigator.sync.editor.datasource"));
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("ui.editors.reopen-after-restart", this.keepEditorsOnRestart.getSelection());
        store.setValue("ui.editors.keep-editors-on-disconnect", this.keepEditorsOnDisconnect.getSelection());
        store.setValue("ui.editors.disconnect-on-editors-close", this.disconnectOnEditorsClose.getSelection());
        store.setValue("navigator.refresh.editor.open", this.refreshEditorOnOpen.getSelection());
        store.setValue("navigator.editor.full-name", this.editorFullName.getSelection());
        store.setValue("navigator.editor.showGrid", this.showTableGrid.getSelection());
        store.setValue("navigator.editor.show.preview", this.showPreviewOnSave.getSelection());
        store.setValue("navigator.sync.editor.datasource", this.syncEditorDataSourceWithNavigator.getSelection());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return true;
    }

    public void applyData(Object data) {
        super.applyData(data);
    }

    @Nullable
    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

