/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorContent;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeLoadService;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeLoadVisualizer;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeFilter;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeFilterSearch;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeLazyExpander;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSearch;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.utils.CommonUtils;

public class DatabaseNavigatorContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private static final Log log = Log.getLog(DatabaseNavigatorContentProvider.class);
    private static final Object[] EMPTY_CHILDREN = new Object[0];
    private final DatabaseNavigatorTree navigatorTree;
    private final boolean showRoot;

    public DatabaseNavigatorContentProvider(DatabaseNavigatorTree navigatorTree, boolean showRoot) {
        this.navigatorTree = navigatorTree;
        this.showRoot = showRoot;
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof DatabaseNavigatorContent) {
            DatabaseNavigatorContent content = (DatabaseNavigatorContent)parent;
            DBNNode rootNode = content.getRootNode();
            if (rootNode == null) {
                return EMPTY_CHILDREN;
            }
            if (this.showRoot) {
                return new Object[]{rootNode};
            }
            return this.getChildren(rootNode);
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof DBNLocalFolder) {
            DBNLocalFolder node = (DBNLocalFolder)child;
            return node.getLogicalParent();
        }
        if (child instanceof DBNNode) {
            DBNNode node = (DBNNode)child;
            return node.getParentNode();
        }
        if (child instanceof TreeNodeSpecial) {
            TreeNodeSpecial node = (TreeNodeSpecial)child;
            return node.getParent();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Object[] getChildren(Object parent) {
        void parentNode;
        if (parent instanceof TreeNodeSpecial) {
            return EMPTY_CHILDREN;
        }
        if (!(parent instanceof DBNNode)) {
            return EMPTY_CHILDREN;
        }
        DBNNode dBNNode = (DBNNode)parent;
        if (!parentNode.hasChildren(true)) {
            return EMPTY_CHILDREN;
        }
        if (parentNode instanceof DBNLazyNode && ((DBNLazyNode)parentNode).needsInitialization()) {
            return TreeLoadVisualizer.expandChildren((AbstractTreeViewer)this.navigatorTree.getViewer(), new TreeLoadService("Loading", (DBNNode)parentNode));
        }
        try {
            DBNNode[] children = DBNUtils.getNodeChildrenFiltered((DBRProgressMonitor)new VoidProgressMonitor(), (DBNNode)parentNode, (boolean)true);
            if (children == null) {
                Throwable lastLoadError = parentNode.getLastLoadError();
                if (lastLoadError != null) {
                    UIUtils.asyncExec(() -> {
                        DBPPlatformUI.UserResponse userResponse = DBWorkbench.getPlatformUI().showError("Error during node load", CommonUtils.notEmpty((String)lastLoadError.getMessage()), lastLoadError);
                    });
                }
                return EMPTY_CHILDREN;
            }
            return this.getFinalNodes((DBNNode)parentNode, children);
        }
        catch (Throwable ex) {
            UIUtils.asyncExec(() -> {
                DBWorkbench.getPlatformUI().showError("Navigator error", ex.getMessage(), ex);
                this.navigatorTree.getViewer().collapseToLevel(parent, 1);
            });
            return EMPTY_CHILDREN;
        }
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof DBNDatabaseNode) {
            if (this.navigatorTree.getNavigatorFilter() != null && this.navigatorTree.getNavigatorFilter().isLeafObject(parent)) {
                return false;
            }
            if (((DBNDatabaseNode)parent).getDataSourceContainer().getNavigatorSettings().isShowOnlyEntities() && ((DBNDatabaseNode)parent).getObject() instanceof DBSEntity) {
                return false;
            }
        }
        return parent instanceof DBNNode && ((DBNNode)parent).hasChildren(true);
    }

    @NotNull
    private Object[] getFinalNodes(@NotNull DBNNode parent, @NotNull DBNNode[] children) {
        int maxFetchSize = Math.max(100, DBWorkbench.getPlatform().getPreferenceStore().getInt("navigator.long.list.fetch.size"));
        boolean searchBarIsActive = this.isSearchBarActive(children);
        if (parent.isFiltered() || maxFetchSize < children.length) {
            ArrayList<TreeNodeSpecial> nodes = new ArrayList<TreeNodeSpecial>(maxFetchSize);
            if (parent.isFiltered()) {
                if (searchBarIsActive) {
                    nodes.add(new TreeNodeFilterSearch(parent));
                } else {
                    nodes.add(new TreeNodeFilter(parent));
                }
            }
            if (maxFetchSize < children.length) {
                nodes.addAll(List.of(children).subList(0, maxFetchSize));
                nodes.add(new TreeNodeLazyExpander(parent, children, maxFetchSize));
            } else {
                nodes.addAll(List.of(children));
            }
            return nodes.toArray();
        }
        if (children.length == 0) {
            return EMPTY_CHILDREN;
        }
        if (searchBarIsActive) {
            ArrayList<TreeNodeSearch> nodes = new ArrayList<TreeNodeSearch>();
            nodes.add(new TreeNodeSearch(parent));
            nodes.addAll(List.of(children));
            return nodes.toArray();
        }
        return children;
    }

    private boolean isSearchBarActive(@NotNull DBNNode[] children) {
        boolean isMatchingNeeded;
        if (this.navigatorTree == null) {
            return false;
        }
        boolean bl = isMatchingNeeded = children.length > 0 && this.navigatorTree.isMatchingNeeded(children[0]);
        return this.navigatorTree.isFilterActive() && isMatchingNeeded;
    }
}

