/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.engine.AIEngineSettings;

public class LegacyAISettings<P extends AIEngineProperties>
implements AIEngineSettings<LegacyAISettings<P>> {
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();
    @NotNull
    private final P properties;
    @SerializedName(value="fallbackEngineId")
    @Nullable
    private String fallbackEngineId;

    public LegacyAISettings(@NotNull P properties) {
        this.properties = properties;
    }

    @NotNull
    public P getProperties() {
        return this.properties;
    }

    @Override
    public void resolveSecrets() throws DBException {
        this.properties.resolveSecrets();
    }

    @Override
    public void saveSecrets() throws DBException {
        this.properties.saveSecrets();
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        return (Map)GSON.fromJson(GSON.toJson(this.properties), type);
    }

    @Override
    @NotNull
    public LegacyAISettings<P> merge(@NotNull Map<String, Object> map) {
        HashMap<String, Object> engineProperties = new HashMap<String, Object>(this.toMap());
        engineProperties.putAll(map);
        AIEngineProperties newProperties = (AIEngineProperties)GSON.fromJson(GSON.toJsonTree(engineProperties), this.properties.getClass());
        return new LegacyAISettings<AIEngineProperties>(newProperties);
    }

    @Override
    public boolean isValid() {
        return this.properties.isValidConfiguration();
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.properties.isLoggingEnabled();
    }

    @Override
    @Nullable
    public String fallbackEngineId() {
        return this.fallbackEngineId;
    }

    public void setFallbackEngineId(@Nullable String fallbackEngineId) {
        this.fallbackEngineId = fallbackEngineId;
    }
}

