/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine;

import java.util.concurrent.atomic.AtomicReference;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.engine.AIEngine;
import org.jkiss.dbeaver.model.ai.registry.AISettingsEventListener;
import org.jkiss.dbeaver.model.ai.registry.AISettingsRegistry;

public abstract class AIEngineFactory<T extends AIEngine>
implements AISettingsEventListener {
    private static final Log log = Log.getLog(AIEngineFactory.class);
    @NotNull
    protected final AISettingsRegistry registry;
    private final AtomicReference<T> engine = new AtomicReference();

    public AIEngineFactory(@NotNull AISettingsRegistry registry) {
        this.registry = registry;
        this.registry.addChangedListener(this);
    }

    public T getEngine() throws DBException {
        return (T)((AIEngine)this.engine.updateAndGet(currentEngine -> {
            if (currentEngine == null) {
                try {
                    return this.createEngine();
                }
                catch (DBException e) {
                    throw new RuntimeException("Failed to create AI engine", e);
                }
            }
            return currentEngine;
        }));
    }

    @NotNull
    protected abstract T createEngine() throws DBException;

    @Override
    public void onSettingsUpdate(@NotNull AISettingsRegistry registry) {
        AIEngine andSet = this.engine.getAndSet(null);
        if (andSet != null) {
            try {
                andSet.close();
            }
            catch (DBException e) {
                log.error((Object)"Failed to close AI engine", (Throwable)e);
            }
        }
    }
}

