/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridCharset;
import org.jkiss.dbeaver.ext.cubrid.model.CubridCollation;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTable;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;

public class CubridPartition
extends CubridTable
implements DBSTablePartition {
    private CubridTable parentTable;
    private String partitionName;
    private String expression;
    private String expressionValues;
    private String comment;

    public CubridPartition(@NotNull CubridTable table, @NotNull String className, @NotNull String type, @NotNull JDBCResultSet dbResult) {
        super((GenericStructContainer)table.getContainer(), className, type, dbResult);
        Object[] partitions;
        this.parentTable = table;
        this.partitionName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"partition_name");
        this.expression = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"partition_expr").replace("[", "").replace("]", "");
        this.comment = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
        this.expressionValues = "RANGE".equals(type) ? ((partitions = (Object[])JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"partition_values"))[1] == null ? "MAXVALUE" : partitions[1].toString()) : Arrays.toString((Object[])JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"partition_values")).replace("[", "").replace("]", "");
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public CubridTable getParentTable() {
        return this.parentTable;
    }

    public boolean isSubPartition() {
        return false;
    }

    public DBSTablePartition getPartitionParent() {
        return null;
    }

    @Property(viewable=true, order=1)
    public String getName() {
        return super.getName();
    }

    @Override
    @Property(viewable=true, order=2)
    public GenericSchema getSchema() {
        return super.getSchema();
    }

    @Property(viewable=true, order=3)
    @NotNull
    public String getTableType() {
        return super.getTableType();
    }

    @Property(viewable=true, order=5)
    @NotNull
    public String getExpression() {
        return this.expression;
    }

    @Property(viewable=true, order=6)
    @NotNull
    public String getExpressionValues() {
        return this.expressionValues;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.comment;
    }

    @Override
    @Property(hidden=true)
    public boolean isPartitioned() {
        return super.isPartitioned();
    }

    @Override
    @Property(hidden=true)
    public CubridCollation getCollation() {
        return super.getCollation();
    }

    @Override
    @Property(hidden=true)
    public boolean isReuseOID() {
        return super.isReuseOID();
    }

    @Override
    @Property(hidden=true)
    public Integer getAutoIncrement() {
        return super.getAutoIncrement();
    }

    @Override
    @Property(hidden=true)
    public CubridCharset getCharset() {
        return super.getCharset();
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return this.getDataSource().getMetaModel().getTableDDL(monitor, (GenericTableBase)this.getParentTable(), options);
    }
}

