/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTrigger;
import org.jkiss.dbeaver.ext.generic.edit.GenericTriggerManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class CubridTriggerManager
extends GenericTriggerManager<CubridTrigger> {
    public static final String BASE_TRIGGER_NAME = "new_trigger";

    public boolean canCreateObject(@NotNull Object container) {
        CubridTable table = (CubridTable)((Object)container);
        boolean isShard = table.getDataSource().isShard();
        return isShard ? false : container instanceof GenericTableBase;
    }

    protected CubridTrigger createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        return new CubridTrigger((GenericTableBase)container, BASE_TRIGGER_NAME, monitor);
    }

    public void createTrigger(CubridTrigger trigger, StringBuilder sb) {
        sb.append("\n").append(trigger.getActionTime()).append(" ");
        if (trigger.getEvent().equals("COMMIT") || trigger.getEvent().equals("ROLLBACK")) {
            sb.append(trigger.getEvent());
        } else {
            sb.append(trigger.getEvent());
            sb.append(" ON ").append(trigger.getTable().getUniqueName());
            if (trigger.getEvent().contains("UPDATE") && trigger.getTargetColumn() != null) {
                sb.append("(").append(trigger.getTargetColumn()).append(")");
            }
            if (trigger.getCondition() != null) {
                sb.append("\nIF ").append(trigger.getCondition());
            }
        }
        sb.append("\nEXECUTE ");
        if (trigger.getActionType().equals("REJECT") || trigger.getActionType().equals("INVALIDATE TRANSACTION")) {
            sb.append(trigger.getActionType());
        } else if (trigger.getActionType().equals("PRINT")) {
            sb.append(trigger.getActionType()).append(" ");
            sb.append(trigger.getActionDefinition() == null ? "" : SQLUtils.quoteString((DBSObject)trigger, (String)trigger.getActionDefinition()));
        } else {
            sb.append(trigger.getActionDefinition() == null ? "" : trigger.getActionDefinition());
        }
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        CubridTrigger trigger = (CubridTrigger)command.getObject();
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TRIGGER ").append(trigger.getFullyQualifiedName(DBPEvaluationContext.DDL));
        sb.append(trigger.getActive() ? "\nSTATUS ACTIVE" : "\nSTATUS INACTIVE");
        sb.append("\nPRIORITY ").append(trigger.getPriority());
        this.createTrigger(trigger, sb);
        if (trigger.getDescription() != null) {
            sb.append("\nCOMMENT ").append(SQLUtils.quoteString((DBSObject)trigger, (String)trigger.getDescription()));
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Trigger", sb.toString()));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        CubridTrigger trigger = (CubridTrigger)command.getObject();
        String triggerName = trigger.getFullyQualifiedName(DBPEvaluationContext.DDL);
        if (command.hasProperty((Object)"active")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("ALTER TRIGGER " + triggerName + " STATUS " + (trigger.getActive() ? "ACTIVE" : "INACTIVE")));
        }
        if (command.hasProperty((Object)"priority")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("ALTER TRIGGER " + triggerName + " PRIORITY " + String.valueOf(trigger.getPriority())));
        }
        if (command.hasProperty((Object)"description")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("ALTER TRIGGER " + triggerName + " COMMENT " + SQLUtils.quoteString((DBSObject)trigger, (String)CommonUtils.notEmpty((String)trigger.getDescription()))));
        }
    }

    public boolean canEditObject(CubridTrigger object) {
        return !((CubridDataSource)object.getDataSource()).isShard();
    }

    public boolean canDeleteObject(CubridTrigger object) {
        return !((CubridDataSource)object.getDataSource()).isShard();
    }
}

